package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.EntidadHistoricoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.EntidadHistorico;

/**
 *  * EntidadHistoricoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/entidadhistorico")

public class EntidadHistoricoController  {

	private static final Logger logger = LoggerFactory.getLogger(EntidadHistoricoController.class);

	@Autowired
	private EntidadHistoricoService entidadHistoricoService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("entidadhistorico", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  identhist String
	 * @return String
	 */
	@RequestMapping(value = "/{identhist}", method = RequestMethod.GET)
	public @ResponseBody EntidadHistorico getById(@PathVariable String identhist) {
		try{
            EntidadHistorico entidadHistorico = new EntidadHistorico();
			entidadHistorico.setIdenthist(identhist);
			entidadHistorico = this.entidadHistoricoService.find(entidadHistorico);
            if (entidadHistorico == null) {
                throw new Exception(identhist.toString());
            }
            return entidadHistorico;
		}catch (Exception e){
		    throw new ResourceNotFoundException(identhist.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  identhist String
	 *@param	  contactoId String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "identhist", required = false) String identhist,
			HttpServletRequest request) {
			try{
				EntidadHistorico filterEntidadHistorico = new EntidadHistorico(identhist);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<EntidadHistorico> entidadHistoricos =  this.entidadHistoricoService.findAll(filterEntidadHistorico, pagination);

     			    if (entidadHistoricos == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterEntidadHistorico, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(entidadHistoricos);
				    return data;
				}else{
				    List<EntidadHistorico> entidadHistoricos =  this.entidadHistoricoService.findAll(filterEntidadHistorico, pagination);
					if (entidadHistoricos == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return entidadHistoricos;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}
	
	/**
	 * Method 'getAllObservacionesByIdEntidad'.
	 * 
	 * @param entidadId
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Object
	 */
	@RequestMapping(value = "/listadoObserv/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllContactosByIdEntidad(@PathVariable String entidadId,
			HttpServletRequest request) {
		try {

			EntidadHistorico entidadhistorico = new EntidadHistorico();
			entidadhistorico.setEntidadId(entidadId);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<EntidadHistorico> listobserv = this.entidadHistoricoService
						.findAll(entidadhistorico, pagination);

				if (listobserv == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.entidadHistoricoService
						.findAllCount(entidadhistorico);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listobserv);
				return data;
			} else {
				List<EntidadHistorico> contactos = this.entidadHistoricoService
						.findAll(entidadhistorico, pagination);
				if (contactos == null) {
					throw new Exception(
							"No data Found. /entidadhistorico/listadoObserv/{entidadId}");
				}
				return contactos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(
					"No data Found. /entidadhistorico/listadoObserv/{entidadId}");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterEntidadHistorico EntidadHistorico 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "entidadHistorico", required = false) EntidadHistorico  filterEntidadHistorico, HttpServletRequest request) {
	    try {
			return entidadHistoricoService
					.findAllCount(filterEntidadHistorico != null ? filterEntidadHistorico
							: new EntidadHistorico ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param entidadHistorico EntidadHistorico 
	 * @param response HttpServletResponse
	 * @return EntidadHistorico
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody EntidadHistorico edit(@RequestBody EntidadHistorico entidadHistorico, HttpServletResponse response) {		
		try {
            EntidadHistorico entidadHistoricoAux  = this.entidadHistoricoService.update(entidadHistorico);
			logger.info("Entity correctly inserted!");
            return entidadHistoricoAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param entidadHistorico EntidadHistorico 
	 * @return EntidadHistorico
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody EntidadHistorico add(@RequestBody EntidadHistorico entidadHistorico) {		
        try {
            EntidadHistorico entidadHistoricoAux = this.entidadHistoricoService.add(entidadHistorico);
            logger.info("Entity correctly inserted!");
        	return entidadHistoricoAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  identhist  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{identhist}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String identhist,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            EntidadHistorico entidadHistorico = new EntidadHistorico();
            entidadHistorico.setIdenthist(identhist);
            this.entidadHistoricoService.remove(entidadHistorico);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  identhist);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  entidadHistoricoIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> entidadHistoricoIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<EntidadHistorico> entidadHistoricoList = new ArrayList<EntidadHistorico>();
        try{		    
            for (ArrayList<String> entidadHistoricoId:entidadHistoricoIds) {
			    Iterator<String> iterator = entidadHistoricoId.iterator();
				    EntidadHistorico entidadHistorico = new EntidadHistorico();
			        entidadHistorico.setIdenthist(ObjectConversionManager.convert(iterator.next(), String.class));
			        entidadHistoricoList.add(entidadHistorico);
		    }
            this.entidadHistoricoService.removeMultiple(entidadHistoricoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEntidadHistoricoService'.
	 *
	 * @return EntidadHistoricoService
	 */
	protected EntidadHistoricoService getEntidadHistoricoService() {
		return this.entidadHistoricoService;
	}

	/**
	 * Method 'setEntidadHistoricoService'.
	 *
	 * @param entidadHistoricoService  EntidadHistoricoService
	 * @return
	 */
	public void setEntidadHistoricoService(EntidadHistoricoService entidadHistoricoService) {
		this.entidadHistoricoService = entidadHistoricoService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
