package com.ejie.y40a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Contacto;
import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.model.EntidadDetalle;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusquedaCartas;
import com.ejie.y40a.model.Y40aArbolFormaciones;
import com.ejie.y40a.service.ArbolHistoricoSolicitudesService;
import com.ejie.y40a.service.ContactoService;
import com.ejie.y40a.service.EntidadService;
import com.ejie.y40a.service.SolicitudService;
import com.ejie.y40a.service.Y40aExcelGeneratorService;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.tree.Y40aFormacionesTree;

/**
 * * EntidadController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/entidad")
public class EntidadController {

	private static final Logger logger = LoggerFactory
			.getLogger(EntidadController.class);

	@Autowired
	private EntidadService entidadService;

	@Autowired
	private SolicitudService solicitudService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y40aExcelGeneratorService y40aExcelGeneratorService;

	@Autowired
	private ArbolHistoricoSolicitudesService arbolHistoricoSolicitudesService;

	@Autowired
	private ContactoService contactoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("entidad", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aTabsBusquedaDetalleSolicitante", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aTabsBusquedaDetalleSolicitante(
			Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("y40aTabsBusquedaDetalleSolicitante", "model",
				model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aTabBusquedaSolicitante", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aTabBusquedaSolicitante(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("y40aTabBusquedaSolicitante", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aTabDetalleSolicitante", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aTabDetalleSolicitante(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("y40aTabDetalleSolicitante", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param idEntidadModal
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "y40aSolicitanteFicha", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aSolicitanteFicha(
			Model model,
			@RequestParam(value = "idEntidadModal", required = false) String idEntidadModal) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		if (idEntidadModal != null) {
			model.addAttribute("idEntidadModal", idEntidadModal);
		} else {
			model.addAttribute("idEntidadModal", "");
		}
		return new ModelAndView("y40aSolicitanteFicha", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aHistoricoObserv", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aEntidadHistoricoObserv(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		return new ModelAndView("y40aHistoricoObserv", "model", model);
	}

	/**
	 * Method 'getAllContactosByIdEntidad'.
	 * 
	 * @param entidadId
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Object
	 */
	@RequestMapping(value = "/contactos/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllContactosByIdEntidad(@PathVariable String entidadId,
			HttpServletRequest request) {
		try {

			Entidad entidad = new Entidad();
			entidad.setEntidadId(entidadId);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Contacto> contactos = this.contactoService
						.findAllContactoEntidad(entidad, pagination);

				if (contactos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.contactoService
						.findAllContactoEntidadCount(entidad);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(contactos);
				return data;
			} else {
				List<Contacto> contactos = this.contactoService
						.findAllContactoEntidad(entidad, pagination);
				if (contactos == null) {
					throw new Exception(
							"No data Found. /entidad/contactos/{entidadId}");
				}
				return contactos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(
					"No data Found. /entidad/contactos/{entidadId}");
		}
	}

	/**
	 * Method 'getByIdEntidad'.
	 * 
	 * @param entidadId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/entidadbyid/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody
	EntidadDetalle getByIdEntidad(@PathVariable String entidadId) {
		try {
			EntidadDetalle entidadDetalle = new EntidadDetalle();
			entidadDetalle.setEntidadId(entidadId);
			entidadDetalle = this.solicitudService
					.findEntidadSolicitante(entidadDetalle);

			if (entidadDetalle == null) {
				throw new Exception(entidadId.toString());
			}
			return entidadDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(entidadId.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param entidadId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody
	Entidad getById(@PathVariable String entidadId) {
		try {
			Entidad entidad = new Entidad();
			entidad.setEntidadId(entidadId);
			entidad = this.entidadService.find(entidad);
			if (entidad == null) {
				throw new Exception(entidadId.toString());
			}
			return entidad;
		} catch (Exception e) {
			throw new ResourceNotFoundException(entidadId.toString());
		}
	}

	/**
	 * Loading Main tree de la lista de solicitudes aceptadas
	 * 
	 * 
	 * @param idEntidad
	 *            String
	 * @param mostrarSolicitudes
	 *            boolean
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "arbolSolicitudes", method = RequestMethod.GET)
	public void showListaEtiquetas(
			@RequestParam(value = "idEntidad", required = false) String idEntidad,
			@RequestParam(value = "mostrarSolicitudes", required = false) boolean mostrarSolicitudes,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		try {

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("text/html;charset=utf-8");
			PrintWriter out = response.getWriter();

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			Y40aArbolFormaciones arbolFormaciones = this.arbolHistoricoSolicitudesService
					.obtenerArbol(mostrarSolicitudes, idEntidad, perfiles, null);

			String json = Y40aFormacionesTree
					.obtieneJsonArbol(arbolFormaciones);

			out.println(json);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("arbolSolicitudes");
		}

	}

	/**
	 * Metodo para generar un archivo excel con los filtrados en busqueda por
	 * solicitante
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            BigDecimal
	 * @param sinPlanificar_
	 *            BigDecimal
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param fechaSolicitudDesde_
	 *            String
	 * @param fechaSolicitudHasta_
	 *            String
	 * @param radioEtiquetas_
	 *            String
	 * @param sortorder_
	 *            String
	 * @param sortname_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBusquedaSolicitantes", method = RequestMethod.GET)
	public void getExcelBusquedaSolicitantes(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "sinPlanificarTodas", required = false) String sinPlanificarTodas_,
			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde_,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta_,
			@RequestParam(value = "radioEtiquetas", required = false) String radioEtiquetas_,
			@RequestParam(value = "sortorder", required = false) String sortorder_,
			@RequestParam(value = "sortname", required = false) String sortname_,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);

			Date fechaSolicitudDesde = Y40aUtils.parseDate(
					fechaSolicitudDesde_, locale);
			Date fechaSolicitudHasta = Y40aUtils.parseDate(
					fechaSolicitudHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;

			String radioEtiquetas = ("".equals(radioEtiquetas_)) ? null
					: radioEtiquetas_;

			if (radioEtiquetas == null) {
				radioEtiquetas = "T";
			}

			// control checks
			String sinPlanificarTodas = ("on".equals(sinPlanificarTodas_)) ? Y40aConstantes.SI
					: null;

			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;

			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;

			Pagination pagination = new Pagination();
			pagination.setSort(sortname_);
			pagination.setAscDsc(sortorder_);

			PlanificacionSolicitanteBusqueda filterPlanificacionSolicitanteBusqueda = new PlanificacionSolicitanteBusqueda();
			filterPlanificacionSolicitanteBusqueda.setIdCat(idCat);
			filterPlanificacionSolicitanteBusqueda.setEntidadId(entidadId);
			filterPlanificacionSolicitanteBusqueda
					.setIdsEtiquetas(idsEtiquetas);
			filterPlanificacionSolicitanteBusqueda
					.setSinPlanificarTodas(sinPlanificarTodas);
			filterPlanificacionSolicitanteBusqueda
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionSolicitanteBusqueda
					.setPlanificados(planificados);
			filterPlanificacionSolicitanteBusqueda
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionSolicitanteBusqueda
					.setFechaImparticionHasta(fechaImparticionHasta);

			filterPlanificacionSolicitanteBusqueda
					.setFechaSolicitudDesde(fechaSolicitudDesde);
			filterPlanificacionSolicitanteBusqueda
					.setFechaSolicitudHasta(fechaSolicitudHasta);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionSolicitanteBusqueda.setEtiquetas(etiquetas);
			filterPlanificacionSolicitanteBusqueda
					.setRadioEtiquetas(radioEtiquetas);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			List<PlanificacionSolicitanteBusqueda> planificacionSolicitanteBusquedaList = this.solicitudService
					.findAllPlanificacionSolicitante(
							filterPlanificacionSolicitanteBusqueda, perfiles,
							pagination);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombreform = Y40aConstantes.NB_EXCEL_PLANIFICACION_SOLICITANTE_BUSQUEDA
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreform + "\"");

			String xslString = this.y40aExcelGeneratorService
					.getPlanificacionSolicitanteBusquedaListaExcel(planificacionSolicitanteBusquedaList);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Metodo para generar un archivo excel con los filtrados en busqueda por
	 * solicitante
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param sinPlanificar_
	 *            String
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelDetalleSolicitantes", method = RequestMethod.GET)
	public void getExcelDetalleSolicitantes(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,

			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;

			// control checks
			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;

			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;

			Pagination pagination = null;
			PlanificacionFormacionBusqueda filterPlanificacionFormacionBusqueda = new PlanificacionFormacionBusqueda();
			filterPlanificacionFormacionBusqueda.setIdCat(idCat);
			filterPlanificacionFormacionBusqueda.setEntidadId(entidadId);
			filterPlanificacionFormacionBusqueda.setIdsEtiquetas(idsEtiquetas);
			filterPlanificacionFormacionBusqueda
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionFormacionBusqueda.setPlanificados(planificados);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionHasta(fechaImparticionHasta);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionFormacionBusqueda.setEtiquetas(etiquetas);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			List<PlanificacionFormacionBusqueda> planificacionFormacionBusquedaList = this.solicitudService
					.findAllPlanificacionFormacion(
							filterPlanificacionFormacionBusqueda, perfiles,
							pagination);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombreform = Y40aConstantes.NB_EXCEL_PLANIFICACION_SOLICITANTE_DETALLE
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreform + "\"");

			String xslString = this.y40aExcelGeneratorService
					.getPlanificacionSolicitanteDetalleListaExcel(planificacionFormacionBusquedaList);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Metodo para generar un archivo excel con cabecera con los filtrados en
	 * busqueda por solicitante
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param sinPlanificar_
	 *            String
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param entidadIdBusquedaSol_
	 *            String
	 * @param radioEtiquetas_
	 *            String
	 * @param sortorder_
	 *            String
	 * @param sortname_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelCabDetalleSolicitantes", method = RequestMethod.GET)
	public void getExcelCabDetalleSolicitantes(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			@RequestParam(value = "entidadIdBusquedaSol", required = false) String entidadIdBusquedaSol_,
			@RequestParam(value = "radioEtiquetas", required = false) String radioEtiquetas_, // ññ
			@RequestParam(value = "sortorder", required = false) String sortorder_,
			@RequestParam(value = "sortname", required = false) String sortname_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String entidadIdBusquedaSol = ("".equals(entidadIdBusquedaSol_)) ? null
					: entidadIdBusquedaSol_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;

			String radioEtiquetas = ("".equals(radioEtiquetas_)) ? null
					: radioEtiquetas_;

			if (radioEtiquetas == null) {
				radioEtiquetas = "T";
			}

			// control checks
			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;

			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;

			Pagination pagination = new Pagination();
			pagination.setSort(sortname_);
			pagination.setAscDsc(sortorder_);

			PlanificacionFormacionBusqueda filterPlanificacionFormacionBusqueda = new PlanificacionFormacionBusqueda();
			filterPlanificacionFormacionBusqueda.setIdCat(idCat);
			if (entidadIdBusquedaSol != null) {
				filterPlanificacionFormacionBusqueda
						.setEntidadId(entidadIdBusquedaSol);
			} else {
				filterPlanificacionFormacionBusqueda.setEntidadId(entidadId);
			}
			filterPlanificacionFormacionBusqueda.setIdsEtiquetas(idsEtiquetas);
			filterPlanificacionFormacionBusqueda
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionFormacionBusqueda.setPlanificados(planificados);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionHasta(fechaImparticionHasta);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionFormacionBusqueda.setEtiquetas(etiquetas);

			filterPlanificacionFormacionBusqueda
					.setRadioEtiquetas(radioEtiquetas);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			List<PlanificacionFormacionBusqueda> planificacionFormacionBusquedaList = this.solicitudService
					.findAllPlanificacionFormacion(
							filterPlanificacionFormacionBusqueda, perfiles,
							pagination);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombreform = Y40aConstantes.NB_EXCEL_PLANIFICACION_SOLICITANTE_DETALLE
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreform + "\"");

			String xslString = this.y40aExcelGeneratorService
					.getPlanificacionSolicitanteDetalleListaExcelCab(planificacionFormacionBusquedaList);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllSolicitantes'.
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param sinPlanificarTodas_
	 *            String
	 * @param sinPlanificar_
	 *            String
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param fechaSolicitudDesde_
	 *            String
	 * @param fechaSolicitudHasta_
	 *            String
	 * @param radioEtiquetas_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaSolicitantes", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSolicitantes(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "sinPlanificarTodas", required = false) String sinPlanificarTodas_,
			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde_,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta_,
			@RequestParam(value = "radioEtiquetas", required = false) String radioEtiquetas_,
			HttpServletRequest request) {
		try {

			// si no se ticka plaanificaados las fechas no se consideran
			// if (!"on".equals(planificados_)) {
			// fechaImparticionDesde_ = "";
			// fechaImparticionHasta_ = "";
			// }

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);

			Date fechaSolicitudDesde = Y40aUtils.parseDate(
					fechaSolicitudDesde_, locale);
			Date fechaSolicitudHasta = Y40aUtils.parseDate(
					fechaSolicitudHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;

			String radioEtiquetas = ("".equals(radioEtiquetas_)) ? null
					: radioEtiquetas_;

			if (radioEtiquetas == null) {
				radioEtiquetas = "T";
			}

			// control checks

			String sinPlanificarTodas = ("on".equals(sinPlanificarTodas_)) ? Y40aConstantes.SI
					: null;

			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;

			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;

			PlanificacionSolicitanteBusqueda filterPlanificacionSolicitanteBusqueda = new PlanificacionSolicitanteBusqueda();
			filterPlanificacionSolicitanteBusqueda.setIdCat(idCat);
			filterPlanificacionSolicitanteBusqueda.setEntidadId(entidadId);
			filterPlanificacionSolicitanteBusqueda
					.setIdsEtiquetas(idsEtiquetas);
			filterPlanificacionSolicitanteBusqueda
					.setSinPlanificarTodas(sinPlanificarTodas);
			filterPlanificacionSolicitanteBusqueda
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionSolicitanteBusqueda
					.setPlanificados(planificados);
			filterPlanificacionSolicitanteBusqueda
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionSolicitanteBusqueda
					.setFechaImparticionHasta(fechaImparticionHasta);

			filterPlanificacionSolicitanteBusqueda
					.setFechaSolicitudDesde(fechaSolicitudDesde);
			filterPlanificacionSolicitanteBusqueda
					.setFechaSolicitudHasta(fechaSolicitudHasta);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionSolicitanteBusqueda.setEtiquetas(etiquetas);
			filterPlanificacionSolicitanteBusqueda
					.setRadioEtiquetas(radioEtiquetas);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlanificacionSolicitanteBusqueda> solicitantesBusqueda = this.solicitudService
						.findAllPlanificacionSolicitante(
								filterPlanificacionSolicitanteBusqueda,
								perfiles, pagination);

				if (solicitantesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.solicitudService
						.findAllPlanificacionSolicitanteCount(
								filterPlanificacionSolicitanteBusqueda,
								perfiles);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(solicitantesBusqueda);
				return data;
			} else {
				List<PlanificacionSolicitanteBusqueda> solicitantesBusqueda = this.solicitudService
						.findAllPlanificacionSolicitante(
								filterPlanificacionSolicitanteBusqueda,
								perfiles, pagination);
				if (solicitantesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return solicitantesBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param entidadId
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param activa
	 *            String
	 * @param iskontsumogest
	 *            String
	 * @param iskontsumonet
	 *            String
	 * @param isofertaform
	 *            String
	 * @param isconsultasweb
	 *            String
	 * @param codOrg
	 *            String
	 * @param observaciones
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param usuario
	 *            String
	 * @param password
	 *            String
	 * @param isnacional
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param compleDirec
	 *            String
	 * @param orinbdco
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "nombreEs", required = false) String nombreEs,
			@RequestParam(value = "nombreEu", required = false) String nombreEu,
			@RequestParam(value = "activa", required = false) String activa,
			@RequestParam(value = "iskontsumogest", required = false) String iskontsumogest,
			@RequestParam(value = "iskontsumonet", required = false) String iskontsumonet,
			@RequestParam(value = "isofertaform", required = false) String isofertaform,
			@RequestParam(value = "isconsultasweb", required = false) String isconsultasweb,
			@RequestParam(value = "codOrg", required = false) String codOrg,
			@RequestParam(value = "observaciones", required = false) String observaciones,
			@RequestParam(value = "telefono", required = false) String telefono,
			@RequestParam(value = "fax", required = false) String fax,
			@RequestParam(value = "email", required = false) String email,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "usuario", required = false) String usuario,
			@RequestParam(value = "password", required = false) String password,
			@RequestParam(value = "isnacional", required = false) String isnacional,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String noraProvinciaId,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String noraMunicipioId,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String noraLocalidadId,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			@RequestParam(value = "compleDirec", required = false) String compleDirec,
			@RequestParam(value = "orinbdco", required = false) String orinbdco,
			HttpServletRequest request) {
		try {
			// SOLO SE VEN LOS VISIBLES
			isofertaform = Y40aConstantes.SI;
			activa = Y40aConstantes.SI;
			Entidad filterEntidad = new Entidad(entidadId, nombreEs, nombreEu,
					activa, iskontsumogest, iskontsumonet, isofertaform,
					isconsultasweb, codOrg, observaciones, telefono, fax,
					email, url, usuario, password, isnacional, noraPaisId,
					nombrePais, noraProvinciaId, nombreProvincia,
					noraMunicipioId, nombreMunicipio, noraLocalidadId,
					nombreLocalidad, noraCalleId, nombreCalle, noraCpId,
					nombreCp, noraPortalId, nombrePortal, usuultmod, fecultmod,
					compleDirec, orinbdco, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Entidad> entidads = this.entidadService.findAll(
						filterEntidad, pagination);

				if (entidads == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterEntidad, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(entidads);
				return data;
			} else {
				List<Entidad> entidads = this.entidadService.findAll(
						filterEntidad, pagination);
				if (entidads == null) {
					throw new Exception("No data Found.");
				}
				return entidads;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEntidad
	 *            Entidad
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "entidad", required = false) Entidad filterEntidad,
			HttpServletRequest request) {
		try {
			return entidadService
					.findAllCount(filterEntidad != null ? filterEntidad
							: new Entidad());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param response
	 *            HttpServletResponse
	 * @return Entidad
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Entidad edit(@RequestBody Entidad entidad, HttpServletResponse response) {
		try {
			Entidad entidadAux = this.entidadService.update(entidad);
			logger.info("Entity correctly inserted!");
			return entidadAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Entidad add(@RequestBody Entidad entidad) {
		try {
			Entidad entidadAux = this.entidadService.add(entidad);
			logger.info("Entity correctly inserted!");
			return entidadAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param entidadId
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String entidadId,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Entidad entidad = new Entidad();
			entidad.setEntidadId(entidadId);
			this.entidadService.remove(entidad);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + entidadId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param entidadIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> entidadIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Entidad> entidadList = new ArrayList<Entidad>();
		try {
			for (ArrayList<String> entidadId : entidadIds) {
				Iterator<String> iterator = entidadId.iterator();
				Entidad entidad = new Entidad();
				entidad.setEntidadId(ObjectConversionManager.convert(
						iterator.next(), String.class));
				entidadList.add(entidad);
			}
			this.entidadService.removeMultiple(entidadList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEntidadService'.
	 * 
	 * @return EntidadService
	 */
	protected EntidadService getEntidadService() {
		return this.entidadService;
	}

	/**
	 * Method 'setEntidadService'.
	 * 
	 * @param entidadService
	 *            EntidadService
	 * @return
	 */
	public void setEntidadService(EntidadService entidadService) {
		this.entidadService = entidadService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/*****************************************************/
	/**
	 * Method 'getAllLike'.
	 * 
	 * @param entidadId
	 *            String
	 * @param nombre_
	 *            String
	 * @param activa_
	 *            String
	 * @param iskontsumogest
	 *            String
	 * @param iskontsumonet
	 *            String
	 * @param isofertaform
	 *            String
	 * @param isconsultasweb
	 *            String
	 * @param codOrg
	 *            String
	 * @param observaciones
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param usuario
	 *            String
	 * @param password
	 *            String
	 * @param isnacional
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param compleDirec
	 *            String
	 * @param orinbdco
	 *            String
	 * @param gruposArr
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getEntidad", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLike(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "nombre", required = false) String nombre_,
			@RequestParam(value = "activa", required = false) String activa_,
			@RequestParam(value = "iskontsumogest", required = false) String iskontsumogest,
			@RequestParam(value = "iskontsumonet", required = false) String iskontsumonet,
			@RequestParam(value = "isofertaform", required = false) String isofertaform,
			@RequestParam(value = "isconsultasweb", required = false) String isconsultasweb,
			@RequestParam(value = "codOrg", required = false) String codOrg,
			@RequestParam(value = "observaciones", required = false) String observaciones,
			@RequestParam(value = "telefono", required = false) String telefono,
			@RequestParam(value = "fax", required = false) String fax,
			@RequestParam(value = "email", required = false) String email,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "usuario", required = false) String usuario,
			@RequestParam(value = "password", required = false) String password,
			@RequestParam(value = "isnacional", required = false) String isnacional,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String noraProvinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String noraMunicipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String noraLocalidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			@RequestParam(value = "compleDirec", required = false) String compleDirec,
			@RequestParam(value = "orinbdco", required = false) String orinbdco,
			@RequestParam(value = "gruposArr", required = false) String gruposArr,

			HttpServletRequest request) {
		try {
			isofertaform = Y40aConstantes.SI;

			String nombre = ("".equals(nombre_)) ? null : nombre_;

			String activa = "";
			if (activa_ == null) {
				activa = Y40aConstantes.SI;
			} else if (activa_.equals(Y40aConstantes.NO)) {
				activa = null;
			}

			String noraProvinciaId = ("".equals(noraProvinciaId_)) ? null
					: noraProvinciaId_;
			String noraMunicipioId = ("".equals(noraMunicipioId_)) ? null
					: noraMunicipioId_;
			String noraLocalidadId = ("".equals(noraLocalidadId_)) ? null
					: noraLocalidadId_;

			String nombreEs = null;
			String nombreEu = null;

			Locale locale = LocaleContextHolder.getLocale();

			if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				nombreEs = nombre;
			} else {
				nombreEu = nombre;
			}

			String varGruposArr = ("".equals(gruposArr)) ? null : gruposArr;

			List<Grupo> grupo = new ArrayList<Grupo>();
			Grupo grupoAux = null;

			if (null != varGruposArr && !"".equals(varGruposArr)) {
				for (String id : varGruposArr.split(",")) {
					grupoAux = new Grupo();
					grupoAux.setGrupoId(id);
					grupo.add(grupoAux);
				}
			}

			Entidad filterEntidad = new Entidad(entidadId, nombreEs, nombreEu,
					activa, iskontsumogest, iskontsumonet, isofertaform,
					isconsultasweb, codOrg, observaciones, telefono, fax,
					email, url, usuario, password, isnacional, noraPaisId,
					nombrePais, noraProvinciaId, nombreProvincia,
					noraMunicipioId, nombreMunicipio, noraLocalidadId,
					nombreLocalidad, noraCalleId, nombreCalle, noraCpId,
					nombreCp, noraPortalId, nombrePortal, usuultmod, fecultmod,
					compleDirec, orinbdco, null);

			filterEntidad.setGrupos(grupo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Entidad> entidads = this.entidadService.findAllLike(
						filterEntidad, pagination, false);

				if (entidads == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllLikeCount(filterEntidad, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(entidads);
				return data;
			} else {
				List<Entidad> entidads = this.entidadService.findAll(
						filterEntidad, pagination);
				if (entidads == null) {
					throw new Exception("No data Found.");
				}
				return entidads;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEntidad
	 *            Entidad
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllLikeCount(
			@RequestParam(value = "entidad", required = false) Entidad filterEntidad,
			HttpServletRequest request) {
		try {
			return entidadService.findAllLikeCount(
					filterEntidad != null ? filterEntidad : new Entidad(),
					false);
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/****************************************************/
	/**
	 * Metodo para generar un archivo excel con los filtrados en busqueda por
	 * solicitante
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            BigDecimal
	 * @param sinPlanificar_
	 *            BigDecimal
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param fechaSolicitudDesde_
	 *            String
	 * @param fechaSolicitudHasta_
	 *            String
	 * @param radioEtiquetas_
	 *            String
	 * @param sortorder_
	 *            String
	 * @param sortname_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelCartasBusquedaSolicitantes", method = RequestMethod.GET)
	public void getExcelCartasBusquedaSolicitantes(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "sinPlanificarTodas", required = false) String sinPlanificarTodas_,
			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde_,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta_,
			@RequestParam(value = "radioEtiquetas", required = false) String radioEtiquetas_,
			@RequestParam(value = "sortorder", required = false) String sortorder_,
			@RequestParam(value = "sortname", required = false) String sortname_,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);

			Date fechaSolicitudDesde = Y40aUtils.parseDate(
					fechaSolicitudDesde_, locale);
			Date fechaSolicitudHasta = Y40aUtils.parseDate(
					fechaSolicitudHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;

			String radioEtiquetas = ("".equals(radioEtiquetas_)) ? null
					: radioEtiquetas_;

			if (radioEtiquetas == null) {
				radioEtiquetas = "T";
			}

			// control checks

			String sinPlanificarTodas = ("on".equals(sinPlanificarTodas_)) ? Y40aConstantes.SI
					: null;

			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;

			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;

			Pagination pagination = new Pagination();
			pagination.setSort(sortname_);
			pagination.setAscDsc(sortorder_);

			PlanificacionSolicitanteBusquedaCartas filterPlanificacionSolicitanteBusquedaCartas = new PlanificacionSolicitanteBusquedaCartas();
			filterPlanificacionSolicitanteBusquedaCartas.setIdCat(idCat);
			filterPlanificacionSolicitanteBusquedaCartas
					.setEntidadId(entidadId);
			filterPlanificacionSolicitanteBusquedaCartas
					.setIdsEtiquetas(idsEtiquetas);
			filterPlanificacionSolicitanteBusquedaCartas
					.setSinPlanificarTodas(sinPlanificarTodas);
			filterPlanificacionSolicitanteBusquedaCartas
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionSolicitanteBusquedaCartas
					.setPlanificados(planificados);
			filterPlanificacionSolicitanteBusquedaCartas
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionSolicitanteBusquedaCartas
					.setFechaImparticionHasta(fechaImparticionHasta);

			filterPlanificacionSolicitanteBusquedaCartas
					.setFechaSolicitudDesde(fechaSolicitudDesde);
			filterPlanificacionSolicitanteBusquedaCartas
					.setFechaSolicitudHasta(fechaSolicitudHasta);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionSolicitanteBusquedaCartas
					.setEtiquetas(etiquetas);
			filterPlanificacionSolicitanteBusquedaCartas
					.setRadioEtiquetas(radioEtiquetas);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			List<PlanificacionSolicitanteBusquedaCartas> planificacionSolicitanteBusquedaList = this.solicitudService
					.findAllPlanificacionSolicitanteCartas(
							filterPlanificacionSolicitanteBusquedaCartas,
							perfiles, pagination);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombreform = Y40aConstantes.NB_EXCEL_PLANIFICACION_SOLICITANTE_CARTAS
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreform + "\"");

			String xslString = this.y40aExcelGeneratorService
					.getPlanificacionSolicitanteBusquedaListaExcelCartas(planificacionSolicitanteBusquedaList);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}
}