package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.EntidadContactoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.EntidadContacto;

/**
 *  * EntidadContactoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/entidadcontacto")

public class EntidadContactoController  {

	private static final Logger logger = LoggerFactory.getLogger(EntidadContactoController.class);

	@Autowired
	private EntidadContactoService entidadContactoService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("entidadcontacto", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  entidadId String
	 * @param  contactoId String
	 * @return String
	 */
	@RequestMapping(value = "/{entidadId}/{contactoId}", method = RequestMethod.GET)
	public @ResponseBody EntidadContacto getById(@PathVariable String entidadId, @PathVariable String contactoId) {
		try{
            EntidadContacto entidadContacto = new EntidadContacto();
			entidadContacto.setEntidadId(entidadId);
			entidadContacto.setContactoId(contactoId);
            entidadContacto = this.entidadContactoService.find(entidadContacto);
            if (entidadContacto == null) {
                throw new Exception(entidadId.toString() + contactoId.toString());
            }
            return entidadContacto;
		}catch (Exception e){
		    throw new ResourceNotFoundException(entidadId.toString() + contactoId.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  entidadId String
	 *@param	  contactoId String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "entidadId", required = false) String entidadId,
	@RequestParam(value = "contactoId", required = false) String contactoId,
			HttpServletRequest request) {
			try{
				EntidadContacto filterEntidadContacto = new EntidadContacto(entidadId, contactoId);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<EntidadContacto> entidadContactos =  this.entidadContactoService.findAll(filterEntidadContacto, pagination);

     			    if (entidadContactos == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterEntidadContacto, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(entidadContactos);
				    return data;
				}else{
				    List<EntidadContacto> entidadContactos =  this.entidadContactoService.findAll(filterEntidadContacto, pagination);
					if (entidadContactos == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return entidadContactos;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterEntidadContacto EntidadContacto 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "entidadContacto", required = false) EntidadContacto  filterEntidadContacto, HttpServletRequest request) {
	    try {
			return entidadContactoService
					.findAllCount(filterEntidadContacto != null ? filterEntidadContacto
							: new EntidadContacto ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param entidadContacto EntidadContacto 
	 * @param response HttpServletResponse
	 * @return EntidadContacto
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody EntidadContacto edit(@RequestBody EntidadContacto entidadContacto, HttpServletResponse response) {		
		try {
            EntidadContacto entidadContactoAux  = this.entidadContactoService.update(entidadContacto);
			logger.info("Entity correctly inserted!");
            return entidadContactoAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param entidadContacto EntidadContacto 
	 * @return EntidadContacto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody EntidadContacto add(@RequestBody EntidadContacto entidadContacto) {		
        try {
            EntidadContacto entidadContactoAux = this.entidadContactoService.add(entidadContacto);
            logger.info("Entity correctly inserted!");
        	return entidadContactoAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  entidadId  String
	 * @param  contactoId  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{entidadId}/{contactoId}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String entidadId,
				@PathVariable String contactoId,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            EntidadContacto entidadContacto = new EntidadContacto();
            entidadContacto.setEntidadId(entidadId);
            entidadContacto.setContactoId(contactoId);
            this.entidadContactoService.remove(entidadContacto);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  entidadId +  contactoId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  entidadContactoIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> entidadContactoIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<EntidadContacto> entidadContactoList = new ArrayList<EntidadContacto>();
        try{		    
            for (ArrayList<String> entidadContactoId:entidadContactoIds) {
			    Iterator<String> iterator = entidadContactoId.iterator();
				    EntidadContacto entidadContacto = new EntidadContacto();
			        entidadContacto.setEntidadId(ObjectConversionManager.convert(iterator.next(), String.class));
			        entidadContacto.setContactoId(ObjectConversionManager.convert(iterator.next(), String.class));
				    entidadContactoList.add(entidadContacto);
		    }
            this.entidadContactoService.removeMultiple(entidadContactoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEntidadContactoService'.
	 *
	 * @return EntidadContactoService
	 */
	protected EntidadContactoService getEntidadContactoService() {
		return this.entidadContactoService;
	}

	/**
	 * Method 'setEntidadContactoService'.
	 *
	 * @param entidadContactoService  EntidadContactoService
	 * @return
	 */
	public void setEntidadContactoService(EntidadContactoService entidadContactoService) {
		this.entidadContactoService = entidadContactoService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
