package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.ContactoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.Contacto;

/**
 *  * ContactoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/contacto")

public class ContactoController  {

	private static final Logger logger = LoggerFactory.getLogger(ContactoController.class);

	@Autowired
	private ContactoService contactoService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("contacto", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  contactoId String
	 * @return String
	 */
	@RequestMapping(value = "/{contactoId}", method = RequestMethod.GET)
	public @ResponseBody Contacto getById(@PathVariable String contactoId) {
		try{
            Contacto contacto = new Contacto();
			contacto.setContactoId(contactoId);
            contacto = this.contactoService.find(contacto);
            if (contacto == null) {
                throw new Exception(contactoId.toString());
            }
            return contacto;
		}catch (Exception e){
		    throw new ResourceNotFoundException(contactoId.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  contactoId String
	 *@param	  nombre String
	 *@param	  cargo String
	 *@param	  telefono String
	 *@param	  fax String
	 *@param	  email String
	 *@param	  url String
	 *@param	  isnacional String
	 *@param	  noraPaisId String
	 *@param	  nombrePais String
	 *@param	  noraProvinciaId String
	 *@param	  nombreProvincia String
	 *@param	  noraMunicipioId String
	 *@param	  nombreMunicipio String
	 *@param	  noraLocalidadId String
	 *@param	  nombreLocalidad String
	 *@param	  noraCalleId String
	 *@param	  nombreCalle String
	 *@param	  noraCpId String
	 *@param	  nombreCp String
	 *@param	  noraPortalId String
	 *@param	  nombrePortal String
	 *@param	  usuultmod String
	 *@param	  fecultmod Date
	 *@param	  compleDirec String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "contactoId", required = false) String contactoId,
	@RequestParam(value = "nombre", required = false) String nombre,
	@RequestParam(value = "cargo", required = false) String cargo,
	@RequestParam(value = "telefono", required = false) String telefono,
	@RequestParam(value = "fax", required = false) String fax,
	@RequestParam(value = "email", required = false) String email,
	@RequestParam(value = "url", required = false) String url,
	@RequestParam(value = "isnacional", required = false) String isnacional,
	@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
	@RequestParam(value = "nombrePais", required = false) String nombrePais,
	@RequestParam(value = "noraProvinciaId", required = false) String noraProvinciaId,
	@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
	@RequestParam(value = "noraMunicipioId", required = false) String noraMunicipioId,
	@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
	@RequestParam(value = "noraLocalidadId", required = false) String noraLocalidadId,
	@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
	@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
	@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
	@RequestParam(value = "noraCpId", required = false) String noraCpId,
	@RequestParam(value = "nombreCp", required = false) String nombreCp,
	@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
	@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
	@RequestParam(value = "usuultmod", required = false) String usuultmod,
	@RequestParam(value = "fecultmod", required = false) Date fecultmod,
	@RequestParam(value = "compleDirec", required = false) String compleDirec,
			HttpServletRequest request) {
			try{
				Contacto filterContacto = new Contacto(contactoId, nombre, cargo, telefono, fax, email, url, isnacional, noraPaisId, nombrePais, noraProvinciaId, nombreProvincia, noraMunicipioId, nombreMunicipio, noraLocalidadId, nombreLocalidad, noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, usuultmod, fecultmod, compleDirec);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Contacto> contactos =  this.contactoService.findAll(filterContacto, pagination);

     			    if (contactos == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterContacto, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(contactos);
				    return data;
				}else{
				    List<Contacto> contactos =  this.contactoService.findAll(filterContacto, pagination);
					if (contactos == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return contactos;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterContacto Contacto 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "contacto", required = false) Contacto  filterContacto, HttpServletRequest request) {
	    try {
			return contactoService
					.findAllCount(filterContacto != null ? filterContacto
							: new Contacto ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param contacto Contacto 
	 * @param response HttpServletResponse
	 * @return Contacto
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Contacto edit(@RequestBody Contacto contacto, HttpServletResponse response) {		
		try {
            Contacto contactoAux  = this.contactoService.update(contacto);
			logger.info("Entity correctly inserted!");
            return contactoAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param contacto Contacto 
	 * @return Contacto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Contacto add(@RequestBody Contacto contacto) {		
        try {
            Contacto contactoAux = this.contactoService.add(contacto);
            logger.info("Entity correctly inserted!");
        	return contactoAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  contactoId  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{contactoId}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String contactoId,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Contacto contacto = new Contacto();
            contacto.setContactoId(contactoId);
            this.contactoService.remove(contacto);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  contactoId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  contactoIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> contactoIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Contacto> contactoList = new ArrayList<Contacto>();
        try{		    
            for (ArrayList<String> contactoId:contactoIds) {
			    Iterator<String> iterator = contactoId.iterator();
				    Contacto contacto = new Contacto();
			        contacto.setContactoId(ObjectConversionManager.convert(iterator.next(), String.class));
				    contactoList.add(contacto);
		    }
            this.contactoService.removeMultiple(contactoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getContactoService'.
	 *
	 * @return ContactoService
	 */
	protected ContactoService getContactoService() {
		return this.contactoService;
	}

	/**
	 * Method 'setContactoService'.
	 *
	 * @param contactoService  ContactoService
	 * @return
	 */
	public void setContactoService(ContactoService contactoService) {
		this.contactoService = contactoService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
