package com.ejie.y40a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.ConsultaDinamicaBusqueda;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Y40aArbolFormaciones;
import com.ejie.y40a.model.Y40aArbolGrupos;
import com.ejie.y40a.service.ArbolFormacionesService;
import com.ejie.y40a.service.ArbolGruposService;
import com.ejie.y40a.service.CategoriaService;
import com.ejie.y40a.service.SolicitudService;
import com.ejie.y40a.service.Y40aExcelGeneratorService;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.exception.Y40aUDAErrorManager;
import com.ejie.y40a.utils.exception.Y40aUDAException;
import com.ejie.y40a.utils.tree.Y40aFormacionesTree;
import com.ejie.y40a.utils.tree.Y40aGruposTree;

/**
 * * ConsultaDinamicaController  
 * 
 *  
 */
@Controller
@RequestMapping(value = "/consultaDinamica")
public class ConsultaDinamicaController {

	public static final Logger logger = LoggerFactory
			.getLogger(ConsultaDinamicaController.class);

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y40aUDAErrorManager errorManager;

	@Autowired
	private ArbolFormacionesService arbolFormacionesService;
	@Autowired
	private ArbolGruposService arbolGruposService;
	@Autowired
	private Y40aExcelGeneratorService y40aExcelGeneratorService;
	@Autowired
	private SolicitudService solicitudService;
	@Autowired
	private CategoriaService categoriaService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y40aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y40aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("busquedaDinamica", "model", model);
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/consultaDinamica_tree", method = RequestMethod.GET)
	public void getConsultaDinamicaTree(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		String mostrarConsultaDinamica = "";
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String param = e.nextElement().toString();

			if (param.equals("mostrarConsultaDinamica")) {
				mostrarConsultaDinamica = request.getParameter(param);
			}
		}
		boolean blnmostrarConsultaDinamica;
		blnmostrarConsultaDinamica = false;

		if (mostrarConsultaDinamica.equals("true")) {
			blnmostrarConsultaDinamica = true;
		}

		Vector<String> perfiles = (Vector<String>) request.getSession()
				.getAttribute("UserProfiles");

		Y40aArbolFormaciones ArbolFormaciones = this.arbolFormacionesService
				.obtenerArbol(blnmostrarConsultaDinamica, perfiles, null);

		String json = Y40aFormacionesTree.obtieneJsonArbol(ArbolFormaciones);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */

	@RequestMapping(value = "/consultaDinamica_gruposTree", method = RequestMethod.GET)
	public void getConsultaDinamicaTreeGrupos(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		try {
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("text/html;charset=utf-8");
			Y40aArbolGrupos ArbolGrupos = this.arbolGruposService.obtenerArbol(
					false, null, null);

			String json = Y40aGruposTree.obtieneJsonArbol(ArbolGrupos);

			PrintWriter out = response.getWriter();
			out.println(json);
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param categoriasFormacionArr
	 *            String
	 * 
	 * @param gruposArr
	 *            String
	 * @param thSolicitanteImparticion
	 *            String
	 * @param thAraba
	 *            String
	 * @param thBizkaia
	 *            String
	 * @param thGipuzkoa
	 *            String
	 * @param etiquetasFormacionSeleccionadas
	 *            String
	 * @param etiquetasFormacionSeleccionadasRadio
	 *            String
	 * @param etiquetasSolicitudSeleccionadas
	 *            String
	 * @param etiquetasSolicitudSeleccionadasRadio
	 *            String
	 * @param fechaImparticionDesde
	 *            Date
	 * @param fechaImparticionHasta
	 *            Date
	 * @param fechaSolicitudDesde
	 *            Date
	 * @param fechaSolicitudHasta
	 *            Date
	 * @param agruparResultado
	 *            String
	 * @param centrosFormaciones
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getResultadoConsultaDinamicaBusqueda(
			@RequestParam(value = "categoriasFormacionArr", required = false) String categoriasFormacionArr,
			@RequestParam(value = "gruposArr", required = false) String gruposArr,
			@RequestParam(value = "thSolicitanteImparticion", required = false) String thSolicitanteImparticion,
			@RequestParam(value = "thAraba", required = false) String thAraba,
			@RequestParam(value = "thBizkaia", required = false) String thBizkaia,
			@RequestParam(value = "thGipuzkoa", required = false) String thGipuzkoa,
			@RequestParam(value = "etiquetasFormacionSeleccionadas", required = false) String etiquetasFormacionSeleccionadas,
			@RequestParam(value = "etiquetasFormacionSeleccionadasRadio", required = false) String etiquetasFormacionSeleccionadasRadio,
			@RequestParam(value = "etiquetasSolicitudSeleccionadas", required = false) String etiquetasSolicitudSeleccionadas,
			@RequestParam(value = "etiquetasSolicitudSeleccionadasRadio", required = false) String etiquetasSolicitudSeleccionadasRadio,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta,
			@RequestParam(value = "agruparResultado", required = false) String agruparResultado,
			@RequestParam(value = "centrosFormaciones", required = false) String centrosFormaciones,
			HttpServletRequest request, HttpServletResponse response) {

		try {
			// Preparación de parámetros de entrada

			List<Categoria> categoria = new ArrayList<Categoria>();
			List<Formacion> formacion = new ArrayList<Formacion>();
			List<Grupo> grupo = new ArrayList<Grupo>();
			List<Etiqueta> etiquetasFormacion = new ArrayList<Etiqueta>();
			List<Etiqueta> etiquetasSolicitud = new ArrayList<Etiqueta>();

			Locale locale = LocaleContextHolder.getLocale();

			// normalizacion de nombre y codigos de nora para BBDD
			String varCategoriasFormacionArr = (""
					.equals(categoriasFormacionArr)) ? null
					: categoriasFormacionArr;
			String varGruposArr = ("".equals(gruposArr)) ? null : gruposArr;
			String varThSolicitanteImparticion = (""
					.equals(thSolicitanteImparticion)) ? null
					: thSolicitanteImparticion;
			String varEtiquetasFormacionSeleccionadas = (""
					.equals(etiquetasFormacionSeleccionadas)) ? null
					: etiquetasFormacionSeleccionadas;
			String varEtiquetasSolicitudSeleccionadas = (""
					.equals(etiquetasSolicitudSeleccionadas)) ? null
					: etiquetasSolicitudSeleccionadas;
			//
			String varFechaImparticionDesde = ("".equals(fechaImparticionDesde)) ? null
					: fechaImparticionDesde;
			String varFechaImparticionHasta = ("".equals(fechaImparticionHasta)) ? null
					: fechaImparticionHasta;
			String varAgruparResultado = ("".equals(agruparResultado)) ? null
					: agruparResultado;
			String varCentrosFormaciones = ("".equals(centrosFormaciones)) ? null
					: centrosFormaciones;
			Date dtfechaDesde = Y40aUtils.parseDate(varFechaImparticionDesde,
					locale);
			Date dtfechaHasta = Y40aUtils.parseDate(varFechaImparticionHasta,
					locale);

			String varFechaSolicitudDesde = ("".equals(fechaSolicitudDesde)) ? null
					: fechaSolicitudDesde;
			String varFechaSolicitudHasta = ("".equals(fechaSolicitudHasta)) ? null
					: fechaSolicitudHasta;

			Date dtfechaSolDesde = Y40aUtils.parseDate(varFechaSolicitudDesde,
					locale);
			Date dtfechaSolHasta = Y40aUtils.parseDate(varFechaSolicitudHasta,
					locale);

			// control checks
			String varThAraba = ("on".equals(thAraba)) ? Y40aConstantes.TH_ARABA
					: null;
			String varThBizkaia = ("on".equals(thBizkaia)) ? Y40aConstantes.TH_BIZKAIA
					: null;
			String varThGipuzkoa = ("on".equals(thGipuzkoa)) ? Y40aConstantes.TH_GIPUZKOA
					: null;

			Categoria categoriaAux = null;
			Formacion formacionAux = null;

			if (null != varCategoriasFormacionArr
					&& !"".equals(varCategoriasFormacionArr)) {
				for (String id : varCategoriasFormacionArr.split(",")) {
					if (id.indexOf(Y40aConstantes.PREFIJO_CATEGORIA) >= 0) {
						categoriaAux = new Categoria();
						categoriaAux.setIdCat(id);
						categoria.add(categoriaAux);
					} else {
						formacionAux = new Formacion();
						formacionAux.setIdFor(id);
						formacion.add(formacionAux);
					}
				}
			}

			Grupo grupoAux = null;

			if (null != varGruposArr && !"".equals(varGruposArr)) {
				for (String id : varGruposArr.split(",")) {
					grupoAux = new Grupo();
					grupoAux.setGrupoId(id);
					grupo.add(grupoAux);
				}
			}

			etiquetasFormacion = this
					.generateArrayEtiquetas(varEtiquetasFormacionSeleccionadas);

			etiquetasSolicitud = this
					.generateArrayEtiquetas(varEtiquetasSolicitudSeleccionadas);

			if (categoria.size() == 0 && formacion.size() == 0) {
				categoriaAux = new Categoria();
				Categoria categoriaPadre = new Categoria();
				categoriaAux.setCategoria(categoriaPadre);

				Vector<String> perfiles = (Vector<String>) request.getSession()
						.getAttribute("UserProfiles");

				if (!perfiles.contains(Y40aConstantes.PERFIL_ADMINISTRADOR)) {
					categoria = this.categoriaService
							.findAllCategoriaSeguridad(categoriaAux, perfiles,
									null);
				}
			}

			ConsultaDinamicaBusqueda consultadinamicabusqueda = new ConsultaDinamicaBusqueda(
					categoria, formacion, grupo, varThSolicitanteImparticion,
					varThAraba, varThBizkaia, varThGipuzkoa,
					etiquetasFormacion, etiquetasFormacionSeleccionadasRadio,
					etiquetasSolicitud, etiquetasSolicitudSeleccionadasRadio,
					dtfechaDesde, dtfechaHasta, varAgruparResultado,
					varCentrosFormaciones);

			consultadinamicabusqueda.setFechaSolicitudDesde(dtfechaSolDesde);
			consultadinamicabusqueda.setFechaSolicitudHasta(dtfechaSolHasta);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = "consultadinamica" + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombre + "\"");

			String xslString = this.y40aExcelGeneratorService
					.getConsultaDinamicaExcel(consultadinamicabusqueda);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Metodo para generar un archivo xml con los filtrados correspondientes
	 * 
	 * @param categoriasFormacionArr
	 *            String
	 * 
	 * @param gruposArr
	 *            String
	 * @param thSolicitanteImparticion
	 *            String
	 * @param thAraba
	 *            String
	 * @param thBizkaia
	 *            String
	 * @param thGipuzkoa
	 *            String
	 * @param etiquetasFormacionSeleccionadas
	 *            String
	 * @param etiquetasFormacionSeleccionadasRadio
	 *            String
	 * @param etiquetasSolicitudSeleccionadas
	 *            String
	 * @param etiquetasSolicitudSeleccionadasRadio
	 *            String
	 * @param fechaImparticionDesde
	 *            Date
	 * @param fechaImparticionHasta
	 *            Date
	 * @param fechaSolicitudDesde
	 *            Date
	 * @param fechaSolicitudHasta
	 *            Date
	 * @param agruparResultado
	 *            String
	 * @param centrosFormaciones
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/xml", method = RequestMethod.GET)
	public void getResultadoConsultaDinamicaBusquedaXls(
			@RequestParam(value = "categoriasFormacionArr", required = false) String categoriasFormacionArr,
			@RequestParam(value = "gruposArr", required = false) String gruposArr,
			@RequestParam(value = "thSolicitanteImparticion", required = false) String thSolicitanteImparticion,
			@RequestParam(value = "thAraba", required = false) String thAraba,
			@RequestParam(value = "thBizkaia", required = false) String thBizkaia,
			@RequestParam(value = "thGipuzkoa", required = false) String thGipuzkoa,
			@RequestParam(value = "etiquetasFormacionSeleccionadas", required = false) String etiquetasFormacionSeleccionadas,
			@RequestParam(value = "etiquetasFormacionSeleccionadasRadio", required = false) String etiquetasFormacionSeleccionadasRadio,
			@RequestParam(value = "etiquetasSolicitudSeleccionadas", required = false) String etiquetasSolicitudSeleccionadas,
			@RequestParam(value = "etiquetasSolicitudSeleccionadasRadio", required = false) String etiquetasSolicitudSeleccionadasRadio,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta,
			@RequestParam(value = "agruparResultado", required = false) String agruparResultado,
			@RequestParam(value = "centrosFormaciones", required = false) String centrosFormaciones,
			HttpServletRequest request, HttpServletResponse response) {

		try {
			// Preparación de parámetros de entrada

			List<Categoria> categoria = new ArrayList<Categoria>();
			List<Formacion> formacion = new ArrayList<Formacion>();
			List<Grupo> grupo = new ArrayList<Grupo>();
			List<Etiqueta> etiquetasFormacion = new ArrayList<Etiqueta>();
			List<Etiqueta> etiquetasSolicitud = new ArrayList<Etiqueta>();

			Locale locale = LocaleContextHolder.getLocale();

			// normalizacion de nombre y codigos de nora para BBDD
			String varCategoriasFormacionArr = (""
					.equals(categoriasFormacionArr)) ? null
					: categoriasFormacionArr;
			String varGruposArr = ("".equals(gruposArr)) ? null : gruposArr;
			String varThSolicitanteImparticion = (""
					.equals(thSolicitanteImparticion)) ? null
					: thSolicitanteImparticion;
			String varEtiquetasFormacionSeleccionadas = (""
					.equals(etiquetasFormacionSeleccionadas)) ? null
					: etiquetasFormacionSeleccionadas;
			String varEtiquetasSolicitudSeleccionadas = (""
					.equals(etiquetasSolicitudSeleccionadas)) ? null
					: etiquetasSolicitudSeleccionadas;
			//
			String varFechaImparticionDesde = ("".equals(fechaImparticionDesde)) ? null
					: fechaImparticionDesde;
			String varFechaImparticionHasta = ("".equals(fechaImparticionHasta)) ? null
					: fechaImparticionHasta;
			String varAgruparResultado = ("".equals(agruparResultado)) ? null
					: agruparResultado;
			String varCentrosFormaciones = ("".equals(centrosFormaciones)) ? null
					: centrosFormaciones;

			String varFechaSolicitudDesde = ("".equals(fechaSolicitudDesde)) ? null
					: fechaSolicitudDesde;
			String varFechaSolicitudHasta = ("".equals(fechaSolicitudHasta)) ? null
					: fechaSolicitudHasta;

			Date dtfechaDesde = Y40aUtils.parseDate(varFechaImparticionDesde,
					locale);
			Date dtfechaHasta = Y40aUtils.parseDate(varFechaImparticionHasta,
					locale);
			Date dtfechaSolDesde = Y40aUtils.parseDate(varFechaSolicitudDesde,
					locale);
			Date dtfechaSolHasta = Y40aUtils.parseDate(varFechaSolicitudHasta,
					locale);

			// control checks
			String varThAraba = ("on".equals(thAraba)) ? Y40aConstantes.TH_ARABA
					: null;
			String varThBizkaia = ("on".equals(thBizkaia)) ? Y40aConstantes.TH_BIZKAIA
					: null;
			String varThGipuzkoa = ("on".equals(thGipuzkoa)) ? Y40aConstantes.TH_GIPUZKOA
					: null;

			Categoria categoriaAux = null;
			Formacion formacionAux = null;

			if (null != varCategoriasFormacionArr
					&& !"".equals(varCategoriasFormacionArr)) {
				for (String id : varCategoriasFormacionArr.split(",")) {
					if (id.indexOf(Y40aConstantes.PREFIJO_CATEGORIA) >= 0) {
						categoriaAux = new Categoria();
						categoriaAux.setIdCat(id);
						categoria.add(categoriaAux);
					} else {
						formacionAux = new Formacion();
						formacionAux.setIdFor(id);
						formacion.add(formacionAux);
					}
				}
			}

			Grupo grupoAux = null;

			if (null != varGruposArr && !"".equals(varGruposArr)) {
				for (String id : varGruposArr.split(",")) {
					grupoAux = new Grupo();
					grupoAux.setGrupoId(id);
					grupo.add(grupoAux);
				}
			}

			etiquetasFormacion = this
					.generateArrayEtiquetas(varEtiquetasFormacionSeleccionadas);

			etiquetasSolicitud = this
					.generateArrayEtiquetas(varEtiquetasSolicitudSeleccionadas);

			if (categoria.size() == 0 && formacion.size() == 0) {
				categoriaAux = new Categoria();
				Categoria categoriaPadre = new Categoria();
				categoriaAux.setCategoria(categoriaPadre);

				Vector<String> perfiles = (Vector<String>) request.getSession()
						.getAttribute("UserProfiles");

				if (!perfiles.contains(Y40aConstantes.PERFIL_ADMINISTRADOR)) {
					categoria = this.categoriaService
							.findAllCategoriaSeguridad(categoriaAux, perfiles,
									null);
				}
			}

			ConsultaDinamicaBusqueda consultadinamicabusqueda = new ConsultaDinamicaBusqueda(
					categoria, formacion, grupo, varThSolicitanteImparticion,
					varThAraba, varThBizkaia, varThGipuzkoa,
					etiquetasFormacion, etiquetasFormacionSeleccionadasRadio,
					etiquetasSolicitud, etiquetasSolicitudSeleccionadasRadio,
					dtfechaDesde, dtfechaHasta, varAgruparResultado,
					varCentrosFormaciones);

			consultadinamicabusqueda.setFechaSolicitudDesde(dtfechaSolDesde);
			consultadinamicabusqueda.setFechaSolicitudHasta(dtfechaSolHasta);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-xml");
			String nombre = "consultadinamica" + fechaActual + ".xml";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombre + "\"");

			String xslString = this.solicitudService
					.findAllConsultaDinamicaXML(consultadinamicabusqueda);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * 
	 * @param varEtiquetasSeleccionadas
	 *            String
	 * @return List
	 */
	private List<Etiqueta> generateArrayEtiquetas(
			String varEtiquetasSeleccionadas) {
		List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
		Etiqueta etiquetaAux = null;

		if (null != varEtiquetasSeleccionadas
				&& !"".equals(varEtiquetasSeleccionadas)) {
			for (String id : varEtiquetasSeleccionadas.split(",")) {
				etiquetaAux = new Etiqueta();
				etiquetaAux.setIdEtiqueta(id);
				etiquetas.add(etiquetaAux);
			}
		}

		return etiquetas;
	}

}
