package com.ejie.y40a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.CategoriaDetalle;
import com.ejie.y40a.model.CategoriaPerfil;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Perfil;
import com.ejie.y40a.model.Y40aArbolCategorias;
import com.ejie.y40a.model.Y40aArbolGrupos;
import com.ejie.y40a.service.ArbolCategoriasService;
import com.ejie.y40a.service.ArbolGruposService;
import com.ejie.y40a.service.CategoriaService;
import com.ejie.y40a.service.GrupoService;
import com.ejie.y40a.utils.exception.Y40aUDAErrorManager;
import com.ejie.y40a.utils.exception.Y40aUDAException;
import com.ejie.y40a.utils.tree.Y40aCategoriasTree;
import com.ejie.y40a.utils.tree.Y40aGruposTree;

/**
 * * CategoriaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/categoria")
public class CategoriaController {

	private static final Logger logger = LoggerFactory
			.getLogger(CategoriaController.class);

	@Autowired
	private CategoriaService categoriaService;

	@Autowired
	private GrupoService grupoService;

	@Autowired
	private ArbolCategoriasService arbolCategoriasService;

	@Autowired
	private ArbolGruposService arbolGruposService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------------------------------------------------------------
	 * ---INICIO------------ Tratamiento de errores comun para los proyectos
	 * UDA. --------------------------------------------------------------------
	 */
	@Autowired
	private Y40aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y40aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y40aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------------------------------------------------------------
	 * ---FIN------------ Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("categoria", "model", model);
	}

	/**
	 * Method 'getCreateFormBusquedaCategorias'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "busquedaCategorias", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaCategorias(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("busquedaCategorias", "model", model);
	}

	/**
	 * Method 'getCreateFormMantenimientoCategorias'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "mantenimientoCategorias", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimientoCategorias(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("mantenimientoCategorias", "model", model);
	}

	/**
	 * Method 'getCreateFormMantenimientoCategorias'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "mantenimientoCategoriasAlta", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimientoCategoriasAlta(
			@RequestParam(value = "catAltaC", required = false) String catAltaC,
			@RequestParam(value = "catAltaE", required = false) String catAltaE,
			Model model) {

		model.addAttribute("feddcatAltaC", catAltaC);
		model.addAttribute("feddcatAltaE", catAltaE);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("mantenimientoCategorias", "model", model);
	}

	/**
	 * Method 'getCreateFormMantenimientoCategorias'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "modificacionCategorias", method = RequestMethod.GET)
	public ModelAndView getCreateFormModificacionCategorias(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("modificacionCategorias", "model", model);
	}

	/**
	 * Method 'getCreateFormAccesoSolicitud'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "accesoSolicitudTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormAccesoSolicitud(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("accesoSolicitudTab", "model", model);
	}

	/**
	 * Method 'getCreateFormPerfilAcceso'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "perfilAccesoTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormPerfilAcceso(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("perfilAccesoTab", "model", model);
	}

	/**
	 * Method 'getCreateFormBusquedaCategoriasPadre'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "busquedaCategoriasPadre", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaCategoriasPadre(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("busquedaCategoriasPadre", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idCat
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idCat}", method = RequestMethod.GET)
	public @ResponseBody
	Categoria getById(@PathVariable String idCat) {
		try {
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			categoria = this.categoriaService.find(categoria);
			if (categoria == null) {
				throw new Exception(idCat.toString());
			}
			return categoria;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idCat.toString());
		}
	}

	/**
	 * Method 'getFindCategoriaPadre'.
	 * 
	 * @param idCat
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/findCategoriaPadre/{idCat}", method = RequestMethod.GET)
	public @ResponseBody
	Categoria getFindCategoriaPadre(@PathVariable String idCat) {
		try {
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			categoria = this.categoriaService.findCategoriaPadre(categoria);
			if (categoria == null) {
				throw new Exception(idCat.toString());
			}
			return categoria;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idCat.toString());
		}
	}

	/**
	 * Method 'getFindCategoria'.
	 * 
	 * @param idCat
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/findCategoria/{idCat}", method = RequestMethod.GET)
	public @ResponseBody
	CategoriaDetalle getFindCategoria(@PathVariable String idCat) {
		try {
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			categoria = this.categoriaService.findCategoria(categoria);
			if (categoria == null) {
				throw new Exception(idCat.toString());
			}

			CategoriaDetalle categoriaDetalle = new CategoriaDetalle();

			categoriaDetalle.setIdCat(categoria.getIdCat());
			categoriaDetalle.setJerarquiaCategoria(categoria.getCategoria()
					.getJerarquiaCategoria());
			categoriaDetalle.setNombreEs(categoria.getNombreEs());
			categoriaDetalle.setNombreEu(categoria.getNombreEu());
			categoriaDetalle.setFechaIniSol(categoria.getFechaIniSol());
			categoriaDetalle.setFechaFinSol(categoria.getFechaFinSol());
			categoriaDetalle.setNumAsistentes(categoria.getNumAsistentes());
			categoriaDetalle.setNumFormaciones(categoria.getNumFormaciones());
			categoriaDetalle.setVisibleWeb(categoria.getVisibleWeb());
			categoriaDetalle.setIdCatPadre(categoria.getCategoria().getIdCat());
			categoriaDetalle.setObservacionesEs(categoria.getObservacionesEs());
			categoriaDetalle.setObservacionesEu(categoria.getObservacionesEu());
			categoriaDetalle.setVisiblecontacto(categoria.getVisiblecontacto());

			return categoriaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idCat.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idCat
	 *            String
	 * @param categoriaID_CAT_PADRE
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param fechaIniSol
	 *            Date
	 * @param fechaFinSol
	 *            Date
	 * @param numAsistentes
	 *            Long
	 * @param numFormaciones
	 *            Long
	 * @param visibleWeb
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idCat", required = false) String idCat,
			@RequestParam(value = "categoriaID_CAT_PADRE", required = false) String categoriaID_CAT_PADRE,
			@RequestParam(value = "nombreEs", required = false) String nombreEs,
			@RequestParam(value = "nombreEu", required = false) String nombreEu,
			@RequestParam(value = "fechaIniSol", required = false) Date fechaIniSol,
			@RequestParam(value = "fechaFinSol", required = false) Date fechaFinSol,
			@RequestParam(value = "numAsistentes", required = false) Long numAsistentes,
			@RequestParam(value = "numFormaciones", required = false) Long numFormaciones,
			@RequestParam(value = "visibleWeb", required = false) String visibleWeb,
			HttpServletRequest request) {
		try {
			Categoria filterCategoria = new Categoria(idCat, nombreEs,
					nombreEu, fechaIniSol, fechaFinSol, numAsistentes,
					numFormaciones, visibleWeb, new Categoria(
							categoriaID_CAT_PADRE, null, null, null, null,
							null, null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Categoria> categorias = this.categoriaService.findAll(
						filterCategoria, pagination);

				if (categorias == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterCategoria, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(categorias);
				return data;
			} else {
				List<Categoria> categorias = this.categoriaService.findAll(
						filterCategoria, pagination);
				if (categorias == null) {
					throw new Exception("No data Found.");
				}
				return categorias;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterCategoria
	 *            Categoria
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "categoria", required = false) Categoria filterCategoria,
			HttpServletRequest request) {
		try {
			return categoriaService
					.findAllCount(filterCategoria != null ? filterCategoria
							: new Categoria());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getFindAllCount'.
	 * 
	 * @param idCat
	 *            String
	 * @return Long
	 */
	@RequestMapping(value = "/findAllCountCategoriasHijas/{idCat}", method = RequestMethod.GET)
	public @ResponseBody
	Long getFindAllCount(@PathVariable String idCat) {
		try {
			Categoria filterCategoriaPadre = new Categoria();
			filterCategoriaPadre.setIdCat(idCat);

			Categoria filterCategoria = new Categoria();
			filterCategoria.setCategoria(filterCategoriaPadre);
			return categoriaService
					.findAllCount(filterCategoria != null ? filterCategoria
							: new Categoria());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param response
	 *            HttpServletResponse
	 * @return Categoria
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Categoria edit(@RequestBody Categoria categoria,
			HttpServletResponse response) {
		try {
			Categoria categoriaAux = this.categoriaService.update(categoria);
			logger.info("Entity correctly inserted!");
			return categoriaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editCategoria'.
	 * 
	 * @param categoriaDetalle
	 *            CategoriaDetalle
	 * @param request
	 *            HttpServletResponse
	 * @return Categoria
	 */
	@RequestMapping(value = "/modificarCategoria", method = RequestMethod.PUT)
	public @ResponseBody
	Categoria editCategoria(@RequestBody CategoriaDetalle categoriaDetalle,
			HttpServletRequest request) {
		try {
			Categoria categoria = new Categoria();

			Categoria categoriaPadre = new Categoria();
			categoriaPadre.setIdCat(categoriaDetalle.getIdCatPadre());

			categoria.setIdCat(categoriaDetalle.getIdCat());
			categoria.setJerarquiaCategoria(categoriaDetalle
					.getJerarquiaCategoria());
			categoria.setCategoria(categoriaPadre);
			categoria.setNombreEs(categoriaDetalle.getNombreEs());
			categoria.setNombreEu(categoriaDetalle.getNombreEu());
			categoria.setFechaIniSol(categoriaDetalle.getFechaIniSol());
			categoria.setFechaFinSol(categoriaDetalle.getFechaFinSol());
			categoria.setObservacionesEs(categoriaDetalle.getObservacionesEs());
			categoria.setObservacionesEu(categoriaDetalle.getObservacionesEu());

			if (categoriaDetalle.getVisiblecontacto() != null) {
				String sContacto = categoriaDetalle.getVisiblecontacto();

				if (sContacto.equals(Y40aConstantes.SI)) {
					categoria.setVisiblecontacto(Y40aConstantes.SI);
				}
			} else {
				categoria.setVisiblecontacto(Y40aConstantes.NO);
			}

			// String entidadId = ("".equals(entidadId_)) ? null : entidadId_;

			Long numAsistentes = categoriaDetalle.getNumAsistentes();
			Long lCero = new Long("0");
			if (numAsistentes == null) {
				numAsistentes = lCero;
			}
			categoria.setNumAsistentes(numAsistentes);

			Long numFormaciones = categoriaDetalle.getNumFormaciones();
			if (numFormaciones == null) {
				numFormaciones = lCero;
			}
			categoria.setNumFormaciones(numFormaciones);

			categoria.setVisibleWeb(Y40aConstantes.NO);

			// perfiles
			if (categoriaDetalle.getPerfilesarr() != null) {
				ArrayList<Perfil> perfilesList = new ArrayList<Perfil>();

				String[] perfiles = categoriaDetalle.getPerfilesarr()
						.split(",");
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i] != null && !(perfiles[i].equals(""))) {
						Perfil perfil = new Perfil();
						perfil.setIdPerfil(perfiles[i]);
						perfilesList.add(perfil);
					}
				}
				categoria.setPerfils(perfilesList);
			}

			// grupod
			if (categoriaDetalle.getGruposarr() != null) {
				ArrayList<Grupo> grupoList = new ArrayList<Grupo>();

				String[] grupos = categoriaDetalle.getGruposarr().split(",");
				for (int i = 0; i < grupos.length; i++) {
					if (grupos[i] != null && !(grupos[i].equals(""))) {
						Grupo grupo = new Grupo();
						grupo.setGrupoId(grupos[i]);
						grupoList.add(grupo);
					}
				}
				categoria.setGrupos(grupoList);
			}

			Categoria categoriaAux = this.categoriaService
					.updateCategoria(categoria);
			logger.info("Entity correctly inserted!");
			return categoriaAux;
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Categoria add(@RequestBody Categoria categoria) {
		try {
			Categoria categoriaAux = this.categoriaService.add(categoria);
			logger.info("Entity correctly inserted!");
			return categoriaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addCategoria'.
	 * 
	 * @param categoriaDetalle
	 *            CategoriaDetalle
	 * @param response
	 *            HttpServletResponse
	 * @return Categoria
	 */
	@RequestMapping(value = "/addCategoria", method = RequestMethod.POST)
	public @ResponseBody
	Categoria addCategoria(@RequestBody CategoriaDetalle categoriaDetalle,
			HttpServletResponse response) {
		try {

			Categoria categoria = new Categoria();

			Categoria categoriaPadre = new Categoria();
			categoriaPadre.setIdCat(categoriaDetalle.getIdCatPadre());

			categoria.setJerarquiaCategoria(categoriaDetalle
					.getJerarquiaCategoria());
			categoria.setCategoria(categoriaPadre);
			categoria.setNombreEs(categoriaDetalle.getNombreEs());
			categoria.setNombreEu(categoriaDetalle.getNombreEu());
			categoria.setFechaIniSol(categoriaDetalle.getFechaIniSol());
			categoria.setFechaFinSol(categoriaDetalle.getFechaFinSol());
			categoria.setObservacionesEs(categoriaDetalle.getObservacionesEs());
			categoria.setObservacionesEu(categoriaDetalle.getObservacionesEu());
			if (categoriaDetalle.getVisiblecontacto() != null) {
				String sContacto = categoriaDetalle.getVisiblecontacto();

				if (sContacto.equals(Y40aConstantes.SI)) {
					categoria.setVisiblecontacto(Y40aConstantes.SI);
				}
			} else {
				categoria.setVisiblecontacto(Y40aConstantes.NO);
			}

			Long lCero = new Long("0");

			Long numAsistentes = categoriaDetalle.getNumAsistentes();
			if (numAsistentes == null) {
				numAsistentes = lCero;
			}
			categoria.setNumAsistentes(numAsistentes);

			Long numFormaciones = categoriaDetalle.getNumFormaciones();
			if (numFormaciones == null) {
				numFormaciones = lCero;
			}
			categoria.setNumFormaciones(numFormaciones);

			categoria.setVisibleWeb(Y40aConstantes.NO);

			// perfiles
			if (categoriaDetalle.getPerfilesarr() != null) {
				ArrayList<Perfil> perfilesList = new ArrayList<Perfil>();

				String[] perfiles = categoriaDetalle.getPerfilesarr()
						.split(",");
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i] != null && !(perfiles[i].equals(""))) {
						Perfil perfil = new Perfil();
						perfil.setIdPerfil(perfiles[i]);
						perfilesList.add(perfil);
					}
				}
				categoria.setPerfils(perfilesList);
			}

			// grupod
			if (categoriaDetalle.getGruposarr() != null) {
				ArrayList<Grupo> grupoList = new ArrayList<Grupo>();

				String[] grupos = categoriaDetalle.getGruposarr().split(",");
				for (int i = 0; i < grupos.length; i++) {
					if (grupos[i] != null && !(grupos[i].equals(""))) {
						Grupo grupo = new Grupo();
						grupo.setGrupoId(grupos[i]);
						grupoList.add(grupo);
					}
				}
				categoria.setGrupos(grupoList);
			}

			Categoria categoriaAux = this.categoriaService
					.addCategoria(categoria);
			logger.info("Entity correctly inserted!");
			return categoriaAux;
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idCat
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idCat}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idCat, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			this.categoriaService.remove(categoria);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Unable to delete " + idCat);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeCategoria'.
	 * 
	 * @param idCat
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeCategoria/{idCat}", method = RequestMethod.DELETE)
	public void removeCategoria(@PathVariable String idCat,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			this.categoriaService.removeCategoria(categoria);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Unable to delete " + idCat);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param categoriaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> categoriaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Categoria> categoriaList = new ArrayList<Categoria>();
		try {
			for (ArrayList<String> categoriaId : categoriaIds) {
				Iterator<String> iterator = categoriaId.iterator();
				Categoria categoria = new Categoria();
				categoria.setIdCat(ObjectConversionManager.convert(
						iterator.next(), String.class));
				categoriaList.add(categoria);
			}
			this.categoriaService.removeMultiple(categoriaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCategoriaService'.
	 * 
	 * @return CategoriaService
	 */
	protected CategoriaService getCategoriaService() {
		return this.categoriaService;
	}

	/**
	 * Method 'setCategoriaService'.
	 * 
	 * @param categoriaService
	 *            CategoriaService
	 * @return
	 */
	public void setCategoriaService(CategoriaService categoriaService) {
		this.categoriaService = categoriaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' CategoriaPerfil
	 * 
	 * @param idCat
	 *            String
	 * @param perfilIdPerfil
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindCategoriaPerfil", method = RequestMethod.POST)
	public void unBindCategoriaPerfil(
			@RequestParam(value = "idCat", required = false) String idCat,
			@RequestParam(value = "perfilIdPerfil", required = false) String perfilIdPerfil) {
		Categoria categoria = new Categoria();
		Perfil perfil = new Perfil();
		if (idCat != null) {
			categoria.setIdCat(idCat);
		}
		if (perfilIdPerfil != null) {
			perfil.setIdPerfil(perfilIdPerfil);
		}
		categoria.getPerfils().add(perfil);
		this.categoriaService.removeCategoriaPerfil(categoria);
	}

	/**
	 * Method 'bind' CategoriaPerfil
	 * 
	 * @param idCat
	 *            String
	 * @param perfilIdPerfil
	 *            String
	 */
	@RequestMapping(value = "/bindCategoriaPerfil", method = RequestMethod.POST)
	public void bindCategoriaPerfil(
			@RequestParam(value = "idCat", required = false) String idCat,
			@RequestParam(value = "perfilIdPerfil", required = false) String perfilIdPerfil) {
		Categoria categoria = new Categoria();
		Perfil perfil = new Perfil();
		if (idCat != null) {
			categoria.setIdCat(idCat);
		}
		if (perfilIdPerfil != null) {
			perfil.setIdPerfil(perfilIdPerfil);
		}
		categoria.getPerfils().add(perfil);
		this.categoriaService.addCategoriaPerfil(categoria);
	}

	/**
	 * Method 'unBind' CategoriaGrupos
	 * 
	 * @param idCat
	 *            String
	 * @param grupoGrupoId
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindCategoriaGrupos", method = RequestMethod.POST)
	public void unBindCategoriaGrupos(
			@RequestParam(value = "idCat", required = false) String idCat,
			@RequestParam(value = "grupoGrupoId", required = false) String grupoGrupoId) {
		Categoria categoria = new Categoria();
		Grupo grupo = new Grupo();
		if (idCat != null) {
			categoria.setIdCat(idCat);
		}
		if (grupoGrupoId != null) {
			grupo.setGrupoId(grupoGrupoId);
		}
		categoria.getGrupos().add(grupo);
		this.categoriaService.removeCategoriaGrupos(categoria);
	}

	/**
	 * Method 'bind' CategoriaGrupos
	 * 
	 * @param idCat
	 *            String
	 * @param grupoGrupoId
	 *            String
	 */
	@RequestMapping(value = "/bindCategoriaGrupos", method = RequestMethod.POST)
	public void bindCategoriaGrupos(
			@RequestParam(value = "idCat", required = false) String idCat,
			@RequestParam(value = "grupoGrupoId", required = false) String grupoGrupoId) {
		Categoria categoria = new Categoria();
		Grupo grupo = new Grupo();
		if (idCat != null) {
			categoria.setIdCat(idCat);
		}
		if (grupoGrupoId != null) {
			grupo.setGrupoId(grupoGrupoId);
		}
		categoria.getGrupos().add(grupo);
		this.categoriaService.addCategoriaGrupos(categoria);
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/categoriastree", method = RequestMethod.GET)
	public void getCategoriasTree(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		String mostrarCategoria = "";
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String param = e.nextElement().toString();

			if (param.equals("mostrarCategoria")) {
				mostrarCategoria = request.getParameter(param);
			}
		}
		boolean blnmostrarCategoria;
		blnmostrarCategoria = false;

		if (mostrarCategoria.equals("true")) {
			blnmostrarCategoria = true;
		}

		Vector<String> perfiles = (Vector<String>) request.getSession()
				.getAttribute("UserProfiles");

		Y40aArbolCategorias ArbolCategorias = this.arbolCategoriasService
				.obtenerArbol(blnmostrarCategoria, perfiles, null);

		String json = Y40aCategoriasTree.obtieneJsonArbol(ArbolCategorias);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'ocultarCategoria'.
	 * 
	 * @param idCategoria
	 *            String
	 * @param visibleWeb
	 *            String
	 * @return Categoria
	 */
	@RequestMapping(value = "/ocultarCategorias", method = RequestMethod.PUT)
	public @ResponseBody
	Categoria ocultarCategoria(
			@RequestParam(value = "idCategoria", required = false) String idCategoria,
			@RequestParam(value = "visibleWeb", required = false) String visibleWeb) {
		try {

			Categoria categoria = new Categoria();
			categoria.setIdCat(idCategoria);
			categoria.setVisibleWeb(visibleWeb);

			Categoria categoriaAux = this.categoriaService
					.updateVisibleWeb(categoria);
			logger.info("Entity correctly inserted!");
			return categoriaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'accesoSolicitudesCategoria'.
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/accesoSolicitudes", method = RequestMethod.GET)
	public void accesoSolicitudesCategoria(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		try {
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("text/html;charset=utf-8");

			String idCategoriaPadre = "";
			Enumeration e = request.getParameterNames();
			while (e.hasMoreElements()) {
				String param = e.nextElement().toString();

				if (param.equals("idCategoriaPadre")) {
					idCategoriaPadre = request.getParameter(param);
				}
			}
			Y40aArbolGrupos y40aArbolGruposAux = new Y40aArbolGrupos();
			if (idCategoriaPadre.equals("null")) {
				y40aArbolGruposAux = this.arbolGruposService.obtenerArbol(
						false, null, null);
			} else {
				y40aArbolGruposAux = this.arbolGruposService.obtenerArbol(
						false, idCategoriaPadre, null);
			}

			String json = Y40aGruposTree.obtieneJsonArbol(y40aArbolGruposAux);

			PrintWriter out = response.getWriter();
			out.println(json);
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Method 'accesoSolicitudesCategoriaSeleccionada'.
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/accesoSolicitudesSeleccionadas", method = RequestMethod.GET)
	public void accesoSolicitudesCategoriaSeleccionada(
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		String idCategoria = "";
		String idCategoriaPadre = "";
		List<String> grupoList = new ArrayList<String>();

		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String param = e.nextElement().toString();
			if (param.equals("idCategoria")) {
				idCategoria = request.getParameter(param);
			}
			if (param.equals("idCategoriaPadre")) {
				idCategoriaPadre = request.getParameter(param);
			}
		}
		List<Grupo> lstGrupo = this.grupoService.findAllGruposCategoria(null,
				idCategoria, null);

		if (lstGrupo != null) {
			for (Grupo idGrupo : lstGrupo) {
				grupoList.add(idGrupo.getGrupoId());
			}
		}

		Y40aArbolGrupos y40aArbolGruposAux = new Y40aArbolGrupos();
		if (idCategoriaPadre.equals("null")) {
			y40aArbolGruposAux = this.arbolGruposService.obtenerArbol(false,
					null, null);
		} else {
			y40aArbolGruposAux = this.arbolGruposService.obtenerArbol(false,
					idCategoriaPadre, null);
		}

		String json = Y40aGruposTree.obtieneJsonArbolSeleccionado(
				y40aArbolGruposAux, grupoList);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'getAllCategoriaPerfil'.
	 * 
	 * @param categoriaId
	 *            String
	 * @param categoriaIdPadre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/allCategoriaPerfil", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllCategoriaPerfil(
			@RequestParam(value = "categoriaId", required = false) String categoriaId,
			@RequestParam(value = "categoriaIdPadre", required = false) String categoriaIdPadre,
			HttpServletRequest request) {
		try {

			Categoria filterCategoria = new Categoria();

			if (categoriaId.equals("null") && categoriaIdPadre.equals("null")) {
				filterCategoria = new Categoria(null, null, null, null, null,
						null, null, null, new Categoria(null, null, null, null,
								null, null, null, null, null, null, null, null,
								null));
			} else if (categoriaIdPadre.equals("null")) {
				filterCategoria = new Categoria(categoriaId, null, null, null,
						null, null, null, null, new Categoria(null, null, null,
								null, null, null, null, null, null, null, null,
								null, null));
			} else if (categoriaId.equals("null")) {
				filterCategoria = new Categoria(null, null, null, null, null,
						null, null, null, new Categoria(categoriaIdPadre, null,
								null, null, null, null, null, null, null, null,
								null, null, null));
			} else {
				filterCategoria = new Categoria(categoriaId, null, null, null,
						null, null, null, null, new Categoria(categoriaIdPadre,
								null, null, null, null, null, null, null, null,
								null, null, null, null));
			}

			Pagination pagination = null;

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<CategoriaPerfil> categoriaPerfil = this.categoriaService
						.findAllCategoriaPerfil(filterCategoria, pagination);

				if (categoriaPerfil == null) {
					throw new Exception("No data Found.");
				}
				Perfil perfil = new Perfil();
				Long total = this.categoriaService.findCategoriaPerfilCount(
						filterCategoria, perfil);

				// Long total = getAllCount(filterCategoria, request);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(categoriaPerfil);

				return data;
			} else {
				List<CategoriaPerfil> categoriaPerfil = this.categoriaService
						.findAllCategoriaPerfil(filterCategoria, pagination);
				if (categoriaPerfil == null) {
					throw new Exception("No data Found.");
				}
				return categoriaPerfil;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'contarCategoriaFormaciones'.
	 * 
	 * @param idCat
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "contarCategoriaFormaciones/{idCat}", method = RequestMethod.GET)
	@ResponseBody
	public Model contarCategoriaFormaciones(@PathVariable String idCat,
			HttpServletResponse response, Model model) {
		try {
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);

			HashMap<String, Object> resultado = this.categoriaService
					.contarCategoriaFormaciones(categoria);

			model.addAttribute("numCategorias", resultado.get("numCategorias"));
			model.addAttribute("numFormaciones",
					resultado.get("numFormaciones"));

			return model;

		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Unable to delete " + idCat);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}
}
