package com.ejie.y40a.control;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y40a.model.CampainaDetalle;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.service.CampaniaService;
import com.ejie.y40a.service.CategoriaService;
import com.ejie.y40a.utils.exception.Y40aUDAErrorManager;
import com.ejie.y40a.utils.exception.Y40aUDAException;

/**
 * * CategoriaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/campania")
public class CampaniaController {

	private static final Logger logger = LoggerFactory
			.getLogger(CampaniaController.class);

	@Autowired
	private CampaniaService campaniaService;

	@Autowired
	private CategoriaService categoriaService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------------------------------------------------------------
	 * ---INICIO------------ Tratamiento de errores comun para los proyectos
	 * UDA. --------------------------------------------------------------------
	 */
	@Autowired
	private Y40aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y40aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y40aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------------------------------------------------------------
	 * ---FIN------------ Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormBusquedaCategorias'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "copiaCampanias", method = RequestMethod.GET)
	public ModelAndView getCopiaCategorias(Model model) {
		logger.debug("Dentro de Copia Campanias - INICIO");
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		// Categoria categoriaCampania = new Categoria();
		// categoriaService.findAll(categoriaCampania, null);

		return new ModelAndView("copiaCampanias", "model", model);
	}

	/********************************************************************************
	 * Campanias
	 *******************************************************************************/
	/**
	 * Method 'getCampanias'.
	 * 
	 * @return 'lista de Categorias' para el COMBO
	 */
	@RequestMapping(value = "/obtenerCampanias", method = RequestMethod.GET)
	public @ResponseBody()
	List<Categoria> getCampanias() {
		logger.debug("getCampanias - INICIO");
		Categoria categoriaCampania = new Categoria();
		return categoriaService.findAll(categoriaCampania, null);
	}

	/**
	 * Method 'copiaCampaina'.
	 * 
	 * @param campainaDetalle
	 *            CampainaDetalle
	 * @param response
	 *            HttpServletResponse
	 * @return Categoria
	 */
	@RequestMapping(value = "/copiaCampania", method = RequestMethod.POST)
	public void copiaCampaina(@RequestBody CampainaDetalle campainaDetalle,
			HttpServletResponse response) {
		// de la campania recogida de la pantalla formo un objeto Categoria para
		// buscar todas sus hijas
		Categoria catCopiar = new Categoria();
		catCopiar.setIdCat(campainaDetalle.getIdCat());
		catCopiar.setNombreEs(campainaDetalle.getNombreEs());
		catCopiar.setNombreEu(campainaDetalle.getNombreEu());
		catCopiar.setFechaIniSol(campainaDetalle.getFechaIniSol());
		catCopiar.setFechaFinSol(campainaDetalle.getFechaFinSol());

		try {
			this.campaniaService.copiaCampaina(catCopiar);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Unable to copiar " + campainaDetalle.getIdCat());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}
}
