package com.ejie.y40a.utils.tree;

import java.util.Iterator;
import java.util.List;

import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Y40aArbolGrupos;
import com.ejie.y40a.model.Y40aGrupoTree;
import com.ejie.y40a.utils.Y40aUtils;

/**
 * 
 *  
 * 
 */
public class Y40aGruposTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y40aArbolGrupos
	 * @return String
	 */
	public static String obtieneJsonArbol(Y40aArbolGrupos _tree) {
		Y40aGruposTree t = new Y40aGruposTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y40aArbolGrupos
	 * @return json tree
	 */
	private String getTreeStructureStr(Y40aArbolGrupos tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y40aGrupoTree> itGr = tree.getLstGrupos().iterator();
			Y40aGrupoTree grupo = null;
			while (itGr.hasNext()) {
				grupo = itGr.next();
				aux.append(this.bloqueGrupos(grupo));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * BloqueGrupos
	 * 
	 * @param grupo
	 *            Y40aGrupoTree
	 * @return String
	 */
	private String bloqueGrupos(Y40aGrupoTree grupo) {
		StringBuffer aux = new StringBuffer(Y40aConstantes.BUFFER_300);

		String key = grupo.getGrupoId();
		// aux.append("{\"title\": \""
		// + Y41aUtils.printTreeLabel(grupo.getNombreEs(),
		// grupo.getNombreEu()) + "\", ");

		aux.append("{\"title\": \""
		// + "<span class='arbol_grupo'>"
				+ Y40aUtils.printTreeLabel(grupo.getNombreEs(),
						grupo.getNombreEu())
				// + "</span>"
				+ "\", ");

		aux.append("\"isFolder\": false, ");
		aux.append("\"addClass\": \"arbol_grupo\", ");

		aux.append(this.printNodeKey(key));

		if (grupo.getLstChildren().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = grupo.getLstChildren().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();

				aux.append(this.bloqueGrupos((Y40aGrupoTree) child));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @param selectedIdList
	 *            List<String> selectedIdList
	 * @return ""
	 */
	private String printNodeKey(String key, List<String> selectedIdList) {

		if (selectedIdList.contains(key)) {
			return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": true, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

		}

	}

	/**
	 * Obtiene Json
	 * 
	 * @param _tree
	 *            Y40aArbolGrupos
	 * @param selectedList
	 *            List<String>
	 * @return String
	 */
	public static String obtieneJsonArbolSeleccionado(Y40aArbolGrupos _tree,
			List<String> selectedList) {
		Y40aGruposTree t = new Y40aGruposTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree, selectedList);
	}

	/**
	 * 
	 * @param tree
	 *            Y40aArbolGrupos
	 * @param selectedList
	 *            List<String>
	 * @return json
	 */
	private String getTreeStructureStr(Y40aArbolGrupos tree,
			List<String> selectedList) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y40aGrupoTree> itGr = tree.getLstGrupos().iterator();
			Y40aGrupoTree grupo = null;
			while (itGr.hasNext()) {
				grupo = itGr.next();
				aux.append(this.bloqueGrupos(grupo, selectedList));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		// System.out.println("Arbol: " + aux.toString());

		return aux.toString();
	}

	/**
	 * 
	 * @param grupo
	 *            Y40aGrupoTree
	 * @param selectedList
	 *            List<String>
	 * @return String
	 */
	private String bloqueGrupos(Y40aGrupoTree grupo, List<String> selectedList) {

		StringBuffer aux = new StringBuffer(Y40aConstantes.BUFFER_300);

		String key = grupo.getGrupoId();
		aux.append("{\"title\": \""
				+ Y40aUtils.printTreeLabel(grupo.getNombreEs(),
						grupo.getNombreEu()) + "\", ");
		aux.append("\"isFolder\": false, ");

		aux.append("\"addClass\": \"arbol_grupo\", ");
		aux.append(this.printNodeKey(key, selectedList));

		if (grupo.getLstChildren().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = grupo.getLstChildren().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();

				aux.append(this.bloqueGrupos((Y40aGrupoTree) child,
						selectedList));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}
}
