package com.ejie.y40a.utils.tree;

import java.util.List;

import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Etiqueta;

/**
 * 
 *  
 * 
 */
public class Y40aEtiquetasTree {

	/**
         * 
         */
	private Y40aEtiquetasTree() {

	}

	/**
	 * Obtiene estructura Json para el arbol
	 * 
	 * @param lstEtiquetas
	 *            List<Etiqueta>
	 * @param selectedIdList
	 *            List<String>
	 * @return sb
	 */
	public static String obtieneJsonArbol(List<Etiqueta> lstEtiquetas,
			List<String> selectedIdList) {
		StringBuffer sb = new StringBuffer(Y40aConstantes.BUFFER_300);

		String key = "";

		sb.append("[");

		for (Etiqueta etiqueta : lstEtiquetas) {
			key = etiqueta.getIdEtiqueta();

			sb.append("{\"title\": \"" + etiqueta.getNombre() + "\",");
			if (selectedIdList != null && selectedIdList.contains(key)) {
				sb.append("\"select\": true, ");
			}
			sb.append("\"key\": \"" + key + "\"");
			sb.append("}");

			if (!etiqueta.equals(lstEtiquetas.get(lstEtiquetas.size() - 1))) {
				sb.append(",");
			}
		}
		sb.append("]");

		return sb.toString();
	}

}
