package com.ejie.y40a.utils.tree;

import java.util.Iterator;

import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Y40aArbolCategorias;
import com.ejie.y40a.model.Y40aCategoriaTree;
import com.ejie.y40a.utils.Y40aUtils;

/**
 * 
 *  
 * 
 */
public class Y40aCategoriasTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y40aArbolCategorias
	 * @return String
	 */
	public static String obtieneJsonArbol(Y40aArbolCategorias _tree) {
		Y40aCategoriasTree t = new Y40aCategoriasTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y40aArbolCategorias
	 * @return json tree
	 */
	private String getTreeStructureStr(Y40aArbolCategorias tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y40aCategoriaTree> itGr = tree.getLstCategorias()
					.iterator();
			Y40aCategoriaTree categoria = null;
			while (itGr.hasNext()) {
				categoria = itGr.next();
				aux.append(this.bloqueCategorias(categoria));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * bloqueCategorias
	 * 
	 * @param categoria
	 *            Y40aCategoriaTree
	 * @return String
	 */
	private String bloqueCategorias(Y40aCategoriaTree categoria) {
		StringBuffer aux = new StringBuffer(Y40aConstantes.BUFFER_300);

		String key = categoria.getIdCat();

		aux.append("{\"title\": \""
				+ Y40aUtils.printTreeLabel(categoria.getNombreEs(),
						categoria.getNombreEu()) + "\", ");

		aux.append("\"isFolder\": false, ");
		if (categoria.getVisibleWeb() != null
				&& categoria.getVisibleWeb().equals(Y40aConstantes.NO)) {
			if ((Y40aConstantes.CATEGORIA_RAIZ_ID.equals(key))) {
				aux.append("\"addClass\": \"arbol_categoria_novisible_root\", ");
			} else {
				aux.append("\"addClass\": \"arbol_categoria_novisible\", ");
			}
		} else {
			aux.append("\"addClass\": \"arbol_categoria_visible\", ");
		}

		aux.append(this.printNodeKey(key));

		if (categoria.getLstChildren().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = categoria.getLstChildren().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();
				aux.append(this.bloqueCategorias((Y40aCategoriaTree) child));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}

}
