package com.ejie.y40a.utils.jdbc;

import java.sql.Blob;
import java.sql.SQLException;

public class Y40aJdbcUtils {
	private static Y40aJdbcUtils INSTANCE = null;

	// Private constructor suppresses
	private Y40aJdbcUtils() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y40aJdbcUtils();
		}
	}

	public static Y40aJdbcUtils getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Convierto un Blob a un byte[]
	 * 
	 * @param blob
	 * @return byte[]
	 */
	public static byte[] ConvertBlobToByte(Blob blob) {
		byte[] raw = null;

		try {

			raw = blob.getBytes(1, (int) blob.length());

		} catch (SQLException e) {
			return null;
		}

		return raw;
	}
}
