/**
 * 
 */
package com.ejie.y40a.utils.exception;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 
 * Excepcion generica para los proyectos UDA.
 * 
 * Permite vincular una Excepción con un mensaje que puede ser un mensaje como
 * tal, o bien la key de un mensaje internacionalizado almacenado en un fichero
 * de recursos.
 * 
 * Estas excepciones, se procesan a posteriori en los controller, mediante una
 * utilidad comun que proporciona una excepción de presentación en formato JSON
 * para poder procesarse y visualizarse en los clientes.
 * 
 *  
 * 
 */
public class Y40aUDAException extends RuntimeException implements Serializable {

	private static final long serialVersionUID = 1L;
	private Map<String, Boolean> messages = null;
	private Throwable exception;
	private String infoException;

	public Y40aUDAException() {

		if (null == this.messages) {

			this.messages = new LinkedHashMap<String, Boolean>();
		}

	}

	public Y40aUDAException(String message, Boolean isUserMessage,
			Throwable exception) {

		if (null == this.messages) {

			this.messages = new LinkedHashMap<String, Boolean>();
		}

		this.messages.put(message, isUserMessage);
		this.exception = exception;

	}

	public Y40aUDAException(String message, Boolean isUserMessage,
			String infoException, Throwable exception) {

		if (null == this.messages) {

			this.messages = new LinkedHashMap<String, Boolean>();
		}

		this.messages.put(message, isUserMessage);
		this.infoException = infoException;
		this.exception = exception;

	}

	public void addException(String message, Boolean isUserMessage,
			Throwable exception) {

		this.messages.put(message, isUserMessage);
		this.exception = exception;

	}

	/**
	 * @return the messages
	 */
	public Map<String, Boolean> getMessages() {
		return messages;
	}

	/**
	 * @param messages
	 *            the messages to set
	 */
	public void setMessages(Map<String, Boolean> messages) {
		this.messages = messages;
	}

	/**
	 * @return the exception
	 */
	public Throwable getException() {
		return exception;
	}

	/**
	 * @param exception
	 *            the exception to set
	 */
	public void setException(Throwable exception) {
		this.exception = exception;
	}

	/**
	 * @return the infoException
	 */
	public String getInfoException() {
		return infoException;
	}

	/**
	 * @param infoException
	 *            the infoException to set
	 */
	public void setInfoException(String infoException) {
		this.infoException = infoException;
	}

	public static void main(String[] args) {

		try {

			Y40aUDAException e = new Y40aUDAException();
			e.addException("msg1", true, null);
			e.addException("msg2", true, null);
			e.addException("msg3", true, null);
			e.addException("msg4", true, new NullPointerException());
			throw e;

		} catch (Y40aUDAException e) {

			e.printStackTrace();
		}
	}

}
