package com.ejie.y40a.utils.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.ejie.y40a.constantes.Y40aConstantes;

public class Y40aConfig {

	private Y40aConfig() {
	}

	/**
	 * Static method to obtain properties
	 * 
	 * @param nombreFichero
	 * @return properties
	 */
	public static Properties loadProperties(String nombreFichero) {
		return getProperties(nombreFichero);

	}

	/**
	 * Método que carga el fichero de propiedades
	 * 
	 * @param nombreFichero
	 *            String
	 * @return Properties
	 */
	public static Properties getProperties(String nombreFichero) {

		String propertiesLog = nombreFichero;
		InputStream configLog = Y40aConfig.class
				.getResourceAsStream(propertiesLog);
		Properties pLog = new Properties();

		try {
			pLog.load(configLog);
		} catch (IOException e) {
			e.printStackTrace();
		}

		return pLog;
	}

	/**
	 * Devuelve el properties pasado por parametro del fichero de configuracion
	 * de la aplicacion (Y41bConstantes.CONFIG_PATH)
	 * 
	 * @param strPfClave
	 *            the strPfClave
	 * @return configAplication
	 */
	public static String getConfigAplicacion(final String strPfClave) {
		String resultado = null;
		if (strPfClave != null) {
			final Properties dokusiProp = loadProperties(Y40aConstantes.CONFIG_PATH);
			if (dokusiProp.containsKey(strPfClave)) {
				resultado = dokusiProp.getProperty(strPfClave);
			}
		}
		return resultado;
	}
}
