package com.ejie.y40a.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.StaticsContainer;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.EntidadDao;
import com.ejie.y40a.model.ConsultaDinamicaBusqueda;
import com.ejie.y40a.model.ConsultaDinamicaResultado;
import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.model.FormacionBusqueda;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusquedaCartas;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.config.Y40aConfig;

/**
 *  
 */
@Service(value = "excelGeneratorService")
public class Y40aExcelGeneratorServiceImpl implements Y40aExcelGeneratorService {

	@Autowired
	private SolicitudService solicitudService;

	@Autowired
	private EntidadDao entidadDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return String
	 */
	public String getConsultaDinamicaExcel(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this
				.getConsultaDinamicaListTable(consultaDinamicaBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/* PlanificacionSolicitanteDetalle__________________________________________________________________________________ */
	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla de planificacionSolicitante
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	public String getPlanificacionSolicitanteDetalleListaExcelCab(
			List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table>");
		if (planificacionFormacionBusqueda.size() > 0) {
			xslString
					.append(getPlanificacionSolicitanteDetalleCabRow(planificacionFormacionBusqueda
							.get(0)));
		}
		xslString.append("</table>");
		xslString
				.append(this
						.getPlanificacionSolicitanteDetalleListaExcel(planificacionFormacionBusqueda));

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla de planificacionSolicitante
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	public String getPlanificacionSolicitanteDetalleListaExcel(
			List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString
				.append(this
						.getPlanificacionSolicitanteDetalleLista(planificacionFormacionBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param listPlanificacionSolicitanteBusqueda
	 *            List<PlanificacionSolicitanteBusqueda>
	 * @return String
	 */
	private String getPlanificacionSolicitanteDetalleLista(
			List<PlanificacionFormacionBusqueda> listPlanificacionFormacionBusqueda) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getPlanificacionSolicitanteDetalleHeaderRow());
		for (PlanificacionFormacionBusqueda planificacionFormacionBusquedaAux : listPlanificacionFormacionBusqueda) {
			xslString
					.append(getPlanificacionSolicitanteDetalleRow(planificacionFormacionBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPlanificacionSolicitanteDetalleHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getPlanificacionSolicitanteDetalleHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para PlanificacionSolicitanteDetalle
	 * 
	 * @return fields
	 */
	private String getPlanificacionSolicitanteDetalleHeaderRowFields() {
		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.formacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage("excel.grupo",
				null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.idioma", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numparticipantes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.diaimparticion", null, locale)));
		// FIXME fields.append(getHeaderField(appMessageSource.getMessage(
		// "excel.horarioimparticion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaInicio", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaFin", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numasistentes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cancelacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.contacto", null, locale)));

		return fields.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	private String getPlanificacionSolicitanteDetalleRow(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// Formacion
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombreFormacionEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombreFormacionEu())));
		}

		// Grupo
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionFormacionBusqueda.getGrupo())));

		// Idioma

		if (null != planificacionFormacionBusqueda.getIdioma()) {
			if (planificacionFormacionBusqueda.getIdioma().equalsIgnoreCase(
					Y40aConstantes.CASTELLANO)) {

				row.append(getField(appMessageSource.getMessage(
						"idioma.castellano", null, locale)));

			} else {

				row.append(getField(appMessageSource.getMessage(
						"idioma.euskera", null, locale)));
			}

		} else {
			row.append(getField(""));

		}

		/*
		 * if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
		 * row.append(getField(appMessageSource.getMessage( "idioma.castellano",
		 * null, locale)));
		 * 
		 * } else {
		 * row.append(getField(appMessageSource.getMessage("idioma.euskera",
		 * null, locale))); }
		 */

		// Nº participantes
		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(planificacionFormacionBusqueda
						.getParticipantes()))));

		// Día imparticion
		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(
						planificacionFormacionBusqueda.getDiaImparticion(),
						locale.getLanguage()))));

		// FIXME // Horario imparticion
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionFormacionBusqueda
		// .getHorarioImparticion())));
		// Hora inicio
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionFormacionBusqueda.getHoraInicio())));
		// Hora fin
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionFormacionBusqueda.getHoraFin())));

		// Nº asistentes
		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(planificacionFormacionBusqueda
						.getAsistentes()))));

		// Cancelado
		if (null != planificacionFormacionBusqueda.getCancelado()) {
			if (planificacionFormacionBusqueda.getCancelado().equalsIgnoreCase(
					Y40aConstantes.SI)) {
				row.append(getField(appMessageSource.getMessage("comun.si",
						null, locale)));
			} else {
				row.append(getField(appMessageSource.getMessage("comun.no",
						null, locale)));
			}
		} else {
			row.append(getField(""));
		}

		if (planificacionFormacionBusqueda.getNombapecontacto() != null
				&& !planificacionFormacionBusqueda.getNombapecontacto().equals(
						"")) {
			row.append(getField(appMessageSource.getMessage("comun.si", null,
					locale)));
		} else {
			row.append(getField(appMessageSource.getMessage("comun.no", null,
					locale)));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	private String getPlanificacionSolicitanteDetalleCabRow(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();
		// String urlLogo = StaticsContainer.staticsUrl
		// + "/y40a/images/y40a-logo-kontsumo2.png";

		Properties prop = Y40aConfig.loadProperties(Y40aConstantes.CONFIG_PATH);
		String urlImagenExcel = (String) prop.getProperty("URL_EXCEL_IMG");
		String urlLogo = "";

		String urlEstaticos = StaticsContainer.staticsUrl;
		if (urlEstaticos.substring(0, 1).equals("/")) { // des and above
			urlLogo = urlImagenExcel + urlEstaticos
					+ "/y40a/images/y40a-logo-kontsumo2.png";
		} else { // local
			urlLogo = urlEstaticos + "/y40a/images/y40a-logo-kontsumo2.png";
		}

		StringBuffer row = new StringBuffer();

		Entidad entidad = new Entidad();
		entidad.setEntidadId(planificacionFormacionBusqueda.getEntidadId());
		entidad = this.entidadDao.find(entidad);
		StringBuffer direccion = new StringBuffer();
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			if (entidad.getNombreCalle() != null)
				direccion.append(entidad.getNombreCalle()).append(" ");
			if (entidad.getNombrePortal() != null)
				direccion.append(entidad.getNombrePortal());
			direccion.append("<br />");
			if (entidad.getNombreCp() != null)
				direccion
						.append(appMessageSource.getMessage("excel.cp", null,
								locale)).append(" ")
						.append(entidad.getNombreCp()).append(" - ");
			direccion.append(entidad.getNombreLocalidad());
		} else {
			// No están los datos de NORA mostramos el coplmento dirección
			direccion.append(entidad.getCompleDirec());
		}

		direccion.append("<br />");
		if (entidad.getNombreMunicipio() != null)
			direccion.append(entidad.getNombreMunicipio());
		if (entidad.getNombreProvincia() != null)
			direccion.append(" (").append(entidad.getNombreProvincia())
					.append(")");

		row.append("<tr>");
		row.append("<td style=\"height:76px\"><img src=\"" + urlLogo
				+ "\" height=\"76px\" width=\"256px\"></td>");
		row.append("<td colspan=\"8\" align=\"right\">");
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append("<span style='FONT-WEIGHT: bold;'>")
					.append(Y40aUtils
							.normalizarVacio(planificacionFormacionBusqueda
									.getNombreEntidadEs())).append("</span>");
		} else {
			row.append("<span style='FONT-WEIGHT: bold;'>")
					.append(Y40aUtils
							.normalizarVacio(planificacionFormacionBusqueda
									.getNombreEntidadEu())).append("</span>");
		}
		row.append("<br />").append(direccion.toString());
		row.append("<br />").append(
				Y40aUtils.normalizarVacio(planificacionFormacionBusqueda
						.getTelEntidad()));
		row.append("<br />").append(
				Y40aUtils.normalizarVacio(planificacionFormacionBusqueda
						.getEmailEntidad()));
		row.append("</td>");
		row.append("</tr>");
		row.append("<tr><td colspan=\"9\">&nbsp;</td></tr>");

		return row.toString();
	}

	/*
	 * PlanificacionSolicitanteBusqueda
	 * __________________________________________________________________________________
	 */

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla de planificacionSolicitante
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	public String getPlanificacionSolicitanteBusquedaListaExcel(
			List<PlanificacionSolicitanteBusqueda> planificacionSolicitanteBusqueda) {
		StringBuffer xslString = new StringBuffer();
		xslString.append(this.getCabeceraLogo("5"));
		xslString.append("<table border='1'>");

		xslString
				.append(this
						.getPlanificacionSolicitanteBusquedaLista(planificacionSolicitanteBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param listPlanificacionSolicitanteBusqueda
	 *            List<PlanificacionSolicitanteBusqueda>
	 * @return String
	 */
	private String getPlanificacionSolicitanteBusquedaLista(
			List<PlanificacionSolicitanteBusqueda> listPlanificacionSolicitanteBusqueda) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getPlanificacionSolicitanteBusquedaHeaderRow());

		for (PlanificacionSolicitanteBusqueda planificacionSolicitanteBusquedaAux : listPlanificacionSolicitanteBusqueda) {
			xslString
					.append(getPlanificacionSolicitanteBusquedaRow(planificacionSolicitanteBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPlanificacionSolicitanteBusquedaHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getPlanificacionSolicitanteBusquedaHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para PlanificacionSolicitanteBusqueda
	 * 
	 * @return fields
	 */
	private String getPlanificacionSolicitanteBusquedaHeaderRowFields() {
		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.solicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitudes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.aceptadas", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechasolicitud", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.intervaloimparticion", null, locale)));
		// fields.append(getHeaderField(appMessageSource.getMessage(
		// "excel.contacto", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage("excel.email",
				null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono", null, locale)));
		return fields.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	private static String getPlanificacionSolicitanteBusquedaRow(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// Nombre Solicitante idiomatico
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusqueda
							.getNombreEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusqueda
							.getNombreEu())));
		}

		// Municipio
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getNombreMunicipio())));

		// Nº formaciones
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getNumFormaciones())));

		// Nº aceptadas
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getAceptadas())));

		// fecha solicitud
		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(
						planificacionSolicitanteBusqueda.getFechaSolicitud(),
						locale.getLanguage()))));
		// intervalo
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getIntervaloImparticion())));

		// nb contacto - el del contacto si hay si no solicitante // SOLO
		// SOLICITANTE
		// if (planificacionSolicitanteBusqueda.getNombapecontacto() != null
		// && !planificacionSolicitanteBusqueda.getNombapecontacto()
		// .equals("")) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getNombapecontacto())));
		//
		// } else {

		// if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getNombreEs())));
		// } else {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getNombreEu())));
		// }

		// }
		// email
		// if (planificacionSolicitanteBusqueda.getEmailcontacto() != null
		// && !planificacionSolicitanteBusqueda.getEmailcontacto().equals(
		// "")) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getEmailcontacto())));
		//
		// } else {
		if (planificacionSolicitanteBusqueda.getEmailEntidad() != null
				&& !planificacionSolicitanteBusqueda.getEmailEntidad().equals(
						"")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusqueda
							.getEmailEntidad())));
		} else {
			row.append(getField(""));
		}

		// }

		// telefono
		// if (planificacionSolicitanteBusqueda.getTelcontacto() != null
		// && !planificacionSolicitanteBusqueda.getTelcontacto()
		// .equals("")) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getTelcontacto())));
		//
		// } else {
		if (planificacionSolicitanteBusqueda.getTelEntidad() != null
				&& !planificacionSolicitanteBusqueda.getTelEntidad().equals("")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusqueda
							.getTelEntidad())));
		} else {
			row.append(getField(""));
		}
		// }

		row.append("</tr>");
		return row.toString();
	}

	/*
	 * Formacion busqueda
	 * __________________________________________________________________________________
	 */

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla de formaciones
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @return String
	 */
	public String getFormacionBusquedaListaExcel(
			List<FormacionBusqueda> formacionBusqueda) {
		StringBuffer xslString = new StringBuffer();
		xslString.append(this.getCabeceraLogo("3"));
		xslString.append("<table border='1'>");
		xslString.append(this.getFormacionBusquedaLista(formacionBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param listFormacionBusqueda
	 *            List<FormacionBusqueda>
	 * @return String
	 */
	private String getFormacionBusquedaLista(
			List<FormacionBusqueda> listFormacionBusqueda) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getFormacionBusquedaHeaderRow());

		for (FormacionBusqueda formacionBusquedaAux : listFormacionBusqueda) {
			xslString.append(getFormacionBusquedaRow(formacionBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getFormacionBusquedaHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getFormacionBusquedaHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para Formacion busqueda
	 * 
	 * @return fields
	 */
	private String getFormacionBusquedaHeaderRowFields() {
		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombreformacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombrecortoformacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.categoria", null, locale)));

		return fields.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @return String
	 */
	private static String getFormacionBusquedaRow(
			FormacionBusqueda formacionBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		if (formacionBusqueda.getVisibleWeb().equals(Y40aConstantes.NO)) {
			row.append("<tr style='COLOR: #E01B1B;'>");
		} else {
			row.append("<tr>");
		}

		// Nombre Formacion idiomatico
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils.normalizarVacio(formacionBusqueda
					.getNombreEs())));
		} else {
			row.append(getField(Y40aUtils.normalizarVacio(formacionBusqueda
					.getNombreEu())));
		}

		// Nombre corto
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils.normalizarVacio(formacionBusqueda
					.getNombreCortoEs())));
		} else {
			row.append(getField(Y40aUtils.normalizarVacio(formacionBusqueda
					.getNombreCortoEu())));
		}

		// Categoria

		row.append(getField(Y40aUtils.normalizarVacio(formacionBusqueda
				.getJerarquiaCategoria())));

		row.append("</tr>");
		return row.toString();
	}

	/* __________________________________________________________________________________ */

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla planificacion formacion
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return String
	 */
	public String getPlanificacionFormacionExcel(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles, Pagination pagination) {
		StringBuffer xslString = new StringBuffer();
		xslString.append(this.getCabeceraLogo("10"));
		xslString.append("<table border='1'>");

		xslString.append(this.getPlanificacionFormacionListTable(
				planificacionFormacionBusqueda, perfiles, pagination));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla planificacion formacion
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @return String
	 */
	public String getPlanificacionFormacionListaExcel(
			List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda) {
		StringBuffer xslString = new StringBuffer();
		xslString.append(this.getCabeceraLogo("12"));
		xslString.append("<table border='1'>");

		xslString
				.append(this
						.getPlanificacionFormacionLista(planificacionFormacionBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return String
	 */
	private String getPlanificacionFormacionListTable(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles, Pagination pagination) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getPlanificacionFormacionHeaderRow());

		List<PlanificacionFormacionBusqueda> listPlanificacionFormacionBusqueda = this.solicitudService
				.findAllPlanificacionFormacion(planificacionFormacionBusqueda,
						perfiles, pagination);

		for (PlanificacionFormacionBusqueda planificacionFormacionBusquedaAux : listPlanificacionFormacionBusqueda) {
			xslString
					.append(getPlanificacionFormacionRow(planificacionFormacionBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param listPlanificacionFormacionBusqueda
	 *            List<PlanificacionFormacionBusqueda>
	 * @return String
	 */
	private String getPlanificacionFormacionLista(
			List<PlanificacionFormacionBusqueda> listPlanificacionFormacionBusqueda) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getPlanificacionFormacionHeaderRow());

		for (PlanificacionFormacionBusqueda planificacionFormacionBusquedaAux : listPlanificacionFormacionBusqueda) {
			xslString
					.append(getPlanificacionFormacionRow(planificacionFormacionBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPlanificacionFormacionHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getPlanificacionFormacionHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para Planficacion formacion
	 * 
	 * @return fields
	 */
	private String getPlanificacionFormacionHeaderRowFields() {
		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.formacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.solicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage("excel.grupo",
				null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.idioma", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numparticipantes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechasolicitud", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.diaimparticion", null, locale)));
		// fields.append(getHeaderField(appMessageSource.getMessage(
		// "excel.horarioimparticion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaInicio", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaFin", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numasistentes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cancelacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.contacto", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage("excel.email",
				null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono", null, locale)));
		// descomentar si se decide mostrar la columna en el excel
		// fields.append(getHeaderField(appMessageSource.getMessage(
		// "excel.bloqueada", null, locale)));

		return fields.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @return String
	 */
	private String getPlanificacionFormacionRow(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// Formacion
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombreFormacionEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombreFormacionEu())));
		}

		// Solicitante
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombreEntidadEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombreEntidadEu())));
		}

		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionFormacionBusqueda.getGrupo())));

		// Modifico para poner el literal del idioma
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {

			if (planificacionFormacionBusqueda.getIdioma().toLowerCase()
					.equals(Y40aConstantes.CASTELLANO)) {
				row.append(getField(Y40aUtils
						.normalizarVacio(Y40aConstantes.LITERAL_CASTELLANO_ES)));
			} else {
				row.append(getField(Y40aUtils
						.normalizarVacio(Y40aConstantes.LITERAL_EUSKERA_ES)));
			}
		} else {
			if (planificacionFormacionBusqueda.getIdioma().toLowerCase()
					.equals(Y40aConstantes.CASTELLANO)) {
				row.append(getField(Y40aUtils
						.normalizarVacio(Y40aConstantes.LITERAL_CASTELLANO_EU)));
			} else {
				row.append(getField(Y40aUtils
						.normalizarVacio(Y40aConstantes.LITERAL_EUSKERA_EU)));
			}
		}

		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(planificacionFormacionBusqueda
						.getParticipantes()))));
		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(
						planificacionFormacionBusqueda.getFechaSol(),
						locale.getLanguage()))));
		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(
						planificacionFormacionBusqueda.getDiaImparticion(),
						locale.getLanguage()))));
		// FIXME row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionFormacionBusqueda
		// .getHorarioImparticion())));
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionFormacionBusqueda.getHoraInicio())));
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionFormacionBusqueda.getHoraFin())));
		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(planificacionFormacionBusqueda
						.getAsistentes()))));

		// Cancelado
		if (planificacionFormacionBusqueda.getCancelado().equalsIgnoreCase(
				Y40aConstantes.SI)) {
			row.append(getField(appMessageSource.getMessage("comun.si", null,
					locale)));
		} else {
			row.append(getField(appMessageSource.getMessage("comun.no", null,
					locale)));
		}
		// Contacto
		// if (planificacionFormacionBusqueda.getNombapecontacto() != null
		// && !planificacionFormacionBusqueda.getNombapecontacto().equals(
		// "")) {
		// row.append(getField(appMessageSource.getMessage("comun.si", null,
		// locale)));
		// } else {
		// row.append(getField(appMessageSource.getMessage("comun.no", null,
		// locale)));
		// }

		// nb contacto - el del contacto si hay si no vacio
		if (planificacionFormacionBusqueda.getNombapecontacto() != null
				&& !planificacionFormacionBusqueda.getNombapecontacto().equals(
						"")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getNombapecontacto())));

		} else {
			row.append(getField(""));
			// if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			// row.append(getField(Y40aUtils
			// .normalizarVacio(planificacionFormacionBusqueda
			// .getNombreEntidadEs())));
			// } else {
			// row.append(getField(Y40aUtils
			// .normalizarVacio(planificacionFormacionBusqueda
			// .getNombreEntidadEu())));
			// }

		}
		// email
		if (planificacionFormacionBusqueda.getEmailcontacto() != null
				&& !planificacionFormacionBusqueda.getEmailcontacto()
						.equals("")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getEmailcontacto())));

		} else {
			if (planificacionFormacionBusqueda.getEmailEntidad() != null
					&& !planificacionFormacionBusqueda.getEmailEntidad()
							.equals("")) {
				row.append(getField(Y40aUtils
						.normalizarVacio(planificacionFormacionBusqueda
								.getEmailEntidad())));
			} else {
				row.append(getField(""));
			}
		}

		// telefono
		if (planificacionFormacionBusqueda.getTelcontacto() != null
				&& !planificacionFormacionBusqueda.getTelcontacto().equals("")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionFormacionBusqueda
							.getTelcontacto())));

		} else {
			if (planificacionFormacionBusqueda.getTelEntidad() != null
					&& !planificacionFormacionBusqueda.getTelEntidad().equals(
							"")) {
				row.append(getField(Y40aUtils
						.normalizarVacio(planificacionFormacionBusqueda
								.getTelEntidad())));
			} else {
				row.append(getField(""));
			}
		}

		// // bloqueada - descomentar si se decide a futuro mostrar la columna
		// en el excel
		//
		// if (planificacionFormacionBusqueda.getBloqueada() != null
		// && !planificacionFormacionBusqueda.getBloqueada().equals("")) {
		//
		// if (planificacionFormacionBusqueda.getBloqueada().equals(
		// Y40aConstantes.SI)) {
		// row.append(getField(Y40aConstantes.SI_letra));
		// } else {
		// row.append(getField(Y40aConstantes.NO_letra));
		// }
		//
		// }

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla planificacion formacion
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	public String getPlanificacionSolicitanteExcel(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda) {
		StringBuffer xslString = new StringBuffer();
		xslString.append(this.getCabeceraLogo("5"));
		xslString.append("<table border='1'>");

		xslString
				.append(this
						.getPlanificacionSolicitanteListTable(planificacionSolicitanteBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	private String getPlanificacionSolicitanteListTable(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getPlanificacionSolicitanteHeaderRow());

		List<PlanificacionSolicitanteBusqueda> listPlanificacionSolicitanteBusqueda = this.solicitudService
				.findAllPlanificacionSolicitante(
						planificacionSolicitanteBusqueda, null, null);

		for (PlanificacionSolicitanteBusqueda planificacionSolicitanteBusquedaAux : listPlanificacionSolicitanteBusqueda) {
			xslString
					.append(getPlanificacionSolicitanteRow(planificacionSolicitanteBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	private static String getPlanificacionSolicitanteRow(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// Solicitante
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusqueda
							.getNombreEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusqueda
							.getNombreEu())));
		}

		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getNombreMunicipio())));
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getNumFormaciones())));
		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(
						planificacionSolicitanteBusqueda.getFechaSolicitud(),
						locale.getLanguage()))));
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusqueda
						.getIntervaloImparticion())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPlanificacionSolicitanteHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getPlanificacionSolicitanteHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para Planficacion solicitante
	 * 
	 * @return fields
	 */
	private String getPlanificacionSolicitanteHeaderRowFields() {
		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.solicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numformaciones", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechasolicitud", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.intervaloimparticion", null, locale)));

		return fields.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return String
	 */
	private String getConsultaDinamicaListTable(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda) {
		StringBuffer xslString = new StringBuffer();
		String elementoAnterior = "";
		String agrupacionSeleccionada = (consultaDinamicaBusqueda
				.getAgruparResultado() != null) ? consultaDinamicaBusqueda
				.getAgruparResultado() : "";

		// Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA; //C
		// Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE; //S
		// Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION; //THS
		// Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE; //THI
		Locale locale = LocaleContextHolder.getLocale();
		// add header
		xslString.append(getConsultaDinamicaHeaderRow(agrupacionSeleccionada));

		List<ConsultaDinamicaResultado> listConsultaDinamicaResultado = this.solicitudService
				.findAllConsultaDinamica(consultaDinamicaBusqueda, null);

		for (ConsultaDinamicaResultado consultaDinamicaResultadoAux : listConsultaDinamicaResultado) {

			if (agrupacionSeleccionada
					.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA)) {

				if (consultaDinamicaResultadoAux.getJerarquiaCategoria() != null) {

					if (consultaDinamicaResultadoAux.getJerarquiaCategoria()
							.equals(elementoAnterior)) {
						consultaDinamicaResultadoAux.setJerarquiaCategoria("");
					} else {
						elementoAnterior = consultaDinamicaResultadoAux
								.getJerarquiaCategoria();
					}
				} else {
					consultaDinamicaResultadoAux.setJerarquiaCategoria("");
				}

			} else if (agrupacionSeleccionada
					.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION)) {

				if (consultaDinamicaResultadoAux.getProvinciaParticipacion() != null) {
					if (consultaDinamicaResultadoAux
							.getProvinciaParticipacion().equals(
									elementoAnterior)) {
						consultaDinamicaResultadoAux
								.setProvinciaParticipacion("");
					} else {
						elementoAnterior = consultaDinamicaResultadoAux
								.getProvinciaParticipacion();
					}

				} else {
					consultaDinamicaResultadoAux.setProvinciaParticipacion("");
				}

			} else if (agrupacionSeleccionada
					.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE)) {

				if (consultaDinamicaResultadoAux.getProvinciaParticipacion() != null) {
					if (consultaDinamicaResultadoAux.getNombreProvincia()
							.equals(elementoAnterior)) {
						consultaDinamicaResultadoAux.setNombreProvincia("");
					} else {
						elementoAnterior = consultaDinamicaResultadoAux
								.getNombreProvincia();
					}
				} else {
					consultaDinamicaResultadoAux.setNombreProvincia("");
				}

			} else if (agrupacionSeleccionada
					.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE)) {

				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {

					if (consultaDinamicaResultadoAux.getNombreEntidadEs() != null) {

						if (consultaDinamicaResultadoAux.getNombreEntidadEs()
								.equals(elementoAnterior)) {
							consultaDinamicaResultadoAux.setNombreEntidadEs("");
						} else {
							elementoAnterior = consultaDinamicaResultadoAux
									.getNombreEntidadEs();
						}

					} else {
						consultaDinamicaResultadoAux.setNombreEntidadEs("");
					}

				} else {
					if (consultaDinamicaResultadoAux.getNombreEntidadEu() != null) {
						if (consultaDinamicaResultadoAux.getNombreEntidadEu()
								.equals(elementoAnterior)) {
							consultaDinamicaResultadoAux.setNombreEntidadEu("");
						} else {
							elementoAnterior = consultaDinamicaResultadoAux
									.getNombreEntidadEu();
						}
					} else {
						consultaDinamicaResultadoAux.setNombreEntidadEu("");
					}

				}

			}

			xslString.append(getConsultaDinamicaRow(
					consultaDinamicaResultadoAux, agrupacionSeleccionada));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getConsultaDinamicaHeaderRow(String agrupacionSeleccionada) {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		// --1ª columna--
		// primera columna en funcion de la agrupacion seleccionada
		if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA)) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.categoria", null, locale)));
		} else if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION)) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.provinciaformacion", null, locale)));
		} else if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE)) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.provinciasolicitante", null, locale)));
		} else if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE)) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.nombresolicitante", null, locale)));
		}

		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA))) {
			// CAT ------------------------------
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.categoria", null, locale)));
		}
		// FORM --------------------------------
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombreformacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombrecortoformacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.etiquetasformacion", null, locale)));

		// SOL ----------------------------------

		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION))) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.provinciaformacion", null, locale)));
		}
		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE))) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.nombresolicitante", null, locale)));
		}
		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE))) {
			fields.append(getHeaderField(appMessageSource.getMessage(
					"excel.provinciasolicitante", null, locale)));
		}
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipiosolicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.callesolicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.portalsolicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cpsolicitante", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombregrupo", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numparticipantes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.idioma", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.diaimparticion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaimparticion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numasistentes", null, locale)));

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nummujeres", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhombres", null, locale)));

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.etiquetasgrupo", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cancelacion", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombrecontacto", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.emailcontacto", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.telcontacto", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.observasolicitante", null, locale)));

		header.append(fields.toString());

		// if (agrupacionSeleccionada.equals("")) {
		// header.append(getCategoriaHeaderRowFields());
		// header.append(getFormacionHeaderRowFields());
		// header.append(getSolicitudHeaderRowFields(agrupacionSeleccionada));
		// } else if (agrupacionSeleccionada.equals("C")) {
		// header.append(getCategoriaHeaderRowFields());
		// header.append(getFormacionHeaderRowFields());
		// header.append(getSolicitudHeaderRowFields(agrupacionSeleccionada));
		// } else if (agrupacionSeleccionada.equals("S")) {
		// header.append(getSolicitudHeaderRowFields(agrupacionSeleccionada));
		// header.append(getCategoriaHeaderRowFields());
		// header.append(getFormacionHeaderRowFields());
		// } else {
		// header.append(getSolicitudHeaderRowFields(agrupacionSeleccionada));
		// header.append(getCategoriaHeaderRowFields());
		// header.append(getFormacionHeaderRowFields());
		// }

		header.append("</tr>");
		return header.toString();
	}

	// /**
	// * Genera cabecera para categoria
	// *
	// * @return fields
	// */
	// private String getCategoriaHeaderRowFields() {
	// StringBuffer fields = new StringBuffer();
	//
	// // Obtener el mensaje dependiendo del idioma
	// Locale locale = LocaleContextHolder.getLocale();
	//
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.categoria", null, locale)));
	//
	// return fields.toString();
	// }

	// /**
	// * Genera cabecera para formacion
	// *
	// * @return fields
	// */
	// private String getFormacionHeaderRowFields() {
	// StringBuffer fields = new StringBuffer();
	//
	// // Obtener el mensaje dependiendo del idioma
	// Locale locale = LocaleContextHolder.getLocale();
	//
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.nombreformacion", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.nombrecortoformacion", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.etiquetasformacion", null, locale)));
	//
	// return fields.toString();
	// }

	// /**
	// * Genera cabecera para formacion
	// *
	// * @return fields
	// */
	// private String getSolicitudHeaderRowFields(String agrupacionSeleccionada)
	// {
	// StringBuffer fields = new StringBuffer();
	//
	// // Obtener el mensaje dependiendo del idioma
	// Locale locale = LocaleContextHolder.getLocale();
	//
	// // primera columna en funcion de la agrupacion seleccionada
	// if (agrupacionSeleccionada
	// .equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION)) {
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.provinciaformacion", null, locale)));
	// } else if (agrupacionSeleccionada
	// .equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE)) {
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.provinciasolicitante", null, locale)));
	// } else if (agrupacionSeleccionada
	// .equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE)) {
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.nombresolicitante", null, locale)));
	// }
	//
	// // mantener el lugar de la columna en caso de que la agrupacion
	// // seleccionada no la convierta en la primera a pintar
	// if (!(agrupacionSeleccionada
	// .equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION))) {
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.provinciaformacion", null, locale)));
	// }
	// // mantener el lugar de la columna en caso de que la agrupacion
	// // seleccionada no la convierta en la primera a pintar
	// if (!(agrupacionSeleccionada
	// .equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE))) {
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.nombresolicitante", null, locale)));
	// }
	// // mantener el lugar de la columna en caso de que la agrupacion
	// // seleccionada no la convierta en la primera a pintar
	// if (!(agrupacionSeleccionada
	// .equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE))) {
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.provinciasolicitante", null, locale)));
	// }
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.municipiosolicitante", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.callesolicitante", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.portalsolicitante", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.cpsolicitante", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.nombregrupo", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.numparticipantes", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.idioma", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.diaimparticion", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.horaimparticion", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.numasistentes", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.etiquetasgrupo", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.cancelacion", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.nombrecontacto", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.emailcontacto", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.telcontacto", null, locale)));
	// fields.append(getHeaderField(appMessageSource.getMessage(
	// "excel.observasolicitante", null, locale)));
	//
	// return fields.toString();
	// }

	/**
	 * Generar cabeceras.
	 * 
	 * @param fieldName
	 *            String
	 * @return String
	 */
	private static String getHeaderField(String fieldName) {
		StringBuffer field = new StringBuffer();
		field.append("<th>");
		field.append(Y40aUtils.normalizarVacio(fieldName));
		field.append("</th>");
		return field.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param consultaDinamicaResultado
	 *            ConsultaDinamicaResultado
	 * @return String
	 */
	private String getConsultaDinamicaRow(
			ConsultaDinamicaResultado consultaDinamicaResultado,
			String agrupacionSeleccionada) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// --1ª columna--
		// primera columna en funcion de la agrupacion seleccionada
		if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA)) {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getJerarquiaCategoria())));
		} else if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION)) {

			if (Y40aConstantes.TH_ARABA
					.equalsIgnoreCase(consultaDinamicaResultado
							.getProvinciaParticipacion())) {
				row.append(getField(appMessageSource.getMessage("comun.araba",
						null, locale)));
			} else if (Y40aConstantes.TH_BIZKAIA
					.equalsIgnoreCase(consultaDinamicaResultado
							.getProvinciaParticipacion())) {
				row.append(getField(appMessageSource.getMessage(
						"comun.bizkaia", null, locale)));
			} else if (Y40aConstantes.TH_GIPUZKOA
					.equalsIgnoreCase(consultaDinamicaResultado
							.getProvinciaParticipacion())) {
				row.append(getField(appMessageSource.getMessage(
						"comun.gipuzkoa", null, locale)));
			} else {
				row.append(getField(Y40aUtils.normalizarVacio("")));
			}

		} else if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE)) {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getNombreProvincia())));
		} else if (agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE)) {
			if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y40aUtils
						.normalizarVacio(consultaDinamicaResultado
								.getNombreEntidadEs())));
			} else {
				row.append(getField(Y40aUtils
						.normalizarVacio(consultaDinamicaResultado
								.getNombreEntidadEu())));
			}
		}

		// 11111111111111111
		// Categoria

		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA))) {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getJerarquiaCategoria())));

		}

		// Formacion
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getNombreFormacionEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getNombreFormacionEu())));
		}

		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getNombreCortoEs())));
		} else {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getNombreCortoEu())));
		}

		// Etiquetas
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getEtiquetasFormacion())));

		// Solicitud
		// row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
		// .getProvinciaParticipacion())));

		// / 2222222222
		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION))) {
			if (Y40aConstantes.TH_ARABA
					.equalsIgnoreCase(consultaDinamicaResultado
							.getProvinciaParticipacion())) {
				row.append(getField(appMessageSource.getMessage("comun.araba",
						null, locale)));
			} else if (Y40aConstantes.TH_BIZKAIA
					.equalsIgnoreCase(consultaDinamicaResultado
							.getProvinciaParticipacion())) {
				row.append(getField(appMessageSource.getMessage(
						"comun.bizkaia", null, locale)));
			} else if (Y40aConstantes.TH_GIPUZKOA
					.equalsIgnoreCase(consultaDinamicaResultado
							.getProvinciaParticipacion())) {
				row.append(getField(appMessageSource.getMessage(
						"comun.gipuzkoa", null, locale)));
			} else {
				row.append(getField(Y40aUtils.normalizarVacio("")));
			}
		}

		// 3333333

		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE))) {
			if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y40aUtils
						.normalizarVacio(consultaDinamicaResultado
								.getNombreEntidadEs())));
			} else {
				row.append(getField(Y40aUtils
						.normalizarVacio(consultaDinamicaResultado
								.getNombreEntidadEu())));
			}
		}

		// 4444444444444
		// mantener el lugar de la columna en caso de que la agrupacion
		// seleccionada no la convierta en la primera a pintar
		if (!(agrupacionSeleccionada
				.equalsIgnoreCase(Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE))) {
			row.append(getField(Y40aUtils
					.normalizarVacio(consultaDinamicaResultado
							.getNombreProvincia())));
		}

		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getNombreMunicipio())));
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getNombreCalle())));
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getNombrePortal())));
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getNombreCp())));
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getGrupo())));
		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(consultaDinamicaResultado
						.getParticipantes()))));

		// Idioma
		if (null != consultaDinamicaResultado.getIdioma()) {
			if (consultaDinamicaResultado.getIdioma().equalsIgnoreCase(
					Y40aConstantes.CASTELLANO)) {
				row.append(getField(appMessageSource.getMessage(
						"idioma.castellano", null, locale)));
			} else {
				row.append(getField(appMessageSource.getMessage(
						"idioma.euskera", null, locale)));
			}

		} else {
			row.append(getField(""));
		}

		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(
						consultaDinamicaResultado.getDiaImparticion(),
						locale.getLanguage()))));

		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getHoraImparticion())));

		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(consultaDinamicaResultado.getAsistentes()))));

		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(consultaDinamicaResultado.getNumMujeres()))));

		row.append(getField(Y40aUtils.normalizarVacio(Y40aUtils
				.convertLong2String(consultaDinamicaResultado.getNumHombres()))));

		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getEtiquetasSolicitud())));

		// Cancelado
		if (null != consultaDinamicaResultado.getCancelado()) {
			if (consultaDinamicaResultado.getCancelado().equalsIgnoreCase(
					Y40aConstantes.SI)) {
				row.append(getField(appMessageSource.getMessage("comun.si",
						null, locale)));
			} else {
				row.append(getField(appMessageSource.getMessage("comun.no",
						null, locale)));
			}
		} else {
			row.append(getField(""));
		}

		// Datos del contacto solicitud
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getNombapecontacto())));
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getEmailcontacto())));
		row.append(getField(Y40aUtils.normalizarVacio(consultaDinamicaResultado
				.getTelcontacto())));

		if (consultaDinamicaResultado.getObservasolicitante() != null) {
			if (!consultaDinamicaResultado.getObservasolicitante().equals("")) {
				row.append(getField(appMessageSource.getMessage("comun.si",
						null, locale)));
			} else {
				row.append(getField(appMessageSource.getMessage("comun.no",
						null, locale)));
			}
		} else {
			row.append(getField(""));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getField(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append(Y40aUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldFecha(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append("=T(\"");
		field.append(Y40aUtils.normalizarVacio(fieldValue));
		field.append("\")");
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla de formaciones
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @return String
	 */
	public String getCabeceraLogo(String numCol) {
		StringBuffer xslString = new StringBuffer();
		// String urlLogo = StaticsContainer.staticsUrl
		// + "/y40a/images/y40a-logo-kontsumo2.png";

		Properties prop = Y40aConfig.loadProperties(Y40aConstantes.CONFIG_PATH);
		String urlImagenExcel = (String) prop.getProperty("URL_EXCEL_IMG");
		String urlLogo = "";

		String urlEstaticos = StaticsContainer.staticsUrl;
		if (urlEstaticos.substring(0, 1).equals("/")) { // des and above
			urlLogo = urlImagenExcel + urlEstaticos
					+ "/y40a/images/y40a-logo-kontsumo2.png";
		} else { // local
			urlLogo = urlEstaticos + "/y40a/images/y40a-logo-kontsumo2.png";
		}

		xslString.append("<table>");
		xslString.append("<tr>");
		xslString.append("<td colspan=\"" + numCol
				+ "\" style=\"height:76px\"><img src=\"" + urlLogo
				+ "\" height=\"76px\" width=\"256px\"></td>");
		xslString.append("</tr>");
		xslString.append("<tr><td colspan=\"" + numCol + "\">&nbsp;</td></tr>");
		xslString.append("</table>");
		return xslString.toString();
	}

	// ////////////////////
	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla de planificacionSolicitante
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	public String getPlanificacionSolicitanteBusquedaListaExcelCartas(
			List<PlanificacionSolicitanteBusquedaCartas> planificacionSolicitanteBusquedaCartas) {
		StringBuffer xslString = new StringBuffer();
		// xslString.append(this.getCabeceraLogo("5")); cartas sin logo
		xslString.append("<table border='1'>");

		xslString
				.append(this
						.getPlanificacionSolicitanteBusquedaListaCartas(planificacionSolicitanteBusquedaCartas));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param listPlanificacionSolicitanteBusqueda
	 *            List<PlanificacionSolicitanteBusqueda>
	 * @return String
	 */
	private String getPlanificacionSolicitanteBusquedaListaCartas(
			List<PlanificacionSolicitanteBusquedaCartas> listPlanificacionSolicitanteBusquedaCartas) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getPlanificacionSolicitanteBusquedaCartasHeaderRow());

		for (PlanificacionSolicitanteBusquedaCartas planificacionSolicitanteBusquedaCartasAux : listPlanificacionSolicitanteBusquedaCartas) {
			xslString
					.append(getPlanificacionSolicitanteBusquedaCartasRow(planificacionSolicitanteBusquedaCartasAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	private static String getPlanificacionSolicitanteBusquedaCartasRow(
			PlanificacionSolicitanteBusquedaCartas planificacionSolicitanteBusquedaCartas) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		Date fechaHoy = new Date();
		// String fechaActual =
		// Y40aUtils.formatearDateToString(fechaHoy,"yyyyMMdd");

		// Fecha actual_ES en formato texto
		row.append(getField(Y40aUtils
				.formatearDateToString(fechaHoy,
						Y40aConstantes.FORMATO_FULL_FECHA_ES,
						Y40aConstantes.CASTELLANO)));

		// Fecha actual_EU en formato texto
		row.append(getField(Y40aUtils.formatearDateToStringEuskera(fechaHoy,
				Y40aConstantes.FORMATO_FULL_FECHA_EU, Y40aConstantes.EUSKERA)));

		// // Fecha actual_ES con barras
		// row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
		// .parseDateToString(fechaHoy, Y40aConstantes.CASTELLANO))));
		//
		// // Fecha actual_EU con barras
		// row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
		// .parseDateToString(fechaHoy, Y40aConstantes.EUSKERA))));

		// Nombre Solicitante ES
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreEs())));

		// Nombre Solicitante EU
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreEu())));

		// Calle
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreCalle())));

		// Portal
		if (planificacionSolicitanteBusquedaCartas.getNoraPortalId() != null
				&& planificacionSolicitanteBusquedaCartas.getNoraPortalId()
						.equals("0")) {
			planificacionSolicitanteBusquedaCartas.setNombrePortal("");
		}

		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombrePortal())));

		// CP
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreCP())));

		// Municipio
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreMunicipio())));

		// Provincia
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreProvincia())));

		// Nº formaciones
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNumFormaciones())));
		// Aceptadas
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getAceptadas())));

		// fecha solicitud
		row.append(getFieldFecha(Y40aUtils.normalizarVacio(Y40aUtils
				.parseDateToString(planificacionSolicitanteBusquedaCartas
						.getFechaSolicitud(), locale.getLanguage()))));
		// intervaloEs
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getIntervaloImparticionEs())));

		// intervaloEu
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getIntervaloImparticionEu())));

		// campania nb es
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreCategoriaEs())));

		// campania nb es
		row.append(getField(Y40aUtils
				.normalizarVacio(planificacionSolicitanteBusquedaCartas
						.getNombreCategoriaEu())));

		// nb contacto - el del contacto si hay si no solicitante // SOLO
		// SOLICITANTE
		// if (planificacionSolicitanteBusqueda.getNombapecontacto() != null
		// && !planificacionSolicitanteBusqueda.getNombapecontacto()
		// .equals("")) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getNombapecontacto())));
		//
		// } else {

		// if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getNombreEs())));
		// } else {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getNombreEu())));
		// }

		// }
		// email
		// if (planificacionSolicitanteBusqueda.getEmailcontacto() != null
		// && !planificacionSolicitanteBusqueda.getEmailcontacto().equals(
		// "")) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getEmailcontacto())));
		//
		// } else {
		if (planificacionSolicitanteBusquedaCartas.getEmailEntidad() != null
				&& !planificacionSolicitanteBusquedaCartas.getEmailEntidad()
						.equals("")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusquedaCartas
							.getEmailEntidad())));
		} else {
			row.append(getField(""));
		}

		// }

		// telefono
		// if (planificacionSolicitanteBusqueda.getTelcontacto() != null
		// && !planificacionSolicitanteBusqueda.getTelcontacto()
		// .equals("")) {
		// row.append(getField(Y40aUtils
		// .normalizarVacio(planificacionSolicitanteBusqueda
		// .getTelcontacto())));
		//
		// } else {
		if (planificacionSolicitanteBusquedaCartas.getTelEntidad() != null
				&& !planificacionSolicitanteBusquedaCartas.getTelEntidad()
						.equals("")) {
			row.append(getField(Y40aUtils
					.normalizarVacio(planificacionSolicitanteBusquedaCartas
							.getTelEntidad())));
		} else {
			row.append(getField(""));
		}
		// }

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPlanificacionSolicitanteBusquedaCartasHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getPlanificacionSolicitanteBusquedaCartasHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para PlanificacionSolicitanteBusqueda
	 * 
	 * @return fields
	 */
	private String getPlanificacionSolicitanteBusquedaCartasHeaderRowFields() {
		StringBuffer fields = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.fechaactuales", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.fechaactualeu", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.nbEntidades", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.nbEntidadeu", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.calle", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.portal", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.cp", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.municipio", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.provincia", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.numformaciones", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.aceptadas", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.fechasolicitud", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.intervaloimparticion_es", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.intervaloimparticion_eu", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.campanianbes", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.campanianbeu", null, locale)));
		// fields.append(getHeaderField(appMessageSource.getMessage(
		// "excel.contacto", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.email", null, locale)));
		fields.append(getHeaderField(appMessageSource.getMessage(
				"excel.cartas.telefono", null, locale)));
		return fields.toString();
	}

}
