package com.ejie.y40a.service;

import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.ConsultaDinamicaBusqueda;
import com.ejie.y40a.model.FormacionBusqueda;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusquedaCartas;

/**
 *  
 */
public interface Y40aExcelGeneratorService {

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return String
	 */
	String getConsultaDinamicaExcel(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @return String
	 */
	String getFormacionBusquedaListaExcel(
			List<FormacionBusqueda> formacionBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla planificacion formacion
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return String
	 */
	String getPlanificacionFormacionExcel(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @return String
	 */
	String getPlanificacionFormacionListaExcel(
			List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la tabla planificacion formacion
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	String getPlanificacionSolicitanteExcel(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	String getPlanificacionSolicitanteBusquedaListaExcel(
			List<PlanificacionSolicitanteBusqueda> planificacionSolicitanteBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @return String
	 */
	String getPlanificacionSolicitanteDetalleListaExcel(
			List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @return String
	 */
	String getPlanificacionSolicitanteDetalleListaExcelCab(
			List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en la consulta dinamica
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @return String
	 */
	String getPlanificacionSolicitanteBusquedaListaExcelCartas(
			List<PlanificacionSolicitanteBusquedaCartas> planificacionSolicitanteBusquedaCartas);

}
