package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.T17ProvinciaDao;
import com.ejie.y40a.model.T17Provincia;

/**
 * T17ProvinciaServiceImpl  
 * 
 *  
 */
@Service(value = "t17ProvinciaService")
public class T17ProvinciaServiceImpl implements T17ProvinciaService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(T17ProvinciaServiceImpl.class);

	@Autowired
	private T17ProvinciaDao t17ProvinciaDao;

	/**
	 * Inserts a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Provincia add(T17Provincia t17Provincia) {
		return this.t17ProvinciaDao.add(t17Provincia);
	}

	/**
	 * Updates a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Provincia update(T17Provincia t17Provincia) {
		return this.t17ProvinciaDao.update(t17Provincia);
	}

	/**
	 * Finds a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	public T17Provincia find(T17Provincia t17Provincia) {
		return (T17Provincia) this.t17ProvinciaDao.find(t17Provincia);
	}

	/**
	 * Finds a List of rows in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Provincia> findAll(T17Provincia t17Provincia,
			Pagination pagination) {
		return (List<T17Provincia>) this.t17ProvinciaDao.findAll(t17Provincia,
				pagination);
	}

	/**
	 * Counts rows in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return Long
	 */
	public Long findAllCount(T17Provincia t17Provincia) {
		return this.t17ProvinciaDao.findAllCount(t17Provincia);
	}

	/**
	 * Finds rows in the T17Provincia table using like.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Provincia> findAllLike(T17Provincia t17Provincia,
			Pagination pagination, Boolean startsWith) {
		return (List<T17Provincia>) this.t17ProvinciaDao.findAllLike(
				t17Provincia, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Provincia t17Provincia) {
		this.t17ProvinciaDao.remove(t17Provincia);
	}

	/**
	 * Deletes multiple rows in the T17Provincia table.
	 * 
	 * @param t17ProvinciaList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Provincia> t17ProvinciaList) {
		for (T17Provincia t17ProvinciaAux : t17ProvinciaList) {
			this.t17ProvinciaDao.remove(t17ProvinciaAux);
		}
	}

	/**
	 * 
	 * @return T17ProvinciaDao
	 */
	public T17ProvinciaDao getT17ProvinciaDao() {
		return this.t17ProvinciaDao;
	}

	/**
	 * 
	 * @param t17ProvinciaDao
	 *            T17ProvinciaDao
	 */
	public void setT17ProvinciaDao(T17ProvinciaDao t17ProvinciaDao) {
		logger.info("Setting Dependency " + t17ProvinciaDao);
		this.t17ProvinciaDao = t17ProvinciaDao;
	}
}
