package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.T17PortalDao;
import com.ejie.y40a.model.T17Portal;

/**
 * T17PortalServiceImpl  
 * 
 *  
 */
@Service(value = "t17PortalService")
public class T17PortalServiceImpl implements T17PortalService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(T17PortalServiceImpl.class);

	@Autowired
	private T17PortalDao t17PortalDao;

	/**
	 * Inserts a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Portal add(T17Portal t17Portal) {
		return this.t17PortalDao.add(t17Portal);
	}

	/**
	 * Updates a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Portal update(T17Portal t17Portal) {
		return this.t17PortalDao.update(t17Portal);
	}

	/**
	 * Finds a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	public T17Portal find(T17Portal t17Portal) {
		return (T17Portal) this.t17PortalDao.find(t17Portal);
	}

	/**
	 * Finds a List of rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Portal> findAll(T17Portal t17Portal, Pagination pagination) {

		List<T17Portal> listPortal = this.t17PortalDao.findAll(t17Portal,
				pagination);

		for (T17Portal port : listPortal) {
			StringBuffer portal = new StringBuffer();

			portal.append(port.getNumero());

			if (port.getBis() != null && !port.getBis().equals("")) {
				portal.append("-").append(port.getBis());
			}

			port.setPortal(portal.toString());
		}

		return listPortal;
	}

	/**
	 * Counts rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return Long
	 */
	public Long findAllCount(T17Portal t17Portal) {
		return this.t17PortalDao.findAllCount(t17Portal);
	}

	/**
	 * Finds rows in the T17Portal table using like.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Portal> findAllLike(T17Portal t17Portal,
			Pagination pagination, Boolean startsWith) {
		return (List<T17Portal>) this.t17PortalDao.findAllLike(t17Portal,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Portal t17Portal) {
		this.t17PortalDao.remove(t17Portal);
	}

	/**
	 * Deletes multiple rows in the T17Portal table.
	 * 
	 * @param t17PortalList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Portal> t17PortalList) {
		for (T17Portal t17PortalAux : t17PortalList) {
			this.t17PortalDao.remove(t17PortalAux);
		}
	}

	/**
	 * 
	 * @return T17PortalDao
	 */
	public T17PortalDao getT17PortalDao() {
		return this.t17PortalDao;
	}

	/**
	 * 
	 * @param t17PortalDao
	 *            T17PortalDao
	 */
	public void setT17PortalDao(T17PortalDao t17PortalDao) {
		logger.info("Setting Dependency " + t17PortalDao);
		this.t17PortalDao = t17PortalDao;
	}

	/**
	 * Finds a List of distinct CP rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Portal> findAllLike_CodigoPostal(T17Portal t17Portal,
			Pagination pagination, Boolean startsWith) {
		return (List<T17Portal>) this.t17PortalDao.findAllLike_CodigoPostal(
				t17Portal, pagination, startsWith);
	}

	/**
	 * Finds a List of distinct CP rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	public T17Portal findCodigoPostal(T17Portal t17Portal) {
		return (T17Portal) this.t17PortalDao.findCodigoPostal(t17Portal);
	}

}
