package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.T17MunicipioDao;
import com.ejie.y40a.model.T17Municipio;

/**
 * T17MunicipioServiceImpl  
 * 
 *  
 */
@Service(value = "t17MunicipioService")
public class T17MunicipioServiceImpl implements T17MunicipioService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(T17MunicipioServiceImpl.class);
	@Autowired
	private T17MunicipioDao t17MunicipioDao;

	/**
	 * Inserts a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Municipio add(T17Municipio t17Municipio) {
		return this.t17MunicipioDao.add(t17Municipio);
	}

	/**
	 * Updates a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Municipio update(T17Municipio t17Municipio) {
		return this.t17MunicipioDao.update(t17Municipio);
	}

	/**
	 * Finds a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	public T17Municipio find(T17Municipio t17Municipio) {
		return (T17Municipio) this.t17MunicipioDao.find(t17Municipio);
	}

	/**
	 * Finds a List of rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Municipio> findAll(T17Municipio t17Municipio,
			Pagination pagination) {
		logger.debug("********************************************");

		return (List<T17Municipio>) this.t17MunicipioDao.findAll(t17Municipio,
				pagination);
	}

	/**
	 * Counts rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return Long
	 */
	public Long findAllCount(T17Municipio t17Municipio) {
		return this.t17MunicipioDao.findAllCount(t17Municipio);
	}

	/**
	 * Finds rows in the T17Municipio table using like.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Municipio> findAllLike(T17Municipio t17Municipio,
			Pagination pagination, Boolean startsWith) {
		return (List<T17Municipio>) this.t17MunicipioDao.findAllLike(
				t17Municipio, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Municipio t17Municipio) {
		this.t17MunicipioDao.remove(t17Municipio);
	}

	/**
	 * Deletes multiple rows in the T17Municipio table.
	 * 
	 * @param t17MunicipioList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Municipio> t17MunicipioList) {
		for (T17Municipio t17MunicipioAux : t17MunicipioList) {
			this.t17MunicipioDao.remove(t17MunicipioAux);
		}
	}

	/**
	 * 
	 * @return T17MunicipioDao
	 */
	public T17MunicipioDao getT17MunicipioDao() {
		return this.t17MunicipioDao;
	}

	/**
	 * 
	 * @param t17MunicipioDao
	 *            T17MunicipioDao
	 */
	public void setT17MunicipioDao(T17MunicipioDao t17MunicipioDao) {
		logger.info("Setting Dependency " + t17MunicipioDao);
		this.t17MunicipioDao = t17MunicipioDao;
	}
}
