package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.T17Municipio;

/**
 * T17MunicipioService  
 * 
 *  
 */
public interface T17MunicipioService {

	/**
	 * Inserts a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	T17Municipio add(T17Municipio t17Municipio);

	/**
	 * Updates a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	T17Municipio update(T17Municipio t17Municipio);

	/**
	 * Finds a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	T17Municipio find(T17Municipio t17Municipio);

	/**
	 * Finds a List of rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Municipio> findAll(T17Municipio t17Municipio, Pagination pagination);

	/**
	 * Counts rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return Long
	 */
	Long findAllCount(T17Municipio t17Municipio);

	/**
	 * Finds rows in the T17Municipio table using like.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Municipio> findAllLike(T17Municipio t17Municipio,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 */
	void remove(T17Municipio t17Municipio);

	/**
	 * Deletes multiple rows in the T17Municipio table.
	 * 
	 * @param t17MunicipioList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Municipio> t17MunicipioList);

}
