package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.T17ComarcaDao;
import com.ejie.y40a.model.T17Comarca;

/**
 * T17ComarcaServiceImpl  
 * 
 *  
 */
@Service(value = "t17ComarcaService")
public class T17ComarcaServiceImpl implements T17ComarcaService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(T17ComarcaServiceImpl.class);
	@Autowired
	private T17ComarcaDao t17ComarcaDao;

	/**
	 * Inserts a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Comarca add(T17Comarca t17Comarca) {
		return this.t17ComarcaDao.add(t17Comarca);
	}

	/**
	 * Updates a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Comarca update(T17Comarca t17Comarca) {
		return this.t17ComarcaDao.update(t17Comarca);
	}

	/**
	 * Finds a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	public T17Comarca find(T17Comarca t17Comarca) {
		return (T17Comarca) this.t17ComarcaDao.find(t17Comarca);
	}

	/**
	 * Finds a List of rows in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Comarca> findAll(T17Comarca t17Comarca, Pagination pagination) {
		return (List<T17Comarca>) this.t17ComarcaDao.findAll(t17Comarca,
				pagination);
	}

	/**
	 * Counts rows in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return Long
	 */
	public Long findAllCount(T17Comarca t17Comarca) {
		return this.t17ComarcaDao.findAllCount(t17Comarca);
	}

	/**
	 * Finds rows in the T17Comarca table using like.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Comarca> findAllLike(T17Comarca t17Comarca,
			Pagination pagination, Boolean startsWith) {
		return (List<T17Comarca>) this.t17ComarcaDao.findAllLike(t17Comarca,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Comarca t17Comarca) {
		this.t17ComarcaDao.remove(t17Comarca);
	}

	/**
	 * Deletes multiple rows in the T17Comarca table.
	 * 
	 * @param t17ComarcaList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Comarca> t17ComarcaList) {
		for (T17Comarca t17ComarcaAux : t17ComarcaList) {
			this.t17ComarcaDao.remove(t17ComarcaAux);
		}
	}

	/**
	 * 
	 * @return T17ComarcaDao
	 */
	public T17ComarcaDao getT17ComarcaDao() {
		return this.t17ComarcaDao;
	}

	/**
	 * 
	 * @param t17ComarcaDao
	 *            T17ComarcaDao
	 */
	public void setT17ComarcaDao(T17ComarcaDao t17ComarcaDao) {
		logger.info("Setting Dependency " + t17ComarcaDao);
		this.t17ComarcaDao = t17ComarcaDao;
	}
}
