package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.T17Calle;

/**
 * T17CalleService  
 * 
 *  
 */
public interface T17CalleService {

	/**
	 * Inserts a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle add(T17Calle T17Calle);

	/**
	 * Updates a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle update(T17Calle T17Calle);

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle find(T17Calle T17Calle);

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Calle> findAll(T17Calle T17Calle, Pagination pagination);

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return Long
	 */
	Long findAllCount(T17Calle T17Calle);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Calle> findAllLike(T17Calle T17Calle, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Calle> findAllLike_Calle(T17Calle T17Calle, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 */
	void remove(T17Calle T17Calle);

	/**
	 * Deletes multiple rows in the T17Calle table.
	 * 
	 * @param T17CalleList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Calle> T17CalleList);

}
