package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.ConsultaDinamicaBusqueda;
import com.ejie.y40a.model.ConsultaDinamicaResultado;
import com.ejie.y40a.model.EntidadDetalle;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusquedaCartas;
import com.ejie.y40a.model.Solicitud;
import com.ejie.y40a.model.SolicitudDetalle;

/**
 * * SolicitudService  
 * 
 *  
 */

public interface SolicitudService {

	/**
	 * Inserts a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud add(Solicitud solicitud);

	/**
	 * Inserts a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud addSolicitud(Solicitud solicitud);

	/**
	 * Updates a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud update(Solicitud solicitud);

	/**
	 * Updates a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud updateSolicitud(Solicitud solicitud);

	/**
	 * Finds a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud find(Solicitud solicitud);

	/**
	 * Finds a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle findSolicitud(Solicitud solicitud);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Solicitud> findAll(Solicitud solicitud, Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	Long findAllCount(Solicitud solicitud);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlanificacionSolicitanteBusqueda> findAllPlanificacionSolicitante(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return Long
	 */
	Long findAllPlanificacionSolicitanteCount(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda,
			Vector<String> perfiles);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlanificacionFormacionBusqueda> findAllPlanificacionFormacion(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return Long
	 */
	Long findAllPlanificacionFormacionCount(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles);

	/**
	 * Finds rows in the Solicitud table using like.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Solicitud> findAllLike(Solicitud solicitud, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	void remove(Solicitud solicitud);

	/**
	 * Deletes a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	void removeSolicitud(Solicitud solicitud);

	/**
	 * Deletes multiple rows in the Solicitud table.
	 * 
	 * @param solicitudList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Solicitud> solicitudList);

	/**
	 * Inserts a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud addSolicitudEtiqueta(Solicitud solicitud);

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 */
	void removeSolicitudEtiqueta(Solicitud solicitud);

	/**
	 * Find a single row in the findSolicitudEtiqueta Many To Many relationship.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Solicitud
	 */
	Solicitud findSolicitudEtiqueta(Solicitud solicitud, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param etiqueta
	 *            Etiqueta
	 * @return List
	 */
	Long findSolicitudEtiquetaCount(Solicitud solicitud, Etiqueta etiqueta);

	/**
	 * Finds a single row in the Solicitante table.
	 * 
	 * @param entidadDetalle
	 *            EntidadDetalle
	 * @return EntidadDetalle
	 */
	EntidadDetalle findEntidadSolicitante(EntidadDetalle entidadDetalle);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsultaDinamicaResultado> findAllConsultaDinamica(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return Long
	 */
	Long findAllConsultaDinamicaCount(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda);

	/**
	 * Devuelve el xml para cargarlo en la aplicacion de organismos.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return String
	 */
	String findAllConsultaDinamicaXML(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	public Solicitud copiarSolicitud(Solicitud solicitud);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlanificacionSolicitanteBusquedaCartas> findAllPlanificacionSolicitanteCartas(
			PlanificacionSolicitanteBusquedaCartas planificacionSolicitanteBusquedaCartas,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Blocks multiple rows in the Solicitud table.
	 * 
	 * @param solicitudList
	 *            ArrayList
	 * @return
	 */
	void blockMultiple(List<Solicitud> solicitudList);

	/**
	 * Unblocks multiple rows in the Solicitud table.
	 * 
	 * @param solicitudList
	 *            ArrayList
	 * @return
	 */
	void unblockMultiple(List<Solicitud> solicitudList);

	/**
	 * Unblocks multiple rows in the Solicitud table.
	 * 
	 * @param solicitudList
	 *            ArrayList
	 * @return
	 */

	void bloquearSolicitudesAutomaticamente();

}
