package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.PerfilDao;
import com.ejie.y40a.model.Categoria;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Perfil;

/**
 *  * PerfilServiceImpl  
 *  
 */

@Service(value = "perfilService")
public  class PerfilServiceImpl implements PerfilService {

	private static final  Logger logger = LoggerFactory.getLogger(PerfilServiceImpl.class);
	@Autowired
	private PerfilDao perfilDao;

	/**
	 * Inserts a single row in the Perfil table.
	 *
	 * @param perfil Perfil
	 * @return Perfil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Perfil add(Perfil perfil) {
		return this.perfilDao.add(perfil);
	}

	/**
	 * Updates a single row in the Perfil table.
	 *
	 * @param perfil Perfil
	 * @return Perfil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Perfil update(Perfil perfil) {
		return this.perfilDao.update(perfil);
	 }

	/**
	 * Finds a single row in the Perfil table.
	 *
	 * @param perfil Perfil
	 * @return Perfil
	 */
	public Perfil find(Perfil perfil) {
		return (Perfil) this.perfilDao.find(perfil);
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 *
	 * @param perfil Perfil
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Perfil> findAll(Perfil perfil, Pagination pagination) {
		return (List<Perfil>) this.perfilDao.findAll(perfil, pagination);
	}
    
	/**
	 * Counts rows in the Perfil table.
	 *
	 * @param perfil Perfil
	 * @return Long
	 */
	public Long findAllCount(Perfil perfil) {        
		return  this.perfilDao.findAllCount(perfil);
	}

	/**
	 * Finds rows in the Perfil table using like.
	 *
	 * @param perfil Perfil
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Perfil> findAllLike(Perfil perfil, Pagination pagination, Boolean startsWith) {
		return (List<Perfil>) this.perfilDao.findAllLike(perfil, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Perfil table.
	 *
	 * @param perfil Perfil
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Perfil perfil) {
		this.perfilDao.remove(perfil);
	}
	
	/**
	 * Deletes multiple rows in the Perfil table.
	 *
	 * @param perfilList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Perfil> perfilList) {
		for (Perfil  perfilAux:perfilList) {
			this.perfilDao.remove(perfilAux);
		}
	}


	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 *
	 * @param perfil  Perfil
	 * @return Perfil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Perfil addCategoriaPerfil (Perfil perfil) {
		return this.perfilDao.addCategoriaPerfil(perfil);
	}
    
	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 *
	 * @param perfil Perfil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCategoriaPerfil(Perfil perfil) {
		this.perfilDao.removeCategoriaPerfil(perfil);
	}
    
	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 *
	 * @param perfil Perfil
	 * @param  categoria Categoria
	 * @param pagination Pagination
	 * @return Perfil
	 */
	public Perfil findCategoriaPerfil(Perfil perfil, Categoria  categoria, Pagination pagination) {
		return this.perfilDao.findCategoriaPerfil(perfil, categoria, pagination);
	}
    
	/**
	 * Counts rows in the CategoriaPerfil table.
	 *
	 * @param perfil Perfil
	 * @param  categoria Categoria
	 * @return List
	 */
	public Long findCategoriaPerfilCount(Perfil perfil, Categoria categoria) {
		return this.perfilDao.findCategoriaPerfilCount(perfil, categoria);
	}

	/**
	 * Getter method for PerfilDao
	 *
	 * @return PerfilDao
	 */
	public PerfilDao getPerfilDao() {
		return this.perfilDao;
	}
    
	/**
	 * Setter method for PerfilDao.
	 *
	 * @param  perfilDao PerfilDao
	 * @return
	 */
	public void setPerfilDao(PerfilDao perfilDao) {
		logger.info("Setting Dependency "+perfilDao);
		this.perfilDao = perfilDao;
	}
}

