package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.ParametrosDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Parametros;

/**
 *  * ParametrosServiceImpl  
 *  
 */

@Service(value = "parametrosService")
public  class ParametrosServiceImpl implements ParametrosService {

	private static final  Logger logger = LoggerFactory.getLogger(ParametrosServiceImpl.class);
	@Autowired
	private ParametrosDao parametrosDao;

	/**
	 * Inserts a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Parametros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parametros add(Parametros parametros) {
		return this.parametrosDao.add(parametros);
	}

	/**
	 * Updates a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Parametros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parametros update(Parametros parametros) {
		return this.parametrosDao.update(parametros);
	 }

	/**
	 * Finds a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Parametros
	 */
	public Parametros find(Parametros parametros) {
		return (Parametros) this.parametrosDao.find(parametros);
	}

	/**
	 * Finds a List of rows in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Parametros> findAll(Parametros parametros, Pagination pagination) {
		return (List<Parametros>) this.parametrosDao.findAll(parametros, pagination);
	}
    
	/**
	 * Counts rows in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Long
	 */
	public Long findAllCount(Parametros parametros) {        
		return  this.parametrosDao.findAllCount(parametros);
	}

	/**
	 * Finds rows in the Parametros table using like.
	 *
	 * @param parametros Parametros
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Parametros> findAllLike(Parametros parametros, Pagination pagination, Boolean startsWith) {
		return (List<Parametros>) this.parametrosDao.findAllLike(parametros, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Parametros parametros) {
		this.parametrosDao.remove(parametros);
	}
	
	/**
	 * Deletes multiple rows in the Parametros table.
	 *
	 * @param parametrosList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Parametros> parametrosList) {
		for (Parametros  parametrosAux:parametrosList) {
			this.parametrosDao.remove(parametrosAux);
		}
	}


	/**
	 * Getter method for ParametrosDao
	 *
	 * @return ParametrosDao
	 */
	public ParametrosDao getParametrosDao() {
		return this.parametrosDao;
	}
    
	/**
	 * Setter method for ParametrosDao.
	 *
	 * @param  parametrosDao ParametrosDao
	 * @return
	 */
	public void setParametrosDao(ParametrosDao parametrosDao) {
		logger.info("Setting Dependency "+parametrosDao);
		this.parametrosDao = parametrosDao;
	}
}

