package com.ejie.y40a.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y40a.model.Parametros;

/**
 *  * ParametrosService  
 *  
 */

public interface ParametrosService {

	/**
	 * Inserts a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Parametros
	 */
    Parametros add(Parametros parametros);

	/**
	 * Updates a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Parametros
	 */
	Parametros update(Parametros parametros);

	/**
	 * Finds a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Parametros
	 */
	Parametros find(Parametros parametros);

	/**
	 * Finds a List of rows in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @param pagination Pagination
	 * @return List
	 */
	List<Parametros> findAll(Parametros parametros, Pagination pagination);

	/**
	 * Counts rows in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return Long
	 */
	Long findAllCount(Parametros parametros);
	
	/**
	 * Finds rows in the Parametros table using like.
	 *
	 * @param parametros Parametros
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Parametros> findAllLike(Parametros parametros, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Parametros table.
	 *
	 * @param parametros Parametros
	 * @return 
	 */
	void remove(Parametros parametros);
	
	/**
	 * Deletes multiple rows in the Parametros table.
	 *
	 * @param parametrosList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<Parametros> parametrosList);
    
}


