package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.ObservacionesDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Observaciones;

/**
 *  * ObservacionesServiceImpl  
 *  
 */

@Service(value = "observacionesService")
public  class ObservacionesServiceImpl implements ObservacionesService {

	private static final  Logger logger = LoggerFactory.getLogger(ObservacionesServiceImpl.class);
	@Autowired
	private ObservacionesDao observacionesDao;

	/**
	 * Inserts a single row in the Observaciones table.
	 *
	 * @param observaciones Observaciones
	 * @return Observaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Observaciones add(Observaciones observaciones) {
		return this.observacionesDao.add(observaciones);
	}

	/**
	 * Updates a single row in the Observaciones table.
	 *
	 * @param observaciones Observaciones
	 * @return Observaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Observaciones update(Observaciones observaciones) {
		return this.observacionesDao.update(observaciones);
	 }

	/**
	 * Finds a single row in the Observaciones table.
	 *
	 * @param observaciones Observaciones
	 * @return Observaciones
	 */
	public Observaciones find(Observaciones observaciones) {
		return (Observaciones) this.observacionesDao.find(observaciones);
	}

	/**
	 * Finds a List of rows in the Observaciones table.
	 *
	 * @param observaciones Observaciones
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Observaciones> findAll(Observaciones observaciones, Pagination pagination) {
		return (List<Observaciones>) this.observacionesDao.findAll(observaciones, pagination);
	}
    
	/**
	 * Counts rows in the Observaciones table.
	 *
	 * @param observaciones Observaciones
	 * @return Long
	 */
	public Long findAllCount(Observaciones observaciones) {        
		return  this.observacionesDao.findAllCount(observaciones);
	}

	/**
	 * Finds rows in the Observaciones table using like.
	 *
	 * @param observaciones Observaciones
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Observaciones> findAllLike(Observaciones observaciones, Pagination pagination, Boolean startsWith) {
		return (List<Observaciones>) this.observacionesDao.findAllLike(observaciones, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Observaciones table.
	 *
	 * @param observaciones Observaciones
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Observaciones observaciones) {
		this.observacionesDao.remove(observaciones);
	}
	
	/**
	 * Deletes multiple rows in the Observaciones table.
	 *
	 * @param observacionesList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Observaciones> observacionesList) {
		for (Observaciones  observacionesAux:observacionesList) {
			this.observacionesDao.remove(observacionesAux);
		}
	}


	/**
	 * Getter method for ObservacionesDao
	 *
	 * @return ObservacionesDao
	 */
	public ObservacionesDao getObservacionesDao() {
		return this.observacionesDao;
	}
    
	/**
	 * Setter method for ObservacionesDao.
	 *
	 * @param  observacionesDao ObservacionesDao
	 * @return
	 */
	public void setObservacionesDao(ObservacionesDao observacionesDao) {
		logger.info("Setting Dependency "+observacionesDao);
		this.observacionesDao = observacionesDao;
	}
}

