package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.ObservacionesEntidadDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.ObservacionesEntidad;

/**
 *  * ObservacionesEntidadServiceImpl  
 *  
 */

@Service(value = "observacionesEntidadService")
public  class ObservacionesEntidadServiceImpl implements ObservacionesEntidadService {

	private static final  Logger logger = LoggerFactory.getLogger(ObservacionesEntidadServiceImpl.class);
	@Autowired
	private ObservacionesEntidadDao observacionesEntidadDao;

	/**
	 * Inserts a single row in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @return ObservacionesEntidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ObservacionesEntidad add(ObservacionesEntidad observacionesEntidad) {
		return this.observacionesEntidadDao.add(observacionesEntidad);
	}

	/**
	 * Updates a single row in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @return ObservacionesEntidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ObservacionesEntidad update(ObservacionesEntidad observacionesEntidad) {
		return this.observacionesEntidadDao.update(observacionesEntidad);
	 }

	/**
	 * Finds a single row in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @return ObservacionesEntidad
	 */
	public ObservacionesEntidad find(ObservacionesEntidad observacionesEntidad) {
		return (ObservacionesEntidad) this.observacionesEntidadDao.find(observacionesEntidad);
	}

	/**
	 * Finds a List of rows in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @param pagination Pagination
	 * @return List
	 */
	public List<ObservacionesEntidad> findAll(ObservacionesEntidad observacionesEntidad, Pagination pagination) {
		return (List<ObservacionesEntidad>) this.observacionesEntidadDao.findAll(observacionesEntidad, pagination);
	}
    
	/**
	 * Counts rows in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @return Long
	 */
	public Long findAllCount(ObservacionesEntidad observacionesEntidad) {        
		return  this.observacionesEntidadDao.findAllCount(observacionesEntidad);
	}

	/**
	 * Finds rows in the ObservacionesEntidad table using like.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<ObservacionesEntidad> findAllLike(ObservacionesEntidad observacionesEntidad, Pagination pagination, Boolean startsWith) {
		return (List<ObservacionesEntidad>) this.observacionesEntidadDao.findAllLike(observacionesEntidad, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidad ObservacionesEntidad
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ObservacionesEntidad observacionesEntidad) {
		this.observacionesEntidadDao.remove(observacionesEntidad);
	}
	
	/**
	 * Deletes multiple rows in the ObservacionesEntidad table.
	 *
	 * @param observacionesEntidadList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<ObservacionesEntidad> observacionesEntidadList) {
		for (ObservacionesEntidad  observacionesEntidadAux:observacionesEntidadList) {
			this.observacionesEntidadDao.remove(observacionesEntidadAux);
		}
	}


	/**
	 * Getter method for ObservacionesEntidadDao
	 *
	 * @return ObservacionesEntidadDao
	 */
	public ObservacionesEntidadDao getObservacionesEntidadDao() {
		return this.observacionesEntidadDao;
	}
    
	/**
	 * Setter method for ObservacionesEntidadDao.
	 *
	 * @param  observacionesEntidadDao ObservacionesEntidadDao
	 * @return
	 */
	public void setObservacionesEntidadDao(ObservacionesEntidadDao observacionesEntidadDao) {
		logger.info("Setting Dependency "+observacionesEntidadDao);
		this.observacionesEntidadDao = observacionesEntidadDao;
	}
}

