package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.MotivosCancelacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.MotivosCancelacion;

/**
 *  * MotivosCancelacionServiceImpl  
 *  
 */

@Service(value = "motivosCancelacionService")
public  class MotivosCancelacionServiceImpl implements MotivosCancelacionService {

	private static final  Logger logger = LoggerFactory.getLogger(MotivosCancelacionServiceImpl.class);
	@Autowired
	private MotivosCancelacionDao motivosCancelacionDao;

	/**
	 * Inserts a single row in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @return MotivosCancelacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public MotivosCancelacion add(MotivosCancelacion motivosCancelacion) {
		return this.motivosCancelacionDao.add(motivosCancelacion);
	}

	/**
	 * Updates a single row in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @return MotivosCancelacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public MotivosCancelacion update(MotivosCancelacion motivosCancelacion) {
		return this.motivosCancelacionDao.update(motivosCancelacion);
	 }

	/**
	 * Finds a single row in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @return MotivosCancelacion
	 */
	public MotivosCancelacion find(MotivosCancelacion motivosCancelacion) {
		return (MotivosCancelacion) this.motivosCancelacionDao.find(motivosCancelacion);
	}

	/**
	 * Finds a List of rows in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<MotivosCancelacion> findAll(MotivosCancelacion motivosCancelacion, Pagination pagination) {
		return (List<MotivosCancelacion>) this.motivosCancelacionDao.findAll(motivosCancelacion, pagination);
	}
    
	/**
	 * Counts rows in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @return Long
	 */
	public Long findAllCount(MotivosCancelacion motivosCancelacion) {        
		return  this.motivosCancelacionDao.findAllCount(motivosCancelacion);
	}

	/**
	 * Finds rows in the MotivosCancelacion table using like.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<MotivosCancelacion> findAllLike(MotivosCancelacion motivosCancelacion, Pagination pagination, Boolean startsWith) {
		return (List<MotivosCancelacion>) this.motivosCancelacionDao.findAllLike(motivosCancelacion, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacion MotivosCancelacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(MotivosCancelacion motivosCancelacion) {
		this.motivosCancelacionDao.remove(motivosCancelacion);
	}
	
	/**
	 * Deletes multiple rows in the MotivosCancelacion table.
	 *
	 * @param motivosCancelacionList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<MotivosCancelacion> motivosCancelacionList) {
		for (MotivosCancelacion  motivosCancelacionAux:motivosCancelacionList) {
			this.motivosCancelacionDao.remove(motivosCancelacionAux);
		}
	}


	/**
	 * Getter method for MotivosCancelacionDao
	 *
	 * @return MotivosCancelacionDao
	 */
	public MotivosCancelacionDao getMotivosCancelacionDao() {
		return this.motivosCancelacionDao;
	}
    
	/**
	 * Setter method for MotivosCancelacionDao.
	 *
	 * @param  motivosCancelacionDao MotivosCancelacionDao
	 * @return
	 */
	public void setMotivosCancelacionDao(MotivosCancelacionDao motivosCancelacionDao) {
		logger.info("Setting Dependency "+motivosCancelacionDao);
		this.motivosCancelacionDao = motivosCancelacionDao;
	}
}

