package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.HistoricoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Historico;
import com.ejie.y40a.utils.Y40aUIDGenerator;

/**
 * * HistoricoServiceImpl  
 * 
 *  
 */

@Service(value = "historicoService")
public class HistoricoServiceImpl implements HistoricoService {

	private static final Logger logger = LoggerFactory
			.getLogger(HistoricoServiceImpl.class);
	@Autowired
	private HistoricoDao historicoDao;

	/**
	 * Inserts a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historico add(Historico historico) {
		historico.setIdHist(Y40aUIDGenerator.getInstance().generateId(
				Y40aConstantes.PK_SIZE));
		return this.historicoDao.add(historico);
	}

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historico update(Historico historico) {
		return this.historicoDao.update(historico);
	}

	/**
	 * Finds a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	public Historico find(Historico historico) {
		return (Historico) this.historicoDao.find(historico);
	}

	/**
	 * Finds a List of rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Historico> findAll(Historico historico, Pagination pagination) {
		return (List<Historico>) this.historicoDao.findAll(historico,
				pagination);
	}

	/**
	 * Counts rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Long
	 */
	public Long findAllCount(Historico historico) {
		return this.historicoDao.findAllCount(historico);
	}

	/**
	 * Finds rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Historico> findAllLike(Historico historico,
			Pagination pagination, Boolean startsWith) {
		return (List<Historico>) this.historicoDao.findAllLike(historico,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Historico historico) {
		this.historicoDao.remove(historico);
	}

	/**
	 * Deletes multiple rows in the Historico table.
	 * 
	 * @param historicoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Historico> historicoList) {
		for (Historico historicoAux : historicoList) {
			this.historicoDao.remove(historicoAux);
		}
	}

	/**
	 * Getter method for HistoricoDao
	 * 
	 * @return HistoricoDao
	 */
	public HistoricoDao getHistoricoDao() {
		return this.historicoDao;
	}

	/**
	 * Setter method for HistoricoDao.
	 * 
	 * @param historicoDao
	 *            HistoricoDao
	 * @return
	 */
	public void setHistoricoDao(HistoricoDao historicoDao) {
		logger.info("Setting Dependency " + historicoDao);
		this.historicoDao = historicoDao;
	}
}
