package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.GrupoDao;
import com.ejie.y40a.model.Categoria;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Grupo;

/**
 * * GrupoServiceImpl  
 * 
 *  
 */

@Service(value = "grupoService")
public class GrupoServiceImpl implements GrupoService {

	private static final Logger logger = LoggerFactory
			.getLogger(GrupoServiceImpl.class);
	@Autowired
	private GrupoDao grupoDao;

	/**
	 * Inserts a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Grupo add(Grupo grupo) {
		return this.grupoDao.add(grupo);
	}

	/**
	 * Updates a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Grupo update(Grupo grupo) {
		return this.grupoDao.update(grupo);
	}

	/**
	 * Finds a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	public Grupo find(Grupo grupo) {
		return (Grupo) this.grupoDao.find(grupo);
	}

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Grupo> findAll(Grupo grupo, Pagination pagination) {
		return (List<Grupo>) this.grupoDao.findAll(grupo, pagination);
	}

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	public Long findAllCount(Grupo grupo) {
		return this.grupoDao.findAllCount(grupo);
	}

	/**
	 * Finds rows in the Grupo table using like.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Grupo> findAllLike(Grupo grupo, Pagination pagination,
			Boolean startsWith) {
		return (List<Grupo>) this.grupoDao.findAllLike(grupo, pagination,
				startsWith);
	}

	/**
	 * Deletes a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Grupo grupo) {
		this.grupoDao.remove(grupo);
	}

	/**
	 * Deletes multiple rows in the Grupo table.
	 * 
	 * @param grupoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Grupo> grupoList) {
		for (Grupo grupoAux : grupoList) {
			this.grupoDao.remove(grupoAux);
		}
	}

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Grupo addCategoriaGrupos(Grupo grupo) {
		return this.grupoDao.addCategoriaGrupos(grupo);
	}

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCategoriaGrupos(Grupo grupo) {
		this.grupoDao.removeCategoriaGrupos(grupo);
	}

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return Grupo
	 */
	public Grupo findCategoriaGrupos(Grupo grupo, Categoria categoria,
			Pagination pagination) {
		return this.grupoDao.findCategoriaGrupos(grupo, categoria, pagination);
	}

	/**
	 * Counts rows in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	public Long findCategoriaGruposCount(Grupo grupo, Categoria categoria) {
		return this.grupoDao.findCategoriaGruposCount(grupo, categoria);
	}

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param idCategoria
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Grupo> findAllGruposCategoria(Grupo grupo, String idCategoria,
			Pagination pagination) {
		return this.grupoDao.findAllGruposCategoria(grupo, idCategoria,
				pagination);
	}

	/**
	 * Getter method for GrupoDao
	 * 
	 * @return GrupoDao
	 */
	public GrupoDao getGrupoDao() {
		return this.grupoDao;
	}

	/**
	 * Setter method for GrupoDao.
	 * 
	 * @param grupoDao
	 *            GrupoDao
	 * @return
	 */
	public void setGrupoDao(GrupoDao grupoDao) {
		logger.info("Setting Dependency " + grupoDao);
		this.grupoDao = grupoDao;
	}

}
