package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Categoria;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y40a.model.Grupo;

/**
 * * GrupoService  
 * 
 *  
 */

public interface GrupoService {

	/**
	 * Inserts a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo add(Grupo grupo);

	/**
	 * Updates a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo update(Grupo grupo);

	/**
	 * Finds a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo find(Grupo grupo);

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Grupo> findAll(Grupo grupo, Pagination pagination);

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	Long findAllCount(Grupo grupo);

	/**
	 * Finds rows in the Grupo table using like.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Grupo> findAllLike(Grupo grupo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	void remove(Grupo grupo);

	/**
	 * Deletes multiple rows in the Grupo table.
	 * 
	 * @param grupoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Grupo> grupoList);

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo addCategoriaGrupos(Grupo grupo);

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 */
	void removeCategoriaGrupos(Grupo grupo);

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return Grupo
	 */
	Grupo findCategoriaGrupos(Grupo grupo, Categoria categoria,
			Pagination pagination);

	/**
	 * Counts rows in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @return List
	 */
	Long findCategoriaGruposCount(Grupo grupo, Categoria categoria);

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param idCategoria
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Grupo> findAllGruposCategoria(Grupo grupo, String idCategoria,
			Pagination pagination);
}
