package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.GrupoEntidadDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.GrupoEntidad;

/**
 *  * GrupoEntidadServiceImpl  
 *  
 */

@Service(value = "grupoEntidadService")
public  class GrupoEntidadServiceImpl implements GrupoEntidadService {

	private static final  Logger logger = LoggerFactory.getLogger(GrupoEntidadServiceImpl.class);
	@Autowired
	private GrupoEntidadDao grupoEntidadDao;

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return GrupoEntidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public GrupoEntidad add(GrupoEntidad grupoEntidad) {
		return this.grupoEntidadDao.add(grupoEntidad);
	}

	/**
	 * Updates a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return GrupoEntidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public GrupoEntidad update(GrupoEntidad grupoEntidad) {
		return this.grupoEntidadDao.update(grupoEntidad);
	 }

	/**
	 * Finds a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return GrupoEntidad
	 */
	public GrupoEntidad find(GrupoEntidad grupoEntidad) {
		return (GrupoEntidad) this.grupoEntidadDao.find(grupoEntidad);
	}

	/**
	 * Finds a List of rows in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @param pagination Pagination
	 * @return List
	 */
	public List<GrupoEntidad> findAll(GrupoEntidad grupoEntidad, Pagination pagination) {
		return (List<GrupoEntidad>) this.grupoEntidadDao.findAll(grupoEntidad, pagination);
	}
    
	/**
	 * Counts rows in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return Long
	 */
	public Long findAllCount(GrupoEntidad grupoEntidad) {        
		return  this.grupoEntidadDao.findAllCount(grupoEntidad);
	}

	/**
	 * Finds rows in the GrupoEntidad table using like.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<GrupoEntidad> findAllLike(GrupoEntidad grupoEntidad, Pagination pagination, Boolean startsWith) {
		return (List<GrupoEntidad>) this.grupoEntidadDao.findAllLike(grupoEntidad, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(GrupoEntidad grupoEntidad) {
		this.grupoEntidadDao.remove(grupoEntidad);
	}
	
	/**
	 * Deletes multiple rows in the GrupoEntidad table.
	 *
	 * @param grupoEntidadList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<GrupoEntidad> grupoEntidadList) {
		for (GrupoEntidad  grupoEntidadAux:grupoEntidadList) {
			this.grupoEntidadDao.remove(grupoEntidadAux);
		}
	}


	/**
	 * Getter method for GrupoEntidadDao
	 *
	 * @return GrupoEntidadDao
	 */
	public GrupoEntidadDao getGrupoEntidadDao() {
		return this.grupoEntidadDao;
	}
    
	/**
	 * Setter method for GrupoEntidadDao.
	 *
	 * @param  grupoEntidadDao GrupoEntidadDao
	 * @return
	 */
	public void setGrupoEntidadDao(GrupoEntidadDao grupoEntidadDao) {
		logger.info("Setting Dependency "+grupoEntidadDao);
		this.grupoEntidadDao = grupoEntidadDao;
	}
}

