package com.ejie.y40a.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y40a.model.GrupoEntidad;

/**
 *  * GrupoEntidadService  
 *  
 */

public interface GrupoEntidadService {

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return GrupoEntidad
	 */
    GrupoEntidad add(GrupoEntidad grupoEntidad);

	/**
	 * Updates a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return GrupoEntidad
	 */
	GrupoEntidad update(GrupoEntidad grupoEntidad);

	/**
	 * Finds a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return GrupoEntidad
	 */
	GrupoEntidad find(GrupoEntidad grupoEntidad);

	/**
	 * Finds a List of rows in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @param pagination Pagination
	 * @return List
	 */
	List<GrupoEntidad> findAll(GrupoEntidad grupoEntidad, Pagination pagination);

	/**
	 * Counts rows in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return Long
	 */
	Long findAllCount(GrupoEntidad grupoEntidad);
	
	/**
	 * Finds rows in the GrupoEntidad table using like.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<GrupoEntidad> findAllLike(GrupoEntidad grupoEntidad, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the GrupoEntidad table.
	 *
	 * @param grupoEntidad GrupoEntidad
	 * @return 
	 */
	void remove(GrupoEntidad grupoEntidad);
	
	/**
	 * Deletes multiple rows in the GrupoEntidad table.
	 *
	 * @param grupoEntidadList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<GrupoEntidad> grupoEntidadList);
    
}


