package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.FormacionBusqueda;

/**
 * * FormacionService  
 * 
 *  
 */

public interface FormacionService {

	/**
	 * Inserts a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion add(Formacion formacion);

	/**
	 * Inserts a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion addFormacion(Formacion formacion);

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion update(Formacion formacion);

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion updateFormacion(Formacion formacion);

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion updateVisibleWeb(Formacion formacion);

	/**
	 * Finds a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion find(Formacion formacion);

	/**
	 * Finds a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion findFormacion(Formacion formacion);

	/**
	 * Finds a List of rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Formacion> findAll(Formacion formacion, Pagination pagination);

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Long
	 */
	Long findAllCount(Formacion formacion);

	/**
	 * Finds rows in the Formacion table using like.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Formacion> findAllLike(Formacion formacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Formacion table using like.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FormacionBusqueda> findAllLikeFormacion(
			FormacionBusqueda formacionBusqueda, Vector<String> perfiles,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param perfiles
	 *            Vector<String>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeFormacionCount(FormacionBusqueda formacionBusqueda,
			Vector<String> perfiles, Boolean startsWith);

	/**
	 * Deletes a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	void remove(Formacion formacion);

	/**
	 * Deletes a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	void removeFormacion(Formacion formacion);

	/**
	 * Deletes multiple rows in the Formacion table.
	 * 
	 * @param formacionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Formacion> formacionList);

	/**
	 * Inserts a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion addFormacionEtiqueta(Formacion formacion);

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 */
	void removeFormacionEtiqueta(Formacion formacion);

	/**
	 * Find a single row in the findFormacionEtiqueta Many To Many relationship.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Formacion
	 */
	Formacion findFormacionEtiqueta(Formacion formacion, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param etiqueta
	 *            Etiqueta
	 * @return List
	 */
	Long findFormacionEtiquetaCount(Formacion formacion, Etiqueta etiqueta);

}
