package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.EtiquetaDao;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Solicitud;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.utils.Y40aUIDGenerator;

/**
 * * EtiquetaServiceImpl  
 * 
 *  
 */

@Service(value = "etiquetaService")
public class EtiquetaServiceImpl implements EtiquetaService {

	private static final Logger logger = LoggerFactory
			.getLogger(EtiquetaServiceImpl.class);
	@Autowired
	private EtiquetaDao etiquetaDao;

	/**
	 * Inserts a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta add(Etiqueta etiqueta) {
		etiqueta.setIdEtiqueta(Y40aUIDGenerator.getInstance().generateId(
				Y40aConstantes.PK_SIZE));
		return this.etiquetaDao.add(etiqueta);
	}

	/**
	 * Updates a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta update(Etiqueta etiqueta) {
		return this.etiquetaDao.update(etiqueta);
	}

	/**
	 * Finds a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	public Etiqueta find(Etiqueta etiqueta) {
		return (Etiqueta) this.etiquetaDao.find(etiqueta);
	}

	/**
	 * Finds a List of rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination) {
		return (List<Etiqueta>) this.etiquetaDao.findAll(etiqueta, pagination);
	}

	/**
	 * Counts rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	public Long findAllCount(Etiqueta etiqueta) {
		return this.etiquetaDao.findAllCount(etiqueta);
	}

	/**
	 * Finds rows in the Etiqueta table using like.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination,
			Boolean startsWith) {
		return (List<Etiqueta>) this.etiquetaDao.findAllLike(etiqueta,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Etiqueta etiqueta) {
		this.etiquetaDao.remove(etiqueta);
	}

	/**
	 * Deletes multiple rows in the Etiqueta table.
	 * 
	 * @param etiquetaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Etiqueta> etiquetaList) {
		for (Etiqueta etiquetaAux : etiquetaList) {
			this.etiquetaDao.remove(etiquetaAux);
		}
	}

	/**
	 * Inserts a single row in the FormacionEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta addFormacionEtiqueta(Etiqueta etiqueta) {
		return this.etiquetaDao.addFormacionEtiqueta(etiqueta);
	}

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeFormacionEtiqueta(Etiqueta etiqueta) {
		this.etiquetaDao.removeFormacionEtiqueta(etiqueta);
	}

	/**
	 * Find a single row in the findFormacionEtiqueta Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta findFormacionEtiqueta(Etiqueta etiqueta,
			Formacion formacion, Pagination pagination) {
		return this.etiquetaDao.findFormacionEtiqueta(etiqueta, formacion,
				pagination);
	}

	/**
	 * Counts rows in the FormacionEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param formacion
	 *            Formacion
	 * @return List
	 */
	public Long findFormacionEtiquetaCount(Etiqueta etiqueta,
			Formacion formacion) {
		return this.etiquetaDao.findFormacionEtiquetaCount(etiqueta, formacion);
	}

	/**
	 * Inserts a single row in the SolicitudEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta addSolicitudEtiqueta(Etiqueta etiqueta) {
		return this.etiquetaDao.addSolicitudEtiqueta(etiqueta);
	}

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeSolicitudEtiqueta(Etiqueta etiqueta) {
		this.etiquetaDao.removeSolicitudEtiqueta(etiqueta);
	}

	/**
	 * Find a single row in the findSolicitudEtiqueta Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta findSolicitudEtiqueta(Etiqueta etiqueta,
			Solicitud solicitud, Pagination pagination) {
		return this.etiquetaDao.findSolicitudEtiqueta(etiqueta, solicitud,
				pagination);
	}

	/**
	 * Counts rows in the SolicitudEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param solicitud
	 *            Solicitud
	 * @return List
	 */
	public Long findSolicitudEtiquetaCount(Etiqueta etiqueta,
			Solicitud solicitud) {
		return this.etiquetaDao.findSolicitudEtiquetaCount(etiqueta, solicitud);
	}

	/**
	 * Getter method for EtiquetaDao
	 * 
	 * @return EtiquetaDao
	 */
	public EtiquetaDao getEtiquetaDao() {
		return this.etiquetaDao;
	}

	/**
	 * Setter method for EtiquetaDao.
	 * 
	 * @param etiquetaDao
	 *            EtiquetaDao
	 * @return
	 */
	public void setEtiquetaDao(EtiquetaDao etiquetaDao) {
		logger.info("Setting Dependency " + etiquetaDao);
		this.etiquetaDao = etiquetaDao;
	}
}
