package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.EntidadDao;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.config.Y40aConfig;
import com.ejie.y40a.utils.exception.Y40aUDAException;

/**
 * * EntidadServiceImpl  
 * 
 *  
 */

@Service(value = "entidadService")
public class EntidadServiceImpl implements EntidadService {

	private static final Logger logger = LoggerFactory
			.getLogger(EntidadServiceImpl.class);
	@Autowired
	private EntidadDao entidadDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Entidad add(Entidad entidad) {
		return this.entidadDao.add(entidad);
	}

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Entidad update(Entidad entidad) {
		return this.entidadDao.update(entidad);
	}

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	public Entidad find(Entidad entidad) {
		return (Entidad) this.entidadDao.find(entidad);
	}

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Entidad> findAll(Entidad entidad, Pagination pagination) {
		return (List<Entidad>) this.entidadDao.findAll(entidad, pagination);
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	public Long findAllCount(Entidad entidad) {
		return this.entidadDao.findAllCount(entidad);
	}

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith) {
		return (List<Entidad>) this.entidadDao.findAllLike(entidad, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Entidad entidad, Boolean startsWith) {
		return this.entidadDao.findAllLikeCount(entidad, startsWith);
	}

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Entidad> findAllLikeTabla(Entidad entidad,
			Pagination pagination, Boolean startsWith) {
		return (List<Entidad>) this.entidadDao.findAllLikeTabla(entidad,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeTablaCount(Entidad entidad, Boolean startsWith) {
		return this.entidadDao.findAllLikeTablaCount(entidad, startsWith);
	}

	/**
	 * Deletes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Entidad entidad) {
		this.entidadDao.remove(entidad);
	}

	/**
	 * Deletes multiple rows in the Entidad table.
	 * 
	 * @param entidadList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Entidad> entidadList) {
		for (Entidad entidadAux : entidadList) {
			this.entidadDao.remove(entidadAux);
		}
	}

	/**
	 * Getter method for EntidadDao
	 * 
	 * @return EntidadDao
	 */
	public EntidadDao getEntidadDao() {
		return this.entidadDao;
	}

	/**
	 * Setter method for EntidadDao.
	 * 
	 * @param entidadDao
	 *            EntidadDao
	 * @return
	 */
	public void setEntidadDao(EntidadDao entidadDao) {
		logger.info("Setting Dependency " + entidadDao);
		this.entidadDao = entidadDao;
	}

	/**
	 * Responde por email a una consulta.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param respuesta
	 *            Respuesta
	 * @return Consulta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean envioEmail(Entidad entidad) {

		String destinatariosMail = entidad.getEmail();

		Properties prop = Y40aConfig.loadProperties(Y40aConstantes.CONFIG_PATH);

		String from = (String) prop
				.getProperty("y40aVistaWar.mail.kontsumobide");

		String smtpMail = (String) prop
				.getProperty("y40aVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();
		asunto.append(appMessageSource.getMessage("mail.asunto", null,
				new Locale(Y40aConstantes.CASTELLANO)));
		asunto.append(" / ");
		asunto.append(appMessageSource.getMessage("mail.asunto", null,
				new Locale(Y40aConstantes.EUSKERA)));

		StringBuffer texto = new StringBuffer();

		// parte ES
		texto.append(appMessageSource.getMessage("mail.texto", null,
				new Locale(Y40aConstantes.CASTELLANO)));
		texto.append("<BR><BR>");
		texto.append(
				appMessageSource.getMessage("mail.texto.paraRestablecer", null,
						new Locale(Y40aConstantes.CASTELLANO))).append(" : ");
		// separacion
		texto.append("<BR><BR>");
		// enlace CAMBIAR PASSWORD
		/*
		 * String url = referrer .replace("maintRecuperacionPassword",
		 * "maintCambioPassword") .concat("/").concat(entidad.getUsuario());
		 */
		String url = "";

		url = (String) prop.getProperty("URL_REGENERAR_PASSWORD");
		url = url.concat("es/y39aVistaWar/login/maintCambioPassword/");

		try {
			url = url.concat(entidad.getUsuario());
		} catch (Exception e) {
			throw new Y40aUDAException("error.envioemail", true,
					new Exception());
		}

		texto.append("<a href=\"");
		url = url.concat("?locale=es");
		texto.append(url);
		texto.append("\">");
		texto.append(appMessageSource.getMessage("mail.texto.cambiarPass",
				null, new Locale(Y40aConstantes.CASTELLANO)));
		texto.append("</a>");

		// separacion
		texto.append("<BR><BR>");

		// parte EU
		texto.append(appMessageSource.getMessage("mail.texto", null,
				new Locale(Y40aConstantes.EUSKERA)));
		texto.append("<BR><BR>");
		texto.append(
				appMessageSource.getMessage("mail.texto.paraRestablecer", null,
						new Locale(Y40aConstantes.EUSKERA))).append(" : ");
		// separacion
		texto.append("<BR><BR>");
		// enlace PASAHITZA ALDATU

		texto.append("<a href=\"");
		url = url.replace("?locale=es", "?locale=eu");
		url = url.replace("/es/", "/eu/");
		texto.append(url);
		texto.append("\">");
		texto.append(appMessageSource.getMessage("mail.texto.cambiarPass",
				null, new Locale(Y40aConstantes.EUSKERA)));
		texto.append("</a>");
		texto.append("<BR><BR>");

		// Envio mail
		boolean envio = Y40aUtils.sendMail(smtpMail, asunto.toString(),
				texto.toString(), from, destinatariosMail, new ArrayList());

		if (!(envio)) {
			throw new Y40aUDAException("error.envioemail", true,
					new Exception());
		}

		return envio;
	}

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	public Entidad findEntidadUser(Entidad entidad) {
		return (Entidad) this.entidadDao.findEntidadUser(entidad);
	}

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Entidad updatePassword(Entidad entidad) {

		Entidad entidadAux = this.entidadDao.find(entidad);
		entidadAux.setPassword(entidad.getPassword());

		return this.entidadDao.updatePassword(entidadAux);
	}

}
