package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y40a.model.Entidad;

/**
 * * EntidadService  
 * 
 *  
 */

public interface EntidadService {

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad add(Entidad entidad);

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad update(Entidad entidad);

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad find(Entidad entidad);

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Entidad> findAll(Entidad entidad, Pagination pagination);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findAllCount(Entidad entidad);

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Entidad entidad, Boolean startsWith);

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Entidad> findAllLikeTabla(Entidad entidad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeTablaCount(Entidad entidad, Boolean startsWith);

	/**
	 * Deletes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void remove(Entidad entidad);

	/**
	 * Deletes multiple rows in the Entidad table.
	 * 
	 * @param entidadList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Entidad> entidadList);

	/**
	 * Sends an email with user/password info
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */

	boolean envioEmail(Entidad entidad);

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad findEntidadUser(Entidad entidad);

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad updatePassword(Entidad entidad);

}
