package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.EntidadHistoricoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.EntidadHistorico;

/**
 *  * EntidadHistoricoServiceImpl  
 *  
 */

@Service(value = "entidadHistoricoService")
public  class EntidadHistoricoServiceImpl implements EntidadHistoricoService {

	private static final  Logger logger = LoggerFactory.getLogger(EntidadHistoricoServiceImpl.class);
	@Autowired
	private EntidadHistoricoDao entidadHistoricoDao;

	/**
	 * Inserts a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return EntidadHistorico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EntidadHistorico add(EntidadHistorico entidadHistorico) {
		return this.entidadHistoricoDao.add(entidadHistorico);
	}

	/**
	 * Updates a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return EntidadHistorico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EntidadHistorico update(EntidadHistorico entidadHistorico) {
		return this.entidadHistoricoDao.update(entidadHistorico);
	 }

	/**
	 * Finds a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return EntidadHistorico
	 */
	public EntidadHistorico find(EntidadHistorico entidadHistorico) {
		return (EntidadHistorico) this.entidadHistoricoDao.find(entidadHistorico);
	}

	/**
	 * Finds a List of rows in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @param pagination Pagination
	 * @return List
	 */
	public List<EntidadHistorico> findAll(EntidadHistorico entidadHistorico, Pagination pagination) {
		return (List<EntidadHistorico>) this.entidadHistoricoDao.findAll(entidadHistorico, pagination);
	}
    
	/**
	 * Counts rows in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return Long
	 */
	public Long findAllCount(EntidadHistorico entidadHistorico) {        
		return  this.entidadHistoricoDao.findAllCount(entidadHistorico);
	}

	/**
	 * Finds rows in the EntidadHistorico table using like.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<EntidadHistorico> findAllLike(EntidadHistorico entidadHistorico, Pagination pagination, Boolean startsWith) {
		return (List<EntidadHistorico>) this.entidadHistoricoDao.findAllLike(entidadHistorico, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EntidadHistorico entidadHistorico) {
		this.entidadHistoricoDao.remove(entidadHistorico);
	}
	
	/**
	 * Deletes multiple rows in the EntidadHistorico table.
	 *
	 * @param entidadHistoricoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<EntidadHistorico> entidadHistoricoList) {
		for (EntidadHistorico  entidadHistoricoAux:entidadHistoricoList) {
			this.entidadHistoricoDao.remove(entidadHistoricoAux);
		}
	}


	/**
	 * Getter method for EntidadHistoricoDao
	 *
	 * @return EntidadHistoricoDao
	 */
	public EntidadHistoricoDao getEntidadHistoricoDao() {
		return this.entidadHistoricoDao;
	}
    
	/**
	 * Setter method for EntidadHistoricoDao.
	 *
	 * @param  entidadHistoricoDao EntidadHistoricoDao
	 * @return
	 */
	public void setEntidadHistoricoDao(EntidadHistoricoDao entidadHistoricoDao) {
		logger.info("Setting Dependency "+entidadHistoricoDao);
		this.entidadHistoricoDao = entidadHistoricoDao;
	}
}

