package com.ejie.y40a.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y40a.model.EntidadHistorico;

/**
 *  * EntidadHistoricoService  
 *  
 */

public interface EntidadHistoricoService {

	/**
	 * Inserts a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return EntidadHistorico
	 */
    EntidadHistorico add(EntidadHistorico entidadHistorico);

	/**
	 * Updates a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return EntidadHistorico
	 */
	EntidadHistorico update(EntidadHistorico entidadHistorico);

	/**
	 * Finds a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return EntidadHistorico
	 */
	EntidadHistorico find(EntidadHistorico entidadHistorico);

	/**
	 * Finds a List of rows in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @param pagination Pagination
	 * @return List
	 */
	List<EntidadHistorico> findAll(EntidadHistorico entidadHistorico, Pagination pagination);

	/**
	 * Counts rows in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return Long
	 */
	Long findAllCount(EntidadHistorico entidadHistorico);
	
	/**
	 * Finds rows in the EntidadHistorico table using like.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<EntidadHistorico> findAllLike(EntidadHistorico entidadHistorico, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the EntidadHistorico table.
	 *
	 * @param entidadHistorico EntidadHistorico
	 * @return 
	 */
	void remove(EntidadHistorico entidadHistorico);
	
	/**
	 * Deletes multiple rows in the EntidadHistorico table.
	 *
	 * @param entidadHistoricoList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<EntidadHistorico> entidadHistoricoList);
    
}


