package com.ejie.y40a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.EntidadContactoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.EntidadContacto;

/**
 *  * EntidadContactoServiceImpl  
 *  
 */

@Service(value = "entidadContactoService")
public  class EntidadContactoServiceImpl implements EntidadContactoService {

	private static final  Logger logger = LoggerFactory.getLogger(EntidadContactoServiceImpl.class);
	@Autowired
	private EntidadContactoDao entidadContactoDao;

	/**
	 * Inserts a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return EntidadContacto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EntidadContacto add(EntidadContacto entidadContacto) {
		return this.entidadContactoDao.add(entidadContacto);
	}

	/**
	 * Updates a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return EntidadContacto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EntidadContacto update(EntidadContacto entidadContacto) {
		return this.entidadContactoDao.update(entidadContacto);
	 }

	/**
	 * Finds a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return EntidadContacto
	 */
	public EntidadContacto find(EntidadContacto entidadContacto) {
		return (EntidadContacto) this.entidadContactoDao.find(entidadContacto);
	}

	/**
	 * Finds a List of rows in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @param pagination Pagination
	 * @return List
	 */
	public List<EntidadContacto> findAll(EntidadContacto entidadContacto, Pagination pagination) {
		return (List<EntidadContacto>) this.entidadContactoDao.findAll(entidadContacto, pagination);
	}
    
	/**
	 * Counts rows in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return Long
	 */
	public Long findAllCount(EntidadContacto entidadContacto) {        
		return  this.entidadContactoDao.findAllCount(entidadContacto);
	}

	/**
	 * Finds rows in the EntidadContacto table using like.
	 *
	 * @param entidadContacto EntidadContacto
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<EntidadContacto> findAllLike(EntidadContacto entidadContacto, Pagination pagination, Boolean startsWith) {
		return (List<EntidadContacto>) this.entidadContactoDao.findAllLike(entidadContacto, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EntidadContacto entidadContacto) {
		this.entidadContactoDao.remove(entidadContacto);
	}
	
	/**
	 * Deletes multiple rows in the EntidadContacto table.
	 *
	 * @param entidadContactoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<EntidadContacto> entidadContactoList) {
		for (EntidadContacto  entidadContactoAux:entidadContactoList) {
			this.entidadContactoDao.remove(entidadContactoAux);
		}
	}


	/**
	 * Getter method for EntidadContactoDao
	 *
	 * @return EntidadContactoDao
	 */
	public EntidadContactoDao getEntidadContactoDao() {
		return this.entidadContactoDao;
	}
    
	/**
	 * Setter method for EntidadContactoDao.
	 *
	 * @param  entidadContactoDao EntidadContactoDao
	 * @return
	 */
	public void setEntidadContactoDao(EntidadContactoDao entidadContactoDao) {
		logger.info("Setting Dependency "+entidadContactoDao);
		this.entidadContactoDao = entidadContactoDao;
	}
}

