package com.ejie.y40a.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y40a.model.EntidadContacto;

/**
 *  * EntidadContactoService  
 *  
 */

public interface EntidadContactoService {

	/**
	 * Inserts a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return EntidadContacto
	 */
    EntidadContacto add(EntidadContacto entidadContacto);

	/**
	 * Updates a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return EntidadContacto
	 */
	EntidadContacto update(EntidadContacto entidadContacto);

	/**
	 * Finds a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return EntidadContacto
	 */
	EntidadContacto find(EntidadContacto entidadContacto);

	/**
	 * Finds a List of rows in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @param pagination Pagination
	 * @return List
	 */
	List<EntidadContacto> findAll(EntidadContacto entidadContacto, Pagination pagination);

	/**
	 * Counts rows in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return Long
	 */
	Long findAllCount(EntidadContacto entidadContacto);
	
	/**
	 * Finds rows in the EntidadContacto table using like.
	 *
	 * @param entidadContacto EntidadContacto
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<EntidadContacto> findAllLike(EntidadContacto entidadContacto, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the EntidadContacto table.
	 *
	 * @param entidadContacto EntidadContacto
	 * @return 
	 */
	void remove(EntidadContacto entidadContacto);
	
	/**
	 * Deletes multiple rows in the EntidadContacto table.
	 *
	 * @param entidadContactoList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<EntidadContacto> entidadContactoList);
    
}


