package com.ejie.y40a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.dao.ContactoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Contacto;
import com.ejie.y40a.model.Entidad;

/**
 * * ContactoServiceImpl  
 * 
 *  
 */

@Service(value = "contactoService")
public class ContactoServiceImpl implements ContactoService {

	private static final Logger logger = LoggerFactory
			.getLogger(ContactoServiceImpl.class);
	@Autowired
	private ContactoDao contactoDao;

	/**
	 * Inserts a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Contacto add(Contacto contacto) {
		return this.contactoDao.add(contacto);
	}

	/**
	 * Updates a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Contacto update(Contacto contacto) {
		return this.contactoDao.update(contacto);
	}

	/**
	 * Finds a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	public Contacto find(Contacto contacto) {
		return (Contacto) this.contactoDao.find(contacto);
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Contacto> findAll(Contacto contacto, Pagination pagination) {
		return (List<Contacto>) this.contactoDao.findAll(contacto, pagination);
	}

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	public Long findAllCount(Contacto contacto) {
		return this.contactoDao.findAllCount(contacto);
	}

	/**
	 * Finds rows in the Contacto table using like.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Contacto> findAllLike(Contacto contacto, Pagination pagination,
			Boolean startsWith) {
		return (List<Contacto>) this.contactoDao.findAllLike(contacto,
				pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Contacto> findAllContactoEntidad(Entidad entidad,
			Pagination pagination) {
		return (List<Contacto>) this.contactoDao.findAllContactoEntidad(
				entidad, pagination);
	}

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	public Long findAllContactoEntidadCount(Entidad entidad) {
		return this.contactoDao.findAllContactoEntidadCount(entidad);
	}

	/**
	 * Deletes a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Contacto contacto) {
		this.contactoDao.remove(contacto);
	}

	/**
	 * Deletes multiple rows in the Contacto table.
	 * 
	 * @param contactoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Contacto> contactoList) {
		for (Contacto contactoAux : contactoList) {
			this.contactoDao.remove(contactoAux);
		}
	}

	/**
	 * Getter method for ContactoDao
	 * 
	 * @return ContactoDao
	 */
	public ContactoDao getContactoDao() {
		return this.contactoDao;
	}

	/**
	 * Setter method for ContactoDao.
	 * 
	 * @param contactoDao
	 *            ContactoDao
	 * @return
	 */
	public void setContactoDao(ContactoDao contactoDao) {
		logger.info("Setting Dependency " + contactoDao);
		this.contactoDao = contactoDao;
	}
}
