package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.CategoriaDao;
import com.ejie.y40a.dao.FormacionDao;
import com.ejie.y40a.dao.PerfilDao;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.CategoriaPerfil;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Perfil;
import com.ejie.y40a.model.Y40aCategoriaTree;
import com.ejie.y40a.utils.Y40aUIDGenerator;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.exception.Y40aUDAException;

/**
 * * CategoriaServiceImpl  
 * 
 *  
 */

@Service(value = "categoriaService")
public class CategoriaServiceImpl implements CategoriaService {

	private static final Logger logger = LoggerFactory
			.getLogger(CategoriaServiceImpl.class);
	@Autowired
	private CategoriaDao categoriaDao;
	@Autowired
	private PerfilDao perfilDao;
	@Autowired
	private FormacionDao formacionDao;

	/**
	 * Inserts a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria add(Categoria categoria) {
		return this.categoriaDao.add(categoria);
	}

	/**
	 * Inserts a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria addCategoria(Categoria categoria) {

		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {

			Categoria categoriaAux = new Categoria();
			categoriaAux.setIdCat(categoria.getCategoria().getIdCat());

			categoriaAux = this.categoriaDao.find(categoriaAux);

			if (categoriaAux.getNumAsistentes() != null
					&& categoriaAux.getNumAsistentes() > 0) {
				if (categoria.getNumAsistentes() == null
						|| categoria.getNumAsistentes() == 0) {
					throw new Y40aUDAException(
							"error.categoria.numAsistentesLimitadoException",
							true, new Exception());

				} else if (categoria.getNumAsistentes() > categoriaAux
						.getNumAsistentes()) {
					throw new Y40aUDAException(
							"error.categoria.numAsistentesException", true,
							new Exception());
				}
			} else if (categoriaAux.getNumAsistentes() != null
					&& categoriaAux.getNumAsistentes() == 0) {
				if (categoria.getNumAsistentes() == null
						|| categoria.getNumAsistentes() > 0) {
					throw new Y40aUDAException(
							"error.categoria.numAsistentesLimitadoException",
							true, new Exception());

				}
			}

			if (categoriaAux.getNumFormaciones() != null
					&& categoriaAux.getNumFormaciones() > 0) {
				if (categoria.getNumFormaciones() == null
						|| categoria.getNumFormaciones() == 0) {
					throw new Y40aUDAException(
							"error.categoria.numFormacionesLimitadoException",
							true, new Exception());

				} else if (categoria.getNumFormaciones() > categoriaAux
						.getNumFormaciones()) {
					throw new Y40aUDAException(
							"error.categoria.numFormacionesException", true,
							new Exception());
				}
			} else if (categoriaAux.getNumFormaciones() != null
					&& categoriaAux.getNumFormaciones() == 0) {
				if (categoria.getNumFormaciones() == null
						|| categoria.getNumFormaciones() > 0) {
					throw new Y40aUDAException(
							"error.categoria.numFormacionesLimitadoException",
							true, new Exception());

				}
			}

			if (categoria.getFechaIniSol() != null) {
				if (categoriaAux.getFechaFinSol() != null) {
					if (categoria.getFechaIniSol().after(
							categoriaAux.getFechaFinSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
				if (categoriaAux.getFechaIniSol() != null) {
					if (categoria.getFechaIniSol().before(
							categoriaAux.getFechaIniSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
			}

			if (categoria.getFechaFinSol() != null) {
				if (categoriaAux.getFechaFinSol() != null) {
					if (categoria.getFechaFinSol().after(
							categoriaAux.getFechaFinSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
				if (categoriaAux.getFechaIniSol() != null) {
					if (categoria.getFechaFinSol().before(
							categoriaAux.getFechaIniSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
			}
		}

		// Comprobar que el nombre de la categoria en castellano sea unico
		Categoria categoriaAux = new Categoria();
		categoriaAux.setNombreEs(categoria.getNombreEs());

		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			Categoria categoriaPadre = new Categoria();
			categoriaPadre.setIdCat(categoria.getCategoria().getIdCat());
			categoriaAux.setCategoria(categoriaPadre);
		}

		Long numCategorias = this.categoriaDao
				.findAllNameCategoriaCount(categoriaAux);

		if (numCategorias > 0) {
			throw new Y40aUDAException("error.categoria.nombreesrepetido",
					true, new Exception());
		}

		// Comprobar que el nombre de la categoria en euskera sea unico
		categoriaAux = new Categoria();
		categoriaAux.setNombreEu(categoria.getNombreEu());
		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			Categoria categoriaPadre = new Categoria();
			categoriaPadre.setIdCat(categoria.getCategoria().getIdCat());
			categoriaAux.setCategoria(categoriaPadre);
		}

		numCategorias = this.categoriaDao
				.findAllNameCategoriaCount(categoriaAux);

		if (numCategorias > 0) {
			throw new Y40aUDAException("error.categoria.nombreeurepetido",
					true, new Exception());
		}

		categoria.setIdCat(Y40aConstantes.PREFIJO_CATEGORIA
				+ Y40aUIDGenerator.getInstance().generateId(
						Y40aConstantes.PK_SIZE - 2));
		this.categoriaDao.add(categoria);

		// Grupos
		this.categoriaDao.addCategoriaGrupos(categoria);

		// Perfiles
		this.categoriaDao.addCategoriaPerfil(categoria);

		return categoria;
	}

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria update(Categoria categoria) {
		return this.categoriaDao.update(categoria);
	}

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria updateCategoria(Categoria categoria) {
		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {

			Categoria categoriaAux = new Categoria();
			categoriaAux.setIdCat(categoria.getCategoria().getIdCat());

			categoriaAux = this.categoriaDao.find(categoriaAux);

			if (categoriaAux.getNumAsistentes() != null
					&& categoriaAux.getNumAsistentes() > 0) {
				if (categoria.getNumAsistentes() == null
						|| categoria.getNumAsistentes() == 0) {
					throw new Y40aUDAException(
							"error.categoria.numAsistentesLimitadoException",
							true, new Exception());

				} else if (categoria.getNumAsistentes() > categoriaAux
						.getNumAsistentes()) {
					throw new Y40aUDAException(
							"error.categoria.numAsistentesException", true,
							new Exception());
				}
			} else if (categoriaAux.getNumAsistentes() != null
					&& categoriaAux.getNumAsistentes() == 0) {
				if (categoria.getNumAsistentes() == null
						|| categoria.getNumAsistentes() > 0) {
					throw new Y40aUDAException(
							"error.categoria.numAsistentesLimitadoException",
							true, new Exception());

				}
			}

			if (categoriaAux.getNumFormaciones() != null
					&& categoriaAux.getNumFormaciones() > 0) {
				if (categoria.getNumFormaciones() == null
						|| categoria.getNumFormaciones() == 0) {
					throw new Y40aUDAException(
							"error.categoria.numFormacionesLimitadoException",
							true, new Exception());

				} else if (categoria.getNumFormaciones() > categoriaAux
						.getNumFormaciones()) {
					throw new Y40aUDAException(
							"error.categoria.numFormacionesException", true,
							new Exception());
				}
			} else if (categoriaAux.getNumFormaciones() != null
					&& categoriaAux.getNumFormaciones() == 0) {
				if (categoria.getNumFormaciones() == null
						|| categoria.getNumFormaciones() > 0) {
					throw new Y40aUDAException(
							"error.categoria.numFormacionesLimitadoException",
							true, new Exception());

				}
			}

			if (categoria.getFechaIniSol() != null) {
				if (categoriaAux.getFechaFinSol() != null) {
					if (categoria.getFechaIniSol().after(
							categoriaAux.getFechaFinSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
				if (categoriaAux.getFechaIniSol() != null) {
					if (categoria.getFechaIniSol().before(
							categoriaAux.getFechaIniSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
			}

			if (categoria.getFechaFinSol() != null) {
				if (categoriaAux.getFechaFinSol() != null) {
					if (categoria.getFechaFinSol().after(
							categoriaAux.getFechaFinSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
				if (categoriaAux.getFechaIniSol() != null) {
					if (categoria.getFechaFinSol().before(
							categoriaAux.getFechaIniSol())) {
						throw new Y40aUDAException(
								"error.categoria.rangofechassolicitud", true,
								new Exception());
					}
				}
			}
		}

		// comprobar si tiene categorias hijas
		Categoria categoriaAux = new Categoria();
		Categoria categoriaPadre = new Categoria();
		categoriaPadre.setIdCat(categoria.getIdCat());
		categoriaAux.setCategoria(categoriaPadre);

		Long numCategorias = this.categoriaDao.findAllCount(categoriaAux);

		// Tiene hijos, modificamos solo el nombre
		if (numCategorias > 0) {
			this.categoriaDao.updateNombre(categoria);
			// Tiene hijos, modificamos solo el nombre
		} else {

			this.categoriaDao.update(categoria);

			// Grupos
			this.categoriaDao.removeAllCategoriaGrupos(categoria);
			this.categoriaDao.addCategoriaGrupos(categoria);

			if (categoria != null && categoria.getPerfils() != null
					&& categoria.getPerfils().size() > 0) {
				// Perfiles
				this.categoriaDao.removeAllCategoriaPerfil(categoria);
				this.categoriaDao.addCategoriaPerfil(categoria);
			}
		}

		// Comprobar que el nombre de la categoria en castellano sea unico
		categoriaAux = new Categoria();
		categoriaAux.setIdCat(categoria.getIdCat());
		categoriaAux.setNombreEs(categoria.getNombreEs());

		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			categoriaPadre = new Categoria();
			categoriaPadre.setIdCat(categoria.getCategoria().getIdCat());
			categoriaAux.setCategoria(categoriaPadre);
		}

		numCategorias = this.categoriaDao
				.findAllNameCategoriaCount(categoriaAux);

		if (numCategorias > 1) {
			throw new Y40aUDAException("error.categoria.nombreesrepetido",
					true, new Exception());
		}

		// Comprobar que el nombre de la categoria en euskera sea unico
		categoriaAux = new Categoria();
		categoriaAux.setIdCat(categoria.getIdCat());
		categoriaAux.setNombreEu(categoria.getNombreEu());
		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			categoriaPadre = new Categoria();
			categoriaPadre.setIdCat(categoria.getCategoria().getIdCat());
			categoriaAux.setCategoria(categoriaPadre);
		}

		numCategorias = this.categoriaDao
				.findAllNameCategoriaCount(categoriaAux);

		if (numCategorias > 1) {
			throw new Y40aUDAException("error.categoria.nombreeurepetido",
					true, new Exception());
		}

		return categoria;
	}

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria updateVisibleWeb(Categoria categoria) {
		return this.categoriaDao.updateVisibleWeb(categoria);
	}

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	public Categoria find(Categoria categoria) {
		return (Categoria) this.categoriaDao.find(categoria);
	}

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	public Categoria findCategoria(Categoria categoriaReci) {

		Categoria categoria = new Categoria();
		categoria = this.categoriaDao.find(categoriaReci);

		if (Y40aUtils.isFilled(categoria.getCategoria().getIdCat())) {
			Categoria categoriaAux = new Categoria();
			categoriaAux.setIdCat(categoria.getIdCat());

			String jerarquiaCategoria = obtenerJerarquiaCategoria(categoriaAux);
			categoria.getCategoria().setJerarquiaCategoria(jerarquiaCategoria);

			StringBuffer jerarquia = new StringBuffer();
			Locale locale = LocaleContextHolder.getLocale();
			if (Y40aUtils.isFilled(jerarquiaCategoria)) {
				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					jerarquia.append(jerarquiaCategoria).append(">")
							.append(categoria.getNombreEs());
				} else {
					jerarquia.append(jerarquiaCategoria).append(">")
							.append(categoria.getNombreEu());
				}
			} else {
				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					jerarquia.append(categoria.getNombreEs());
				} else {
					jerarquia.append(categoria.getNombreEu());
				}
			}

			categoria.setJerarquiaCategoria(jerarquia.toString());
		}

		return categoria;
	}

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	public Categoria findCategoriaPadre(Categoria categoria) {
		categoria = this.categoriaDao.find(categoria);

		if (Y40aUtils.isFilled(categoria.getIdCat())) {
			Categoria categoriaAux = new Categoria();
			categoriaAux.setIdCat(categoria.getIdCat());

			String jerarquiaCategoria = obtenerJerarquiaCategoria(categoriaAux);
			StringBuffer jerarquia = new StringBuffer();
			Locale locale = LocaleContextHolder.getLocale();
			if (Y40aUtils.isFilled(jerarquiaCategoria)) {
				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					jerarquia.append(jerarquiaCategoria).append(">")
							.append(categoria.getNombreEs());
				} else {
					jerarquia.append(jerarquiaCategoria).append(">")
							.append(categoria.getNombreEu());
				}
			} else {
				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					jerarquia.append(categoria.getNombreEs());
				} else {
					jerarquia.append(categoria.getNombreEu());
				}
			}

			categoria.setJerarquiaCategoria(jerarquia.toString());
		}

		return categoria;
	}

	/**
	 * Recupera la jerarquia de una Categoria.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return String
	 */
	private String obtenerJerarquiaCategoria(Categoria categoria) {
		StringBuffer jerarquiaCategoria = new StringBuffer();

		Locale locale = LocaleContextHolder.getLocale();

		boolean firstElement = true;
		boolean tienePadre = true;

		while (tienePadre) {

			Categoria categoriaAux = this.categoriaDao
					.findCategoriaPadre(categoria);

			if (Y40aUtils.isFilled(categoriaAux.getIdCat())) {
				if (firstElement) {
					if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
						jerarquiaCategoria.append(categoriaAux.getNombreEs());
					} else {
						jerarquiaCategoria.append(categoriaAux.getNombreEu());
					}

					firstElement = false;
				} else {
					String jerarquia = jerarquiaCategoria.toString();
					jerarquiaCategoria = new StringBuffer();

					if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
						jerarquiaCategoria.append(categoriaAux.getNombreEs())
								.append(">").append(jerarquia);
					} else {
						jerarquiaCategoria.append(categoriaAux.getNombreEu())
								.append(">").append(jerarquia);
					}
				}
				categoria.setIdCat(categoriaAux.getIdCat());
			} else {
				tienePadre = false;
			}
		}

		return jerarquiaCategoria.toString();
	}

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Categoria> findAll(Categoria categoria, Pagination pagination) {
		return (List<Categoria>) this.categoriaDao.findAll(categoria,
				pagination);
	}

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 * @return List
	 */
	public List<Categoria> findAllCategoriaSeguridad(Categoria categoria,
			Vector<String> perfiles, List<Grupo> grupos) {

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		return (List<Categoria>) this.categoriaDao.findAllCategoriaSeguridad(
				categoria, perfiles, grupos, pagination);
	}

	/**
	 * Counts rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	public Long findAllCount(Categoria categoria) {
		return this.categoriaDao.findAllCount(categoria);
	}

	/**
	 * Finds rows in the Categoria table using like.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Categoria> findAllLike(Categoria categoria,
			Pagination pagination, Boolean startsWith) {
		return (List<Categoria>) this.categoriaDao.findAllLike(categoria,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Categoria categoria) {
		try {
			this.categoriaDao.remove(categoria);
		} catch (DataIntegrityViolationException e) {
			throw new Y40aUDAException(
					"error.categoria.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCategoria(Categoria categoria) {
		try {

			Y40aCategoriaTree y40aCategoriaTreeFiltro = new Y40aCategoriaTree();
			y40aCategoriaTreeFiltro.setIdCat(categoria.getIdCat());
			this.removeCategoriaTree(y40aCategoriaTreeFiltro);

		} catch (DataIntegrityViolationException e) {
			throw new Y40aUDAException(
					"error.categoria.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Cuenta el numero total de categorías/campañas junto con todas sus
	 * formaciones que no tengan solicitudes
	 * 
	 * @param categoriaTree
	 *            Y40aCategoriaTree
	 * @return HashMap con el numero de categorias y formaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HashMap<String, Object> contarCategoriaFormaciones(
			Categoria categoria) {

		HashMap<String, Object> resultado = new HashMap<String, Object>();

		// try {
		List<Categoria> arrCategorias = new ArrayList<Categoria>();
		this.contarCategorias(categoria, arrCategorias);

		List<Formacion> arrForma = new ArrayList<Formacion>();
		this.contarFormacionesCategorias(arrCategorias, arrForma);

		resultado.put("numCategorias", new Integer(arrCategorias.size()));
		resultado.put("numFormaciones", new Integer(arrForma.size()));
		// } catch (Exception e) {
		// throw new Y40aUDAException(
		// "error.categoria.DataIntegrityViolationException", true, e);
		// }

		return resultado;
	}// end contarCategoriaFormaciones

	/**
	 * Deletes multiple rows in the Categoria table.
	 * 
	 * @param categoriaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Categoria> categoriaList) {
		for (Categoria categoriaAux : categoriaList) {
			this.categoriaDao.remove(categoriaAux);
		}
	}

	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria addCategoriaPerfil(Categoria categoria) {
		return this.categoriaDao.addCategoriaPerfil(categoria);
	}

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCategoriaPerfil(Categoria categoria) {
		this.categoriaDao.removeCategoriaPerfil(categoria);
	}

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	public Categoria findCategoriaPerfil(Categoria categoria, Perfil perfil,
			Pagination pagination) {
		return this.categoriaDao.findCategoriaPerfil(categoria, perfil,
				pagination);
	}

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	public List<CategoriaPerfil> findAllCategoriaPerfil(Categoria categoria,
			Pagination pagination) {

		String idCategoriaPadre = null;
		if (categoria != null && categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			idCategoriaPadre = categoria.getCategoria().getIdCat();
		}
		List<Perfil> lstPerfil = this.perfilDao.findAllPerfilesCategoria(null,
				idCategoriaPadre, pagination);

		Categoria categoriaAux = this.categoriaDao.findCategoriaPerfil(
				categoria, new Perfil(), pagination);

		List<Perfil> lstPerfilesCategoria = categoriaAux.getPerfils();

		List<CategoriaPerfil> lstCategoriasPerfil = new ArrayList<CategoriaPerfil>();

		for (Perfil perfilAux : lstPerfil) {

			boolean encontrado = false;
			Iterator<Perfil> it = lstPerfilesCategoria.iterator();
			while (it.hasNext() && !encontrado) {
				Perfil perfilCategoria = (Perfil) it.next();
				if (perfilAux.getIdPerfil().equals(
						perfilCategoria.getIdPerfil())) {
					encontrado = true;
					lstCategoriasPerfil.add(new CategoriaPerfil(perfilAux
							.getIdPerfil(), perfilAux.getNombreEs(), perfilAux
							.getNombreEu(), Y40aConstantes.SI));
				}
			}

			if (!encontrado) {
				lstCategoriasPerfil.add(new CategoriaPerfil(perfilAux
						.getIdPerfil(), perfilAux.getNombreEs(), perfilAux
						.getNombreEu(), Y40aConstantes.NO));
			}
		}

		return lstCategoriasPerfil;

	}

	/**
	 * Counts rows in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @return List
	 */
	public Long findCategoriaPerfilCount(Categoria categoria, Perfil perfil) {
		return this.categoriaDao.findCategoriaPerfilCount(categoria, perfil);
	}

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Categoria addCategoriaGrupos(Categoria categoria) {
		return this.categoriaDao.addCategoriaGrupos(categoria);
	}

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCategoriaGrupos(Categoria categoria) {
		this.categoriaDao.removeCategoriaGrupos(categoria);
	}

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	public Categoria findCategoriaGrupos(Categoria categoria, Grupo grupo,
			Pagination pagination) {
		return this.categoriaDao.findCategoriaGrupos(categoria, grupo,
				pagination);
	}

	/**
	 * Find a single row in the findAllCategoriaGrupos Many To Many
	 * relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Grupo> findAllCategoriaGrupos(Categoria categoria,
			Pagination pagination) {
		categoria = this.categoriaDao.findCategoriaGrupos(categoria, null,
				pagination);

		return categoria.getGrupos();
	}

	/**
	 * Counts rows in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @return List
	 */
	public Long findCategoriaGruposCount(Categoria categoria, Grupo grupo) {
		return this.categoriaDao.findCategoriaGruposCount(categoria, grupo);
	}

	/**
	 * Getter method for CategoriaDao
	 * 
	 * @return CategoriaDao
	 */
	public CategoriaDao getCategoriaDao() {
		return this.categoriaDao;
	}

	/**
	 * Setter method for CategoriaDao.
	 * 
	 * @param categoriaDao
	 *            CategoriaDao
	 * @return
	 */
	public void setCategoriaDao(CategoriaDao categoriaDao) {
		logger.info("Setting Dependency " + categoriaDao);
		this.categoriaDao = categoriaDao;
	}

	/**
	 * Borra una categortia/campaña y todas sus hijas y formaciones que no
	 * tengan ninguna solicitud.
	 * 
	 * @param y40aCategoriaTreeFiltro
	 *            Y40aCategoriaTree
	 * @param mostrarOcultasWeb
	 *            boolean
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 */
	private void removeCategoriaTree(Y40aCategoriaTree y40aCategoriaTreeFiltro) {

		Categoria categoriaAux = new Categoria();
		Categoria categoriaPadre = new Categoria();
		categoriaPadre.setIdCat(y40aCategoriaTreeFiltro.getIdCat());
		categoriaAux.setCategoria(categoriaPadre);

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		// busca todas las hijas de una categoria
		List<Categoria> lstCategoriaChildren = this.categoriaDao.findAll(
				categoriaAux, pagination);
		if (lstCategoriaChildren.size() > 0) {
			// si tiene categorias hijas, sigue buscado
			// List<Object> lstCategoriasTree = new ArrayList();

			for (Categoria categoria : lstCategoriaChildren) {
				Y40aCategoriaTree y40aCategoriaTree = new Y40aCategoriaTree();
				y40aCategoriaTree.setIdCat(categoria.getIdCat());
				y40aCategoriaTree.setCategoriaPadreId(categoria.getCategoria()
						.getIdCat());
				y40aCategoriaTree.setNombreEs(categoria.getNombreEs());
				y40aCategoriaTree.setNombreEu(categoria.getNombreEu());
				y40aCategoriaTree.setVisibleWeb(categoria.getVisibleWeb());

				this.removeCategoriaTree(y40aCategoriaTree);
				// lstCategoriasTree.add(y40aCategoriaTree);
			}// end for

			// busca las formaciones de una categoria
			Formacion formacionAux = new Formacion();
			formacionAux.setCategoria(categoriaPadre);
			List<Formacion> lstFormacionChildren = this.formacionDao.findAll(
					formacionAux, pagination);

			// SI lstFormacionChildren SI NO ESTA VACIA BUSCAR SOLICITUDES
			for (Formacion formacion : lstFormacionChildren) {
				// Buscar solicitudes
				Long numSolicitudes = this.formacionDao
						.findFormacionSolicitudCount(formacion);
				// si no tienen solicitudes
				if (numSolicitudes.longValue() == 0) {
					// borrar etiquete-formacion
					this.formacionDao.removeAllFormacionEtiqueta(formacion);
					// borrar formacion
					this.formacionDao.remove(formacion);
				} else {
					// Si tiene solicitudes no se puede borrar
					throw new Y40aUDAException(
							"error.categoria.solicitudes.DataIntegrityViolationException",
							true, new Exception());
				}
			}// end for
				// si tenia formaciones se han borrado, ahora hay que borrar
				// categoria-grupo, categoria-perfil y categoria
			this.categoriaDao.removeAllCategoriaGrupos(categoriaPadre);
			this.categoriaDao.removeAllCategoriaPerfil(categoriaPadre);
			this.categoriaDao.remove(categoriaPadre);
		} else {
			// si no tiene categorias hijas
			// busca las formaciones de una categoria
			Formacion formacionAux = new Formacion();
			formacionAux.setCategoria(categoriaPadre);
			List<Formacion> lstFormacionChildren = this.formacionDao.findAll(
					formacionAux, pagination);

			// SI lstFormacionChildren SI NO ESTA VACIA BUSCAR SOLICITUDES
			for (Formacion formacion : lstFormacionChildren) {
				// Buscar solicitudes
				Long numSolicitudes = this.formacionDao
						.findFormacionSolicitudCount(formacion);
				// si no tienen solicitudes
				if (numSolicitudes.longValue() == 0) {
					// borrar etiquete-formacion
					this.formacionDao.removeAllFormacionEtiqueta(formacion);
					// borrar formacion
					this.formacionDao.remove(formacion);
				} else {
					// Si tiene solicitudes
					throw new Y40aUDAException(
							"error.categoria.solicitudes.DataIntegrityViolationException",
							true, new Exception());
				}
			}// end for
				// si tenia formaciones se han borrado, ahora hay que borrar
				// categoria-grupo, categoria-perfil y categoria
			this.categoriaDao.removeAllCategoriaGrupos(categoriaPadre);
			this.categoriaDao.removeAllCategoriaPerfil(categoriaPadre);
			this.categoriaDao.remove(categoriaPadre);
		}// end else
	}// end removeCategoriaTree

	/**
	 * Busca todas las categorias/campañas y sus hijas.
	 * 
	 * @param categoria
	 *            Categoria desde la que se busca
	 * @param arrCat
	 *            List<Categoria> donde se deja todas las categorias encontradas
	 */
	public void contarCategorias(Categoria categoria, List<Categoria> arrCat) {

		Categoria categoriaAux = new Categoria();
		Categoria categoriaPadre = new Categoria();
		categoriaPadre.setIdCat(categoria.getIdCat());
		categoriaAux.setCategoria(categoriaPadre);

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		// busca info. de todas las hijas de la categoria seleccionada en
		// pantalla
		List<Categoria> lstCategoriaChildren = this.categoriaDao.findAll(
				categoriaAux, pagination);
		if (lstCategoriaChildren.size() > 0) {
			// si encuentra hijas, por cada hija la contabiliza
			arrCat.add(categoria);
			for (Categoria categoriaHijo : lstCategoriaChildren) {
				// arrCat.add(categoria);
				this.contarCategorias(categoriaHijo, arrCat);
			}// end for
		} else {
			arrCat.add(categoria);
		}// end else
	}// end contarCategorias

	/**
	 * Busca todas las formaciones de una categoria/campaña
	 * 
	 * @param lstCategoria
	 *            List<Categoria> con todas las categorias para las que se busca
	 *            sus formaciones
	 * @param arrForm
	 *            List<Formacion> donde van todas las formaciones encontradas
	 */
	private void contarFormacionesCategorias(List<Categoria> lstCategoria,
			List<Formacion> arrForm) {

		Locale locale = LocaleContextHolder.getLocale();
		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		Formacion formacionAux = new Formacion();
		for (Categoria categoria : lstCategoria) {
			// busca las formaciones
			formacionAux.setCategoria(categoria);

			// Busca las formaciones de la categoria
			List<Formacion> lstFormacionChildren = this.formacionDao.findAll(
					formacionAux, pagination);
			for (Formacion forma : lstFormacionChildren) {
				arrForm.add(forma);
			}// end for(forma)
			formacionAux = new Formacion();
		}// end for(categoria)
	}// end contarFormacionesCategorias

}
