package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.CategoriaPerfil;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Perfil;

/**
 * * CategoriaService  
 * 
 *  
 */

public interface CategoriaService {

	/**
	 * Inserts a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria add(Categoria categoria);

	/**
	 * Inserts a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria addCategoria(Categoria categoria);

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria update(Categoria categoria);

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria updateCategoria(Categoria categoria);

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria updateVisibleWeb(Categoria categoria);

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria find(Categoria categoria);

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria findCategoria(Categoria categoria);

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria findCategoriaPadre(Categoria categoria);

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Categoria> findAll(Categoria categoria, Pagination pagination);

	/**
	 * Counts rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	Long findAllCount(Categoria categoria);

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 * @return List
	 */
	List<Categoria> findAllCategoriaSeguridad(Categoria categoria,
			Vector<String> perfiles, List<Grupo> grupos);

	/**
	 * Finds rows in the Categoria table using like.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Categoria> findAllLike(Categoria categoria, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void remove(Categoria categoria);

	/**
	 * Deletes a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void removeCategoria(Categoria categoria);

	/**
	 * Deletes multiple rows in the Categoria table.
	 * 
	 * @param categoriaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Categoria> categoriaList);

	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria addCategoriaPerfil(Categoria categoria);

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 */
	void removeCategoriaPerfil(Categoria categoria);

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	Categoria findCategoriaPerfil(Categoria categoria, Perfil perfil,
			Pagination pagination);

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	List<CategoriaPerfil> findAllCategoriaPerfil(Categoria categoria,
			Pagination pagination);

	/**
	 * Counts rows in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @return List
	 */
	Long findCategoriaPerfilCount(Categoria categoria, Perfil perfil);

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria addCategoriaGrupos(Categoria categoria);

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 */
	void removeCategoriaGrupos(Categoria categoria);

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	Categoria findCategoriaGrupos(Categoria categoria, Grupo grupo,
			Pagination pagination);

	/**
	 * Counts rows in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @return List
	 */
	Long findCategoriaGruposCount(Categoria categoria, Grupo grupo);

	/**
	 * Busca todas las categorias/campañas y sus hijas.
	 * 
	 * @param categoria
	 *            Categoria desde la que se busca
	 * @param arrCat
	 *            List<Categoria> donde se deja todas las categorias encontradas
	 */
	void contarCategorias(Categoria categoria, List<Categoria> arrCat);

	/**
	 * Cuenta el numero total de categorías/campañas junto con todas sus
	 * formaciones que no tengan solicitudes.
	 * 
	 * @param y40aCategoriaTreeFiltro
	 *            Y40aCategoriaTree
	 * @param mostrarOcultasWeb
	 *            boolean
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 */
	HashMap<String, Object> contarCategoriaFormaciones(Categoria categoria);

}
