package com.ejie.y40a.service;

import java.util.List;

import com.ejie.y40a.model.Categoria;

/**
 * * CategoriaService  
 * 
 *  
 */

public interface CampaniaService {

	/**
	 * Busca todas las categorias/campañas y sus hijas.
	 * 
	 * @param categoria
	 *            Categoria desde la que se busca
	 * @return List<Categoria> donde se deja todas las categorias encontradas
	 */
	List<Categoria> dameCategorias(Categoria categoria);

	/**
	 * Guarda las formaciones asociados a la categoria vieja para la categoria
	 * nueva
	 * 
	 * @param newLstCategorias
	 *            List<Categoria> lista con todas las categorias que se acaban
	 *            de copiar
	 * @param lstCategorias
	 *            List<Categoria> lista con todas las categorias de las que se
	 *            quiere copiar sus formaciones
	 */
	void guardaFormacionesCategoria(Categoria categoria, String idOldCat);

	/**
	 * Partiendo de una campania ya existente, copia todas sus categorias hijas
	 * y formaciones asociadas, creando una campania nueva.
	 * 
	 * @param categoria
	 *            Categoria objecto con la informacion de la campania
	 */
	public void copiaCampaina(Categoria categoria);
}
