package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.GrupoDao;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Y40aArbolGrupos;
import com.ejie.y40a.model.Y40aGrupoTree;

/**
 * ArbolCategoriasServiceImpl  
 * 
 *  
 */
@Service(value = "arbolGruposService")
public class ArbolGruposServiceImpl implements ArbolGruposService {

	@Autowired()
	private GrupoDao grupoDao;

	@Override()
	public Y40aArbolGrupos obtenerArbol(boolean mostrarNoActivas,
			String idCategoriaPadre, Pagination pagination) {

		List<Y40aGrupoTree> lstGrupos = new ArrayList<Y40aGrupoTree>();

		Locale locale = LocaleContextHolder.getLocale();
		pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBRE_ES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBRE_EU");
			pagination.setAscDsc("ASC");
		}

		Grupo grupo = new Grupo();

		if (mostrarNoActivas) {
			grupo.setActiva(null);
		} else {
			grupo.setActiva(Y40aConstantes.SI);
		}

		List<Grupo> lstGrupo = this.grupoDao.findAllGruposCategoria(grupo,
				idCategoriaPadre, pagination);

		for (Grupo grupoAux : lstGrupo) {

			Y40aGrupoTree y40aGrupoTree = new Y40aGrupoTree();

			y40aGrupoTree.setGrupoId(grupoAux.getGrupoId());
			y40aGrupoTree.setNivel(grupoAux.getNivel());
			y40aGrupoTree.setNombreEs(grupoAux.getNombreEs());
			y40aGrupoTree.setNombreEu(grupoAux.getNombreEu());
			y40aGrupoTree.setGrupoPadreId(grupoAux.getGrupoPadreId());
			y40aGrupoTree.setActiva(grupoAux.getActiva());

			if (this.tieneEntidadesOfertaFormativa(y40aGrupoTree,
					mostrarNoActivas, idCategoriaPadre, pagination)) {
				y40aGrupoTree = this.obtieneGrupo(y40aGrupoTree,
						mostrarNoActivas, idCategoriaPadre, pagination);

				lstGrupos.add(y40aGrupoTree);
			}

		}

		Y40aArbolGrupos tree = new Y40aArbolGrupos();
		tree.setLstGrupos(lstGrupos);

		return tree;
	}

	/**
	 * 
	 * @param y40aGrupoTreeFiltro
	 *            Y40aGrupoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param idCategoriaPadre
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return Y40aGrupoTree
	 */
	private Y40aGrupoTree obtieneGrupo(Y40aGrupoTree y40aGrupoTreeFiltro,
			boolean mostrarNoActivas, String idCategoriaPadre,
			Pagination pagination) {

		Grupo grupoAux = new Grupo();
		grupoAux.setGrupoPadreId(y40aGrupoTreeFiltro.getGrupoId());

		if (mostrarNoActivas) {
			grupoAux.setActiva(null);
		} else {
			grupoAux.setActiva(Y40aConstantes.SI);
		}

		List<Grupo> lstGrupoChildren = this.grupoDao.findAllGruposCategoria(
				grupoAux, idCategoriaPadre, pagination);

		if (lstGrupoChildren.size() > 0) {
			List<Y40aGrupoTree> lstGrupoTree = new ArrayList<Y40aGrupoTree>();

			for (Grupo grupo : lstGrupoChildren) {

				Y40aGrupoTree y40aGrupoTree = new Y40aGrupoTree();

				y40aGrupoTree.setGrupoId(grupo.getGrupoId());
				y40aGrupoTree.setNivel(grupo.getNivel());
				y40aGrupoTree.setNombreEs(grupo.getNombreEs());
				y40aGrupoTree.setNombreEu(grupo.getNombreEu());
				y40aGrupoTree.setGrupoPadreId(grupo.getGrupoPadreId());
				y40aGrupoTree.setActiva(grupo.getActiva());

				if (this.tieneEntidadesOfertaFormativa(y40aGrupoTree,
						mostrarNoActivas, idCategoriaPadre, pagination)) {
					y40aGrupoTree = this.obtieneGrupo(y40aGrupoTree,
							mostrarNoActivas, idCategoriaPadre, pagination);

					lstGrupoTree.add(y40aGrupoTree);
				}
			}
			y40aGrupoTreeFiltro.setLstChildren(lstGrupoTree);

		}

		return y40aGrupoTreeFiltro;
	}

	/**
	 * 
	 * @param y40aGrupoTreeFiltro
	 *            Y40aGrupoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param idCategoriaPadre
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return boolean
	 */
	private boolean tieneEntidadesOfertaFormativa(
			Y40aGrupoTree y40aGrupoTreeFiltro, boolean mostrarNoActivas,
			String idCategoriaPadre, Pagination pagination) {

		// comprobar si tiene entidades de orfeta formativa
		// Si tiene return true:
		// Si no tiene se buscan sus hijos y por cada hijo se mira si tiene
		// entidades de oferta formativa
		// si no tiene ninguno return false.

		boolean entidadesOFE = false;

		Long numEntidades = this.grupoDao
				.countEntidadesOFE(y40aGrupoTreeFiltro);

		if (numEntidades > 0) {
			return true;
		} else {
			Grupo grupoAux = new Grupo();
			grupoAux.setGrupoPadreId(y40aGrupoTreeFiltro.getGrupoId());

			List<Grupo> lstGrupoChildren = this.grupoDao
					.findAllGruposCategoria(grupoAux, idCategoriaPadre, null);

			if (lstGrupoChildren.size() > 0) {
				for (Grupo grupo : lstGrupoChildren) {

					Y40aGrupoTree y40aGrupoTree = new Y40aGrupoTree();

					y40aGrupoTree.setGrupoId(grupo.getGrupoId());
					y40aGrupoTree.setNivel(grupo.getNivel());
					y40aGrupoTree.setNombreEs(grupo.getNombreEs());
					y40aGrupoTree.setNombreEu(grupo.getNombreEu());
					y40aGrupoTree.setGrupoPadreId(grupo.getGrupoPadreId());
					y40aGrupoTree.setActiva(grupo.getActiva());

					entidadesOFE = this.tieneEntidadesOfertaFormativa(
							y40aGrupoTree, mostrarNoActivas, idCategoriaPadre,
							pagination);
					if (entidadesOFE) {
						return entidadesOFE;
					}
				}
				return false;
			} else {
				return false;
			}
		}
	}
}
