package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.CategoriaDao;
import com.ejie.y40a.dao.FormacionDao;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Y40aArbolFormaciones;
import com.ejie.y40a.model.Y40aCategoriaTree;
import com.ejie.y40a.model.Y40aFormacionTree;

/**
 * ArbolFormacionesServiceImpl  
 * 
 *  
 */
@Service(value = "arbolFormacionesServiceImpl")
public class ArbolFormacionesServiceImpl implements ArbolFormacionesService {

	@Autowired()
	private CategoriaDao categoriaDao;
	@Autowired()
	private FormacionDao formacionDao;

	@Override()
	public Y40aArbolFormaciones obtenerArbol(boolean mostrarOcultasWeb,
			Vector<String> perfiles, List<Grupo> grupos) {

		List<Y40aCategoriaTree> lstCategorias = new ArrayList<Y40aCategoriaTree>();

		Categoria categoria = new Categoria();

		// Obtenemos los grupos
		categoria.setIdCat(null);
		categoria.setCategoria(null);

		if (mostrarOcultasWeb) {
			categoria.setVisibleWeb(null);
		} else {
			categoria.setVisibleWeb(Y40aConstantes.SI);
		}

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		List<Categoria> lstCategoria = this.categoriaDao
				.findAllCategoriaSeguridad(categoria, perfiles, grupos,
						pagination);

		for (Categoria categoriaAux : lstCategoria) {

			Y40aCategoriaTree y40aCategoriaTree = new Y40aCategoriaTree();
			y40aCategoriaTree.setIdCat(categoriaAux.getIdCat());
			y40aCategoriaTree.setCategoriaPadreId(categoriaAux.getCategoria()
					.getIdCat());
			y40aCategoriaTree.setNombreEs(categoriaAux.getNombreEs());
			y40aCategoriaTree.setNombreEu(categoriaAux.getNombreEu());
			y40aCategoriaTree.setVisibleWeb(categoriaAux.getVisibleWeb());

			y40aCategoriaTree = this.obtieneCategoriaTree(y40aCategoriaTree,
					mostrarOcultasWeb, perfiles, grupos);
			lstCategorias.add(y40aCategoriaTree);
		}

		Y40aArbolFormaciones tree = new Y40aArbolFormaciones();
		tree.setLstCategorias(lstCategorias);

		return tree;
	}

	/**
	 * 
	 * @param y40aCategoriaTreeFiltro
	 *            Y40aCategoriaTree
	 * @param mostrarOcultasWeb
	 *            boolean
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 * @return Y40aCategoriaTree
	 */
	private Y40aCategoriaTree obtieneCategoriaTree(
			Y40aCategoriaTree y40aCategoriaTreeFiltro,
			boolean mostrarOcultasWeb, Vector<String> perfiles,
			List<Grupo> grupos) {

		Categoria categoriaAux = new Categoria();
		Categoria categoriaPadre = new Categoria();
		categoriaPadre.setIdCat(y40aCategoriaTreeFiltro.getIdCat());
		categoriaAux.setCategoria(categoriaPadre);

		if (mostrarOcultasWeb) {
			categoriaAux.setVisibleWeb(null);
		} else {
			categoriaAux.setVisibleWeb(Y40aConstantes.SI);
		}

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		List<Categoria> lstCategoriaChildren = this.categoriaDao
				.findAllCategoriaSeguridad(categoriaAux, perfiles, grupos,
						pagination);

		if (lstCategoriaChildren.size() > 0) {
			List<Object> lstCategoriasTree = new ArrayList();

			for (Categoria categoria : lstCategoriaChildren) {

				Y40aCategoriaTree y40aCategoriaTree = new Y40aCategoriaTree();
				y40aCategoriaTree.setIdCat(categoria.getIdCat());
				y40aCategoriaTree.setCategoriaPadreId(categoria.getCategoria()
						.getIdCat());
				y40aCategoriaTree.setNombreEs(categoria.getNombreEs());
				y40aCategoriaTree.setNombreEu(categoria.getNombreEu());
				y40aCategoriaTree.setVisibleWeb(categoria.getVisibleWeb());

				y40aCategoriaTree = this.obtieneCategoriaTree(
						y40aCategoriaTree, mostrarOcultasWeb, perfiles, grupos);
				lstCategoriasTree.add(y40aCategoriaTree);

			}

			Formacion formacionAux = new Formacion();
			formacionAux.setCategoria(categoriaPadre);

			if (mostrarOcultasWeb) {
				formacionAux.setVisibleWeb(null);
			} else {
				formacionAux.setVisibleWeb(Y40aConstantes.SI);
			}

			// Buscar las formaciones
			List<Formacion> lstFormacionChildren = this.formacionDao.findAll(
					formacionAux, pagination);

			// Añadirlas a lstCategoriasTree
			for (Formacion formacion : lstFormacionChildren) {

				Y40aFormacionTree y40aFormacionTree = new Y40aFormacionTree();
				y40aFormacionTree.setIdFor(formacion.getIdFor());
				y40aFormacionTree.setCategoriaPadreId(formacion.getCategoria()
						.getIdCat());
				y40aFormacionTree.setNombreEs(formacion.getNombreEs());
				y40aFormacionTree.setNombreEu(formacion.getNombreEu());
				y40aFormacionTree.setVisibleWeb(formacion.getVisibleWeb());

				lstCategoriasTree.add(y40aFormacionTree);

			}

			y40aCategoriaTreeFiltro.setLstChildren(lstCategoriasTree);

		} else {
			List<Object> lstCategoriasTree = new ArrayList();

			Formacion formacionAux = new Formacion();
			formacionAux.setCategoria(categoriaPadre);

			if (mostrarOcultasWeb) {
				formacionAux.setVisibleWeb(null);
			} else {
				formacionAux.setVisibleWeb(Y40aConstantes.SI);
			}

			// Buscar las formaciones
			List<Formacion> lstFormacionChildren = this.formacionDao.findAll(
					formacionAux, pagination);

			// Añadirlas a lstCategoriasTree
			for (Formacion formacion : lstFormacionChildren) {

				Y40aFormacionTree y40aFormacionTree = new Y40aFormacionTree();
				y40aFormacionTree.setIdFor(formacion.getIdFor());
				y40aFormacionTree.setCategoriaPadreId(formacion.getCategoria()
						.getIdCat());
				y40aFormacionTree.setNombreEs(formacion.getNombreEs());
				y40aFormacionTree.setNombreEu(formacion.getNombreEu());
				y40aFormacionTree.setVisibleWeb(formacion.getVisibleWeb());

				lstCategoriasTree.add(y40aFormacionTree);

			}

			y40aCategoriaTreeFiltro.setLstChildren(lstCategoriasTree);

		}

		return y40aCategoriaTreeFiltro;
	}
}
