package com.ejie.y40a.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.dao.CategoriaDao;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Y40aArbolCategorias;
import com.ejie.y40a.model.Y40aCategoriaTree;

/**
 * ArbolCategoriasServiceImpl  
 * 
 *  
 */
@Service(value = "arbolCategoriasService")
public class ArbolCategoriasServiceImpl implements ArbolCategoriasService {

	@Autowired()
	private CategoriaDao categoriaDao;

	@Override()
	public Y40aArbolCategorias obtenerArbol(boolean mostrarOcultasWeb,
			Vector<String> perfiles, List<Grupo> grupos) {

		List<Y40aCategoriaTree> lstCategorias = new ArrayList<Y40aCategoriaTree>();

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		Categoria categoria = new Categoria();

		// Obtenemos los grupos
		categoria.setIdCat(null);
		categoria.setCategoria(null);

		if (mostrarOcultasWeb) {
			categoria.setVisibleWeb(null);
		} else {
			categoria.setVisibleWeb(Y40aConstantes.SI);
		}

		List<Categoria> lstCategoria = this.categoriaDao
				.findAllCategoriaSeguridad(categoria, perfiles, grupos,
						pagination);

		for (Categoria categoriaAux : lstCategoria) {

			Y40aCategoriaTree y40aCategoriaTree = new Y40aCategoriaTree();
			y40aCategoriaTree.setIdCat(categoriaAux.getIdCat());
			y40aCategoriaTree.setCategoriaPadreId(categoriaAux.getCategoria()
					.getIdCat());
			y40aCategoriaTree.setNombreEs(categoriaAux.getNombreEs());
			y40aCategoriaTree.setNombreEu(categoriaAux.getNombreEu());
			y40aCategoriaTree.setVisibleWeb(categoriaAux.getVisibleWeb());

			y40aCategoriaTree = this.obtieneCategoriaTree(y40aCategoriaTree,
					mostrarOcultasWeb, perfiles, grupos);
			lstCategorias.add(y40aCategoriaTree);
		}

		Y40aArbolCategorias tree = new Y40aArbolCategorias();
		tree.setLstCategorias(lstCategorias);

		return tree;
	}

	/**
	 * 
	 * @param y40aCategoriaTreeFiltro
	 *            Y40aCategoriaTree
	 * @param mostrarOcultasWeb
	 *            boolean
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 * @return Y40aCategoriaTree
	 */
	private Y40aCategoriaTree obtieneCategoriaTree(
			Y40aCategoriaTree y40aCategoriaTreeFiltro,
			boolean mostrarOcultasWeb, Vector<String> perfiles,
			List<Grupo> grupos) {

		Categoria categoriaAux = new Categoria();
		Categoria categoriaPadre = new Categoria();
		categoriaPadre.setIdCat(y40aCategoriaTreeFiltro.getIdCat());
		categoriaAux.setCategoria(categoriaPadre);

		if (mostrarOcultasWeb) {
			categoriaAux.setVisibleWeb(null);
		} else {
			categoriaAux.setVisibleWeb(Y40aConstantes.SI);
		}

		Locale locale = LocaleContextHolder.getLocale();

		Pagination pagination = new Pagination();
		if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}

		List<Categoria> lstCategoriaChildren = this.categoriaDao
				.findAllCategoriaSeguridad(categoriaAux, perfiles, grupos,
						pagination);

		if (lstCategoriaChildren.size() > 0) {
			List<Y40aCategoriaTree> lstCategoriasTree = new ArrayList<Y40aCategoriaTree>();

			for (Categoria categoria : lstCategoriaChildren) {

				Y40aCategoriaTree y40aCategoriaTree = new Y40aCategoriaTree();
				y40aCategoriaTree.setIdCat(categoria.getIdCat());
				y40aCategoriaTree.setCategoriaPadreId(categoria.getCategoria()
						.getIdCat());
				y40aCategoriaTree.setNombreEs(categoria.getNombreEs());
				y40aCategoriaTree.setNombreEu(categoria.getNombreEu());
				y40aCategoriaTree.setVisibleWeb(categoria.getVisibleWeb());

				y40aCategoriaTree = this.obtieneCategoriaTree(
						y40aCategoriaTree, mostrarOcultasWeb, perfiles, grupos);
				lstCategoriasTree.add(y40aCategoriaTree);

			}
			y40aCategoriaTreeFiltro.setLstChildren(lstCategoriasTree);

		}

		return y40aCategoriaTreeFiltro;
	}

}
