package com.ejie.y40a.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
/*import org.springframework.format.annotation.NumberFormat;
 import org.springframework.format.annotation.NumberFormat.Style;
 import javax.validation.constraints.Digits;*/
import javax.validation.constraints.NotNull;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import com.ejie.y40a.control.Y40aJsonDateDeserializer;
import com.ejie.y40a.control.Y40aJsonDateSerializer;

/**
 * * Solicitud  
 * 
 *  
 */

public class SolicitudDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idSol;
	private Date fechaSol;

	// Formacion
	@NotEmpty(message = "required.nombreFormacionFormacion")
	private String idFor;
	private String nombreFormacionEs;
	private String nombreFormacionEu;
	private String jerarquiaFormacion;

	// Solicitante
	@NotEmpty(message = "required.nombreFormacionSolicitante")
	private String entidadId;
	private String nombreEs;
	private String nombreEu;
	private String noraProvinciaId;
	@Length(max = 20, message = "length.grupoFormacion")
	@NotEmpty(message = "required.grupoFormacion")
	private String grupo;
	@NotNull(message = "required.nuParticipantesFormacion")
	// @Digits(integer = 3, fraction = 0, message =
	// "length.nuParticipantesFormacion")
	// @NumberFormat(style = Style.NUMBER)
	private Long participantes;

	private String provincia;
	// @NotNull(message = "required.diaImparticionFormacion")
	private Date diaImparticion;
	// XXX Eliminar
	// XXX @Length(max = 20, message = "length.horarioImparticion")
	// XXX private String horarioImparticion;

	private String horaInicio;
	private String horaFin;

	// @Digits(integer = 3, fraction = 0, message = "length.asistentesFormaon")
	// @NumberFormat(style = Style.NUMBER)
	private Long asistentes;
	private Long numMujeres;
	private Long numHombres;
	private String cancelado;
	@NotEmpty(message = "required.idiomaFormacion")
	private String idioma;

	private String idsEtiquetas;
	private String descsEtiquetas;

	@Length(max = 2000, message = "length.observaciones")
	private String observaciones;

	// Datos del contacto
	@Length(max = 255, message = "length.nombapecontacto")
	private String nombapecontacto;
	@Length(max = 255, message = "length.emailcontacto")
	@Email(message = "error.emailcontacto")
	private String emailcontacto;
	@Length(max = 255, message = "length.telcontacto")
	private String telcontacto;
	@Length(max = 2000, message = "length.observasolicitante")
	private String observasolicitante;
	private String visibleContactoCat;
	private String bloqueada;

	private String idMotivo;

	/**
	 * Method 'Solicitud'.
	 * 
	 */
	public SolicitudDetalle() {
	}

	/**
	 * @param idSol
	 * @param fechaSol
	 * @param idFor
	 * @param nombreFormacionEs
	 * @param nombreFormacionEu
	 * @param jerarquiaFormacion
	 * @param entidadId
	 * @param nombreEs
	 * @param nombreEu
	 * @param noraProvinciaId
	 * @param grupo
	 * @param participantes
	 * @param provincia
	 * @param diaImparticion
	 * @param horarioImparticion
	 * @param asistentes
	 * @param numMujeres
	 * @param numHombres
	 * @param cancelado
	 * @param idioma
	 * @param idsEtiquetas
	 * @param descsEtiquetas
	 */
	public SolicitudDetalle(String idSol, Date fechaSol, String idFor,
			String nombreFormacionEs, String nombreFormacionEu,
			String jerarquiaFormacion, String entidadId, String nombreEs,
			String nombreEu, String noraProvinciaId, String grupo,
			Long participantes, String provincia,
			Date diaImparticion,
			// String horarioImparticion,
			String horaInicio, String horaFin, Long asistentes,
			Long numMujeres, Long numHombres, String cancelado, String idioma,
			String idsEtiquetas, String descsEtiquetas) {
		this.idSol = idSol;
		this.fechaSol = fechaSol;
		this.idFor = idFor;
		this.nombreFormacionEs = nombreFormacionEs;
		this.nombreFormacionEu = nombreFormacionEu;
		this.jerarquiaFormacion = jerarquiaFormacion;
		this.entidadId = entidadId;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.noraProvinciaId = noraProvinciaId;
		this.grupo = grupo;
		this.participantes = participantes;
		this.provincia = provincia;
		this.diaImparticion = diaImparticion;
		// XXX this.horarioImparticion = horarioImparticion;
		this.horaInicio = horaInicio;
		this.horaFin = horaFin;
		this.asistentes = asistentes;
		this.numMujeres = numMujeres;
		this.numHombres = numHombres;
		this.cancelado = cancelado;
		this.idioma = idioma;
		this.idsEtiquetas = idsEtiquetas;
		this.descsEtiquetas = descsEtiquetas;
	}

	/**
	 * Method 'getIdSol'.
	 * 
	 * @return String
	 */

	public String getIdSol() {
		return this.idSol;
	}

	/**
	 * Method 'setIdSol'.
	 * 
	 * @param idSol
	 *            String
	 * @return
	 */

	public void setIdSol(String idSol) {
		this.idSol = idSol;
	}

	/**
	 * Method 'getGrupo'.
	 * 
	 * @return String
	 */

	public String getGrupo() {
		return this.grupo;
	}

	/**
	 * Method 'setGrupo'.
	 * 
	 * @param grupo
	 *            String
	 * @return
	 */

	public void setGrupo(String grupo) {
		this.grupo = grupo;
	}

	/**
	 * Method 'getParticipantes'.
	 * 
	 * @return Long
	 */

	public Long getParticipantes() {
		return this.participantes;
	}

	/**
	 * Method 'setParticipantes'.
	 * 
	 * @param participantes
	 *            Long
	 * @return
	 */

	public void setParticipantes(Long participantes) {
		this.participantes = participantes;
	}

	/**
	 * Method 'getProvincia'.
	 * 
	 * @return String
	 */

	public String getProvincia() {
		return this.provincia;
	}

	/**
	 * Method 'setProvincia'.
	 * 
	 * @param provincia
	 *            String
	 * @return
	 */

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * @return the fechaSol
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSol() {
		return fechaSol;
	}

	/**
	 * @param fechaSol
	 *            the fechaSol to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSol(Date fechaSol) {
		this.fechaSol = fechaSol;
	}

	/**
	 * Method 'getDiaImparticion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getDiaImparticion() {
		return this.diaImparticion;
	}

	/**
	 * Method 'setDiaImparticion'.
	 * 
	 * @param diaImparticion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setDiaImparticion(Date diaImparticion) {
		this.diaImparticion = diaImparticion;
	}

	/**
	 * Method 'getHorarioImparticion'.
	 * 
	 * @return String
	 */

	// XXX public String getHorarioImparticion() {
	// return this.horarioImparticion;
	// }

	/**
	 * Method 'setHorarioImparticion'.
	 * 
	 * @param horarioImparticion
	 *            String
	 * @return
	 */

	// XXX public void setHorarioImparticion(String horarioImparticion) {
	// this.horarioImparticion = horarioImparticion;
	// }

	public String getHoraInicio() {
		return horaInicio;
	}

	public void setHoraInicio(String horaInicio) {
		this.horaInicio = horaInicio;
	}

	public String getHoraFin() {
		return horaFin;
	}

	public void setHoraFin(String horaFin) {
		this.horaFin = horaFin;
	}

	/**
	 * Method 'getAsistentes'.
	 * 
	 * @return Long
	 */

	public Long getAsistentes() {
		return this.asistentes;
	}

	/**
	 * Method 'setAsistentes'.
	 * 
	 * @param asistentes
	 *            Long
	 * @return
	 */

	public void setAsistentes(Long asistentes) {
		this.asistentes = asistentes;
	}

	public Long getNumMujeres() {
		return numMujeres;
	}

	public void setNumMujeres(Long numMujeres) {
		this.numMujeres = numMujeres;
	}

	public Long getNumHombres() {
		return numHombres;
	}

	public void setNumHombres(Long numHombres) {
		this.numHombres = numHombres;
	}

	/**
	 * Method 'getCancelado'.
	 * 
	 * @return String
	 */

	public String getCancelado() {
		return this.cancelado;
	}

	/**
	 * Method 'setCancelado'.
	 * 
	 * @param cancelado
	 *            String
	 * @return
	 */

	public void setCancelado(String cancelado) {
		this.cancelado = cancelado;
	}

	/**
	 * Method 'getIdioma'.
	 * 
	 * @return String
	 */

	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * Method 'setIdioma'.
	 * 
	 * @param idioma
	 *            String
	 * @return
	 */

	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * @return the idFor
	 */
	public String getIdFor() {
		return idFor;
	}

	/**
	 * @param idFor
	 *            the idFor to set
	 */
	public void setIdFor(String idFor) {
		this.idFor = idFor;
	}

	/**
	 * @return the nombreFormacionEs
	 */
	public String getNombreFormacionEs() {
		return nombreFormacionEs;
	}

	/**
	 * @param nombreFormacionEs
	 *            the nombreFormacionEs to set
	 */
	public void setNombreFormacionEs(String nombreFormacionEs) {
		this.nombreFormacionEs = nombreFormacionEs;
	}

	/**
	 * @return the nombreFormacionEu
	 */
	public String getNombreFormacionEu() {
		return nombreFormacionEu;
	}

	/**
	 * @param nombreFormacionEu
	 *            the nombreFormacionEu to set
	 */
	public void setNombreFormacionEu(String nombreFormacionEu) {
		this.nombreFormacionEu = nombreFormacionEu;
	}

	/**
	 * @return the jerarquiaFormacion
	 */
	public String getJerarquiaFormacion() {
		return jerarquiaFormacion;
	}

	/**
	 * @param jerarquiaFormacion
	 *            the jerarquiaFormacion to set
	 */
	public void setJerarquiaFormacion(String jerarquiaFormacion) {
		this.jerarquiaFormacion = jerarquiaFormacion;
	}

	/**
	 * @return the entidadId
	 */
	public String getEntidadId() {
		return entidadId;
	}

	/**
	 * @param entidadId
	 *            the entidadId to set
	 */
	public void setEntidadId(String entidadId) {
		this.entidadId = entidadId;
	}

	/**
	 * @return the nombreEs
	 */
	public String getNombreEs() {
		return nombreEs;
	}

	/**
	 * @param nombreEs
	 *            the nombreEs to set
	 */
	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * @return the nombreEu
	 */
	public String getNombreEu() {
		return nombreEu;
	}

	/**
	 * @param nombreEu
	 *            the nombreEu to set
	 */
	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * @return the idsEtiquetas
	 */
	public String getIdsEtiquetas() {
		return idsEtiquetas;
	}

	/**
	 * @param idsEtiquetas
	 *            the idsEtiquetas to set
	 */
	public void setIdsEtiquetas(String idsEtiquetas) {
		this.idsEtiquetas = idsEtiquetas;
	}

	/**
	 * @return the descsEtiquetas
	 */
	public String getDescsEtiquetas() {
		return descsEtiquetas;
	}

	/**
	 * @param descsEtiquetas
	 *            the descsEtiquetas to set
	 */
	public void setDescsEtiquetas(String descsEtiquetas) {
		this.descsEtiquetas = descsEtiquetas;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "SolicitudDetalle [idSol=" + idSol + ", fechaSol=" + fechaSol
				+ ", idFor=" + idFor + ", nombreFormacionEs="
				+ nombreFormacionEs + ", nombreFormacionEu="
				+ nombreFormacionEu + ", jerarquiaFormacion="
				+ jerarquiaFormacion + ", entidadId=" + entidadId
				+ ", nombreEs="
				+ nombreEs
				+ ", nombreEu="
				+ nombreEu
				+ ", grupo="
				+ grupo
				+ ", participantes="
				+ participantes
				+ ", provincia="
				+ provincia
				+ ", diaImparticion="
				+ diaImparticion // XXX ", horarioImparticion=" +
									// horarioImparticion
				+ ", horaInicio=" + horaInicio + ", horaFin=" + horaFin
				+ ", asistentes=" + asistentes + ", cancelado=" + cancelado
				+ ", idioma=" + idioma + ", idsEtiquetas=" + idsEtiquetas
				+ ", descsEtiquetas=" + descsEtiquetas + ", numMujeres="
				+ numMujeres + ", numHombres=" + numHombres + "]";
	}

	public void setNoraProvinciaId(String noraProvinciaId) {
		this.noraProvinciaId = noraProvinciaId;
	}

	public String getNoraProvinciaId() {
		return noraProvinciaId;
	}

	/**
	 * @param observaciones
	 *            the observaciones to set
	 */
	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	/**
	 * @return the observaciones
	 */
	public String getObservaciones() {
		return observaciones;
	}

	/**
	 * @param nombapecontacto
	 *            the nombapecontacto to set
	 */
	public void setNombapecontacto(String nombapecontacto) {
		this.nombapecontacto = nombapecontacto;
	}

	/**
	 * @return the nombapecontacto
	 */
	public String getNombapecontacto() {
		return nombapecontacto;
	}

	/**
	 * @param emailcontacto
	 *            the emailcontacto to set
	 */
	public void setEmailcontacto(String emailcontacto) {
		this.emailcontacto = emailcontacto;
	}

	/**
	 * @return the emailcontacto
	 */
	public String getEmailcontacto() {
		return emailcontacto;
	}

	/**
	 * @param telcontacto
	 *            the telcontacto to set
	 */
	public void setTelcontacto(String telcontacto) {
		this.telcontacto = telcontacto;
	}

	/**
	 * @return the telcontacto
	 */
	public String getTelcontacto() {
		return telcontacto;
	}

	/**
	 * @param observasolicitante
	 *            the observasolicitante to set
	 */
	public void setObservasolicitante(String observasolicitante) {
		this.observasolicitante = observasolicitante;
	}

	/**
	 * @return the observasolicitante
	 */
	public String getObservasolicitante() {
		return observasolicitante;
	}

	/**
	 * @param visibleContactoCat
	 *            the visibleContactoCat to set
	 */
	public void setVisibleContactoCat(String visibleContactoCat) {
		this.visibleContactoCat = visibleContactoCat;
	}

	/**
	 * @return the visibleContactoCat
	 */
	public String getVisibleContactoCat() {
		return visibleContactoCat;
	}

	/**
	 * @param bloqueada
	 *            the bloqueada to set
	 */
	public void setBloqueada(String bloqueada) {
		this.bloqueada = bloqueada;
	}

	/**
	 * @return the bloqueada
	 */
	public String getBloqueada() {
		return bloqueada;
	}

	/**
	 * @return the idMotivo
	 */
	public String getIdMotivo() {
		return idMotivo;
	}

	/**
	 * @param idMotivo
	 *            the idMotivo to set
	 */
	public void setIdMotivo(String idMotivo) {
		this.idMotivo = idMotivo;
	}

}
