package com.ejie.y40a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * * Solicitud  
 * 
 *  
 */

public class Solicitud implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idSol;
	private Date fechaSol;
	private Formacion formacion;
	private Entidad entidad;
	private String grupo;
	private Long participantes;
	private String provincia;
	private Date diaImparticion;
	// XXX private String horarioImparticion;
	private String horaInicio;
	private String horaFin;
	private Long asistentes;
	private Long numMujeres;
	private Long numHombres;
	private String cancelado;
	private String idioma;
	private List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
	private String observaciones;
	private String nombapecontacto;
	private String emailcontacto;
	private String telcontacto;
	private String observasolicitante;
	private String bloqueada;
	private String idMotivo;

	/**
	 * Method 'Solicitud'.
	 * 
	 */
	public Solicitud() {
	}

	/**
	 * @param idSol
	 * @param fechaSol
	 * @param formacion
	 * @param entidad
	 * @param grupo
	 * @param participantes
	 * @param provincia
	 * @param diaImparticion
	 * @param horarioImparticion
	 * @param asistentes
	 * @param numMujeres
	 * @param numHombres
	 * @param cancelado
	 * @param idioma
	 * @param bloqueada
	 * @param idMotivo
	 */
	public Solicitud(String idSol, Date fechaSol, Formacion formacion,
			Entidad entidad, String grupo,
			Long participantes,
			String provincia,
			Date diaImparticion, // XXX String horarioImparticion,
			String horaInicio, String horaFin, Long asistentes,
			Long numMujeres, Long numHombres, String cancelado, String idioma,
			String bloqueada, String idMotivo) {
		this.idSol = idSol;
		this.fechaSol = fechaSol;
		this.formacion = formacion;
		this.entidad = entidad;
		this.grupo = grupo;
		this.participantes = participantes;
		this.provincia = provincia;
		this.diaImparticion = diaImparticion;
		// XXX this.horarioImparticion = horarioImparticion;
		this.horaInicio = horaInicio;
		this.horaFin = horaFin;
		this.asistentes = asistentes;
		this.numMujeres = numMujeres;
		this.numHombres = numHombres;
		this.cancelado = cancelado;
		this.idioma = idioma;
		this.bloqueada = bloqueada;
		this.idMotivo = idMotivo;
	}

	/**
	 * @param idSol
	 * @param fechaSol
	 * @param formacion
	 * @param entidad
	 * @param grupo
	 * @param participantes
	 * @param provincia
	 * @param diaImparticion
	 * @param horarioImparticion
	 * @param asistentes
	 * @param numMujeres
	 * @param numHombres
	 * @param cancelado
	 * @param idioma
	 * @param bloqueada
	 * @param idMotivo
	 * @param etiquetas
	 */
	public Solicitud(String idSol, Date fechaSol, Formacion formacion,
			Entidad entidad, String grupo,
			Long participantes,
			String provincia,
			Date diaImparticion, // XXX String horarioImparticion,
			String horaInicio, String horaFin, Long asistentes,
			Long numMujeres, Long numHombres, String cancelado, String idioma,
			String bloqueada, String idMotivo, List<Etiqueta> etiquetas) {
		this.idSol = idSol;
		this.fechaSol = fechaSol;
		this.formacion = formacion;
		this.entidad = entidad;
		this.grupo = grupo;
		this.participantes = participantes;
		this.provincia = provincia;
		this.diaImparticion = diaImparticion;
		// XXX this.horarioImparticion = horarioImparticion;
		this.horaInicio = horaInicio;
		this.horaFin = horaFin;
		this.asistentes = asistentes;
		this.numMujeres = numMujeres;
		this.numHombres = numHombres;
		this.cancelado = cancelado;
		this.idioma = idioma;
		this.bloqueada = bloqueada;
		this.idMotivo = idMotivo;
		this.etiquetas = etiquetas;
	}

	/**
	 * Method 'getIdSol'.
	 * 
	 * @return String
	 */

	public String getIdSol() {
		return this.idSol;
	}

	/**
	 * Method 'setIdSol'.
	 * 
	 * @param idSol
	 *            String
	 * @return
	 */

	public void setIdSol(String idSol) {
		this.idSol = idSol;
	}

	/**
	 * Method 'getFormacion'.
	 * 
	 * @return Formacion
	 */
	@JsonIgnore
	public Formacion getFormacion() {
		return this.formacion;
	}

	/**
	 * Method 'setFormacion'.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */

	public void setFormacion(Formacion formacion) {
		this.formacion = formacion;
	}

	/**
	 * Method 'getEntidad'.
	 * 
	 * @return Entidad
	 */
	@JsonIgnore
	public Entidad getEntidad() {
		return this.entidad;
	}

	/**
	 * Method 'setEntidad'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */

	public void setEntidad(Entidad entidad) {
		this.entidad = entidad;
	}

	/**
	 * Method 'getGrupo'.
	 * 
	 * @return String
	 */

	public String getGrupo() {
		return this.grupo;
	}

	/**
	 * Method 'setGrupo'.
	 * 
	 * @param grupo
	 *            String
	 * @return
	 */

	public void setGrupo(String grupo) {
		this.grupo = grupo;
	}

	/**
	 * Method 'getParticipantes'.
	 * 
	 * @return Long
	 */

	public Long getParticipantes() {
		return this.participantes;
	}

	/**
	 * Method 'setParticipantes'.
	 * 
	 * @param participantes
	 *            Long
	 * @return
	 */

	public void setParticipantes(Long participantes) {
		this.participantes = participantes;
	}

	/**
	 * Method 'getProvincia'.
	 * 
	 * @return String
	 */

	public String getProvincia() {
		return this.provincia;
	}

	/**
	 * Method 'setProvincia'.
	 * 
	 * @param provincia
	 *            String
	 * @return
	 */

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * @return the fechaSol
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSol() {
		return fechaSol;
	}

	/**
	 * @param fechaSol
	 *            the fechaSol to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSol(Date fechaSol) {
		this.fechaSol = fechaSol;
	}

	/**
	 * Method 'getDiaImparticion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getDiaImparticion() {
		return this.diaImparticion;
	}

	/**
	 * Method 'setDiaImparticion'.
	 * 
	 * @param diaImparticion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setDiaImparticion(Date diaImparticion) {
		this.diaImparticion = diaImparticion;
	}

	/**
	 * Method 'getHorarioImparticion'.
	 * 
	 * @return String
	 */

	// XXX public String getHorarioImparticion() {
	// return this.horarioImparticion;
	// }

	/**
	 * Method 'setHorarioImparticion'.
	 * 
	 * @param horarioImparticion
	 *            String
	 * @return
	 */

	// XXXpublic void setHorarioImparticion(String horarioImparticion) {
	// this.horarioImparticion = horarioImparticion;
	// }

	public String getHoraInicio() {
		return horaInicio;
	}

	public void setHoraInicio(String horaInicio) {
		this.horaInicio = horaInicio;
	}

	public String getHoraFin() {
		return horaFin;
	}

	public void setHoraFin(String horaFin) {
		this.horaFin = horaFin;
	}

	/**
	 * Method 'getAsistentes'.
	 * 
	 * @return Long
	 */

	public Long getAsistentes() {
		return this.asistentes;
	}

	/**
	 * Method 'setAsistentes'.
	 * 
	 * @param asistentes
	 *            Long
	 * @return
	 */

	public void setAsistentes(Long asistentes) {
		this.asistentes = asistentes;
	}

	public Long getNumMujeres() {
		return numMujeres;
	}

	public void setNumMujeres(Long numMujeres) {
		this.numMujeres = numMujeres;
	}

	public Long getNumHombres() {
		return numHombres;
	}

	public void setNumHombres(Long numHombres) {
		this.numHombres = numHombres;
	}

	/**
	 * Method 'getCancelado'.
	 * 
	 * @return String
	 */

	public String getCancelado() {
		return this.cancelado;
	}

	/**
	 * Method 'setCancelado'.
	 * 
	 * @param cancelado
	 *            String
	 * @return
	 */

	public void setCancelado(String cancelado) {
		this.cancelado = cancelado;
	}

	/**
	 * Method 'getIdioma'.
	 * 
	 * @return String
	 */

	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * Method 'setIdioma'.
	 * 
	 * @param idioma
	 *            String
	 * @return
	 */

	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * Method 'getEtiquetas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Etiqueta> getEtiquetas() {
		return this.etiquetas;
	}

	/**
	 * Method 'setEtiquetas'.
	 * 
	 * @param etiquetas
	 *            List
	 * @return
	 */
	public void setEtiquetas(List<Etiqueta> etiquetas) {
		this.etiquetas = etiquetas;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Solicitud [idSol=" + idSol + ", fechaSol=" + fechaSol
				+ ", formacion="
				+ formacion
				+ ", entidad="
				+ entidad
				+ ", grupo="
				+ grupo
				+ ", participantes="
				+ participantes
				+ ", provincia="
				+ provincia
				+ ", diaImparticion="
				+ diaImparticion // XXX + ", horarioImparticion=" +
									// horarioImparticion
				+ ", horaInicio=" + horaInicio + ", horaFin=" + horaFin
				+ ", asistentes=" + asistentes + ", cancelado=" + cancelado
				+ ", idioma=" + idioma + ", etiquetas=" + etiquetas
				+ ", numMujeres=" + numMujeres + ", numHombres=" + numHombres
				+ "]";
	}

	/**
	 * @param observaciones
	 *            the observaciones to set
	 */
	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	/**
	 * @return the observaciones
	 */
	public String getObservaciones() {
		return observaciones;
	}

	/**
	 * @param nombapecontacto
	 *            the nombapecontacto to set
	 */
	public void setNombapecontacto(String nombapecontacto) {
		this.nombapecontacto = nombapecontacto;
	}

	/**
	 * @return the nombapecontacto
	 */
	public String getNombapecontacto() {
		return nombapecontacto;
	}

	/**
	 * @param emailcontacto
	 *            the emailcontacto to set
	 */
	public void setEmailcontacto(String emailcontacto) {
		this.emailcontacto = emailcontacto;
	}

	/**
	 * @return the emailcontacto
	 */
	public String getEmailcontacto() {
		return emailcontacto;
	}

	/**
	 * @param telcontacto
	 *            the telcontacto to set
	 */
	public void setTelcontacto(String telcontacto) {
		this.telcontacto = telcontacto;
	}

	/**
	 * @return the telcontacto
	 */
	public String getTelcontacto() {
		return telcontacto;
	}

	/**
	 * @param observasolicitante
	 *            the observasolicitante to set
	 */
	public void setObservasolicitante(String observasolicitante) {
		this.observasolicitante = observasolicitante;
	}

	/**
	 * @return the observasolicitante
	 */
	public String getObservasolicitante() {
		return observasolicitante;
	}

	/**
	 * @param bloqueada
	 *            the bloqueada to set
	 */
	public void setBloqueada(String bloqueada) {
		this.bloqueada = bloqueada;
	}

	/**
	 * @return the bloqueada
	 */
	public String getBloqueada() {
		return bloqueada;
	}

	/**
	 * @return the idMotivo
	 */
	public String getIdMotivo() {
		return idMotivo;
	}

	/**
	 * @param idMotivo
	 *            the idMotivo to set
	 */
	public void setIdMotivo(String idMotivo) {
		this.idMotivo = idMotivo;
	}

}
